# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class HealthcheckEvent(UncheckedBaseModel):
    """
    Healthcheck event sent periodically to verify your webhook endpoint is functional
    """

    type: typing.Literal["healthcheck"] = "healthcheck"
    creation_timestamp: str = pydantic.Field()
    """
    Timestamp when the event was created
    """

    trend_percentage: int = pydantic.Field()
    """
    Percentage change in trends
    """

    sent_webhooks_last_hour: int = pydantic.Field()
    """
    Number of webhooks sent in the last hour
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
