# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .heart_rate_data_sample import HeartRateDataSample
from .heart_rate_variability_data_sample_rmssd import HeartRateVariabilityDataSampleRmssd
from .heart_rate_variability_data_sample_sdnn import HeartRateVariabilityDataSampleSdnn


class HeartRateDataDetailed(UncheckedBaseModel):
    hr_samples: typing.Optional[typing.List[HeartRateDataSample]] = pydantic.Field(default=None)
    """
    Array of HeartRate data samples recorded for the user during the workout.
    """

    hrv_samples_rmssd: typing.Optional[typing.List[HeartRateVariabilityDataSampleRmssd]] = pydantic.Field(default=None)
    """
    Array of HeartRate Variability data samples recorded for the user during the workout, computed using RMSSD.
    """

    hrv_samples_sdnn: typing.Optional[typing.List[HeartRateVariabilityDataSampleSdnn]] = pydantic.Field(default=None)
    """
    Array of HeartRate Variability data samples recorded for the user during the workout, computed using SDNN.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
