# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .terra_user import TerraUser


class PermissionChangeEvent(UncheckedBaseModel):
    """
    Permission change event
    """

    type: typing.Literal["permission_change"] = "permission_change"
    user: TerraUser = pydantic.Field()
    """
    User who changed permissions
    """

    status: typing.Literal["warning"] = pydantic.Field(default="warning")
    """
    Status of the event
    """

    message: str = pydantic.Field()
    """
    Information about the permission change
    """

    version: str = pydantic.Field()
    """
    API version
    """

    scopes_added: str = pydantic.Field()
    """
    Newly added scopes
    """

    scopes_removed: str = pydantic.Field()
    """
    Removed scopes
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
