# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class TerraUser(UncheckedBaseModel):
    user_id: str = pydantic.Field()
    """
    Terra identifier for the wearable connection
    """

    provider: str = pydantic.Field()
    """
    Connection data source
    """

    last_webhook_update: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last time at which a webhook update was sent for the connection
    """

    scopes: typing.Optional[str] = pydantic.Field(default=None)
    """
    (when available) Permissions granted by the user during authentication - to be used as debugging metadata
    """

    reference_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Connection identifier on the developer's end, used to tie connection back to a user on the developer's platform
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    whether the user is active or not (inactive users will not receive any data updates and are in considered 
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
