import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementBackendConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#api_management_name ApiManagementBackend#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#description ApiManagementBackend#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#name ApiManagementBackend#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#protocol ApiManagementBackend#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#resource_group_name ApiManagementBackend#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#resource_id ApiManagementBackend#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#title ApiManagementBackend#title}.
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#url ApiManagementBackend#url}.
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * credentials block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#credentials ApiManagementBackend#credentials}
     *
     * @stability stable
     */
    readonly credentials?: ApiManagementBackendCredentials;
    /**
     * proxy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#proxy ApiManagementBackend#proxy}
     *
     * @stability stable
     */
    readonly proxy?: ApiManagementBackendProxy;
    /**
     * service_fabric_cluster block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#service_fabric_cluster ApiManagementBackend#service_fabric_cluster}
     *
     * @stability stable
     */
    readonly serviceFabricCluster?: ApiManagementBackendServiceFabricCluster;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#timeouts ApiManagementBackend#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementBackendTimeouts;
    /**
     * tls block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#tls ApiManagementBackend#tls}
     *
     * @stability stable
     */
    readonly tls?: ApiManagementBackendTls;
}
/**
 * @stability stable
 */
export interface ApiManagementBackendCredentialsAuthorization {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#parameter ApiManagementBackend#parameter}.
     *
     * @stability stable
     */
    readonly parameter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#scheme ApiManagementBackend#scheme}.
     *
     * @stability stable
     */
    readonly scheme?: string;
}
export declare function apiManagementBackendCredentialsAuthorizationToTerraform(struct?: ApiManagementBackendCredentialsAuthorizationOutputReference | ApiManagementBackendCredentialsAuthorization): any;
/**
 * @stability stable
 */
export declare class ApiManagementBackendCredentialsAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementBackendCredentialsAuthorization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementBackendCredentialsAuthorization | undefined);
    private _parameter?;
    /**
     * @stability stable
     */
    get parameter(): string;
    /**
     * @stability stable
     */
    set parameter(value: string);
    /**
     * @stability stable
     */
    resetParameter(): void;
    /**
     * @stability stable
     */
    get parameterInput(): string | undefined;
    private _scheme?;
    /**
     * @stability stable
     */
    get scheme(): string;
    /**
     * @stability stable
     */
    set scheme(value: string);
    /**
     * @stability stable
     */
    resetScheme(): void;
    /**
     * @stability stable
     */
    get schemeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementBackendCredentials {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#certificate ApiManagementBackend#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#header ApiManagementBackend#header}.
     *
     * @stability stable
     */
    readonly header?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#query ApiManagementBackend#query}.
     *
     * @stability stable
     */
    readonly query?: {
        [key: string]: string;
    };
    /**
     * authorization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#authorization ApiManagementBackend#authorization}
     *
     * @stability stable
     */
    readonly authorization?: ApiManagementBackendCredentialsAuthorization;
}
export declare function apiManagementBackendCredentialsToTerraform(struct?: ApiManagementBackendCredentialsOutputReference | ApiManagementBackendCredentials): any;
/**
 * @stability stable
 */
export declare class ApiManagementBackendCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementBackendCredentials | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementBackendCredentials | undefined);
    private _certificate?;
    /**
     * @stability stable
     */
    get certificate(): string[];
    /**
     * @stability stable
     */
    set certificate(value: string[]);
    /**
     * @stability stable
     */
    resetCertificate(): void;
    /**
     * @stability stable
     */
    get certificateInput(): string[] | undefined;
    private _header?;
    /**
     * @stability stable
     */
    get header(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set header(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetHeader(): void;
    /**
     * @stability stable
     */
    get headerInput(): {
        [key: string]: string;
    } | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set query(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetQuery(): void;
    /**
     * @stability stable
     */
    get queryInput(): {
        [key: string]: string;
    } | undefined;
    private _authorization;
    /**
     * @stability stable
     */
    get authorization(): ApiManagementBackendCredentialsAuthorizationOutputReference;
    /**
     * @stability stable
     */
    putAuthorization(value: ApiManagementBackendCredentialsAuthorization): void;
    /**
     * @stability stable
     */
    resetAuthorization(): void;
    /**
     * @stability stable
     */
    get authorizationInput(): ApiManagementBackendCredentialsAuthorization | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementBackendProxy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#password ApiManagementBackend#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#url ApiManagementBackend#url}.
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#username ApiManagementBackend#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function apiManagementBackendProxyToTerraform(struct?: ApiManagementBackendProxyOutputReference | ApiManagementBackendProxy): any;
/**
 * @stability stable
 */
export declare class ApiManagementBackendProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementBackendProxy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementBackendProxy | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementBackendServiceFabricClusterServerX509Name {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#issuer_certificate_thumbprint ApiManagementBackend#issuer_certificate_thumbprint}.
     *
     * @stability stable
     */
    readonly issuerCertificateThumbprint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#name ApiManagementBackend#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function apiManagementBackendServiceFabricClusterServerX509NameToTerraform(struct?: ApiManagementBackendServiceFabricClusterServerX509Name | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApiManagementBackendServiceFabricCluster {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#client_certificate_id ApiManagementBackend#client_certificate_id}.
     *
     * @stability stable
     */
    readonly clientCertificateId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#client_certificate_thumbprint ApiManagementBackend#client_certificate_thumbprint}.
     *
     * @stability stable
     */
    readonly clientCertificateThumbprint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#management_endpoints ApiManagementBackend#management_endpoints}.
     *
     * @stability stable
     */
    readonly managementEndpoints: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#max_partition_resolution_retries ApiManagementBackend#max_partition_resolution_retries}.
     *
     * @stability stable
     */
    readonly maxPartitionResolutionRetries: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#server_certificate_thumbprints ApiManagementBackend#server_certificate_thumbprints}.
     *
     * @stability stable
     */
    readonly serverCertificateThumbprints?: string[];
    /**
     * server_x509_name block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#server_x509_name ApiManagementBackend#server_x509_name}
     *
     * @stability stable
     */
    readonly serverX509Name?: ApiManagementBackendServiceFabricClusterServerX509Name[] | cdktf.IResolvable;
}
export declare function apiManagementBackendServiceFabricClusterToTerraform(struct?: ApiManagementBackendServiceFabricClusterOutputReference | ApiManagementBackendServiceFabricCluster): any;
/**
 * @stability stable
 */
export declare class ApiManagementBackendServiceFabricClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementBackendServiceFabricCluster | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementBackendServiceFabricCluster | undefined);
    private _clientCertificateId?;
    /**
     * @stability stable
     */
    get clientCertificateId(): string;
    /**
     * @stability stable
     */
    set clientCertificateId(value: string);
    /**
     * @stability stable
     */
    resetClientCertificateId(): void;
    /**
     * @stability stable
     */
    get clientCertificateIdInput(): string | undefined;
    private _clientCertificateThumbprint?;
    /**
     * @stability stable
     */
    get clientCertificateThumbprint(): string;
    /**
     * @stability stable
     */
    set clientCertificateThumbprint(value: string);
    /**
     * @stability stable
     */
    resetClientCertificateThumbprint(): void;
    /**
     * @stability stable
     */
    get clientCertificateThumbprintInput(): string | undefined;
    private _managementEndpoints?;
    /**
     * @stability stable
     */
    get managementEndpoints(): string[];
    /**
     * @stability stable
     */
    set managementEndpoints(value: string[]);
    /**
     * @stability stable
     */
    get managementEndpointsInput(): string[] | undefined;
    private _maxPartitionResolutionRetries?;
    /**
     * @stability stable
     */
    get maxPartitionResolutionRetries(): number;
    /**
     * @stability stable
     */
    set maxPartitionResolutionRetries(value: number);
    /**
     * @stability stable
     */
    get maxPartitionResolutionRetriesInput(): number | undefined;
    private _serverCertificateThumbprints?;
    /**
     * @stability stable
     */
    get serverCertificateThumbprints(): string[];
    /**
     * @stability stable
     */
    set serverCertificateThumbprints(value: string[]);
    /**
     * @stability stable
     */
    resetServerCertificateThumbprints(): void;
    /**
     * @stability stable
     */
    get serverCertificateThumbprintsInput(): string[] | undefined;
    private _serverX509Name?;
    /**
     * @stability stable
     */
    get serverX509Name(): ApiManagementBackendServiceFabricClusterServerX509Name[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set serverX509Name(value: ApiManagementBackendServiceFabricClusterServerX509Name[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetServerX509Name(): void;
    /**
     * @stability stable
     */
    get serverX509NameInput(): cdktf.IResolvable | ApiManagementBackendServiceFabricClusterServerX509Name[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementBackendTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#create ApiManagementBackend#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#delete ApiManagementBackend#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#read ApiManagementBackend#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#update ApiManagementBackend#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementBackendTimeoutsToTerraform(struct?: ApiManagementBackendTimeoutsOutputReference | ApiManagementBackendTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ApiManagementBackendTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementBackendTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementBackendTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementBackendTls {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#validate_certificate_chain ApiManagementBackend#validate_certificate_chain}.
     *
     * @stability stable
     */
    readonly validateCertificateChain?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend#validate_certificate_name ApiManagementBackend#validate_certificate_name}.
     *
     * @stability stable
     */
    readonly validateCertificateName?: boolean | cdktf.IResolvable;
}
export declare function apiManagementBackendTlsToTerraform(struct?: ApiManagementBackendTlsOutputReference | ApiManagementBackendTls): any;
/**
 * @stability stable
 */
export declare class ApiManagementBackendTlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementBackendTls | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementBackendTls | undefined);
    private _validateCertificateChain?;
    /**
     * @stability stable
     */
    get validateCertificateChain(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set validateCertificateChain(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetValidateCertificateChain(): void;
    /**
     * @stability stable
     */
    get validateCertificateChainInput(): boolean | cdktf.IResolvable | undefined;
    private _validateCertificateName?;
    /**
     * @stability stable
     */
    get validateCertificateName(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set validateCertificateName(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetValidateCertificateName(): void;
    /**
     * @stability stable
     */
    get validateCertificateNameInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend azurerm_api_management_backend}.
 *
 * @stability stable
 */
export declare class ApiManagementBackend extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_backend azurerm_api_management_backend} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementBackendConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _resourceId?;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    set resourceId(value: string);
    /**
     * @stability stable
     */
    resetResourceId(): void;
    /**
     * @stability stable
     */
    get resourceIdInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _credentials;
    /**
     * @stability stable
     */
    get credentials(): ApiManagementBackendCredentialsOutputReference;
    /**
     * @stability stable
     */
    putCredentials(value: ApiManagementBackendCredentials): void;
    /**
     * @stability stable
     */
    resetCredentials(): void;
    /**
     * @stability stable
     */
    get credentialsInput(): ApiManagementBackendCredentials | undefined;
    private _proxy;
    /**
     * @stability stable
     */
    get proxy(): ApiManagementBackendProxyOutputReference;
    /**
     * @stability stable
     */
    putProxy(value: ApiManagementBackendProxy): void;
    /**
     * @stability stable
     */
    resetProxy(): void;
    /**
     * @stability stable
     */
    get proxyInput(): ApiManagementBackendProxy | undefined;
    private _serviceFabricCluster;
    /**
     * @stability stable
     */
    get serviceFabricCluster(): ApiManagementBackendServiceFabricClusterOutputReference;
    /**
     * @stability stable
     */
    putServiceFabricCluster(value: ApiManagementBackendServiceFabricCluster): void;
    /**
     * @stability stable
     */
    resetServiceFabricCluster(): void;
    /**
     * @stability stable
     */
    get serviceFabricClusterInput(): ApiManagementBackendServiceFabricCluster | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementBackendTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementBackendTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementBackendTimeouts | undefined;
    private _tls;
    /**
     * @stability stable
     */
    get tls(): ApiManagementBackendTlsOutputReference;
    /**
     * @stability stable
     */
    putTls(value: ApiManagementBackendTls): void;
    /**
     * @stability stable
     */
    resetTls(): void;
    /**
     * @stability stable
     */
    get tlsInput(): ApiManagementBackendTls | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
