import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#client_certificate_enabled ApiManagement#client_certificate_enabled}.
     *
     * @stability stable
     */
    readonly clientCertificateEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#gateway_disabled ApiManagement#gateway_disabled}.
     *
     * @stability stable
     */
    readonly gatewayDisabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#location ApiManagement#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#min_api_version ApiManagement#min_api_version}.
     *
     * @stability stable
     */
    readonly minApiVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#name ApiManagement#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#notification_sender_email ApiManagement#notification_sender_email}.
     *
     * @stability stable
     */
    readonly notificationSenderEmail?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#policy ApiManagement#policy}.
     *
     * @stability stable
     */
    readonly policy?: ApiManagementPolicy[] | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#publisher_email ApiManagement#publisher_email}.
     *
     * @stability stable
     */
    readonly publisherEmail: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#publisher_name ApiManagement#publisher_name}.
     *
     * @stability stable
     */
    readonly publisherName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#resource_group_name ApiManagement#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#sku_name ApiManagement#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tags ApiManagement#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#virtual_network_type ApiManagement#virtual_network_type}.
     *
     * @stability stable
     */
    readonly virtualNetworkType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#zones ApiManagement#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * additional_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#additional_location ApiManagement#additional_location}
     *
     * @stability stable
     */
    readonly additionalLocation?: ApiManagementAdditionalLocation[] | cdktf.IResolvable;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate ApiManagement#certificate}
     *
     * @stability stable
     */
    readonly certificate?: ApiManagementCertificate[] | cdktf.IResolvable;
    /**
     * hostname_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#hostname_configuration ApiManagement#hostname_configuration}
     *
     * @stability stable
     */
    readonly hostnameConfiguration?: ApiManagementHostnameConfiguration;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#identity ApiManagement#identity}
     *
     * @stability stable
     */
    readonly identity?: ApiManagementIdentity;
    /**
     * protocols block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#protocols ApiManagement#protocols}
     *
     * @stability stable
     */
    readonly protocols?: ApiManagementProtocols;
    /**
     * security block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#security ApiManagement#security}
     *
     * @stability stable
     */
    readonly security?: ApiManagementSecurity;
    /**
     * sign_in block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#sign_in ApiManagement#sign_in}
     *
     * @stability stable
     */
    readonly signIn?: ApiManagementSignIn;
    /**
     * sign_up block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#sign_up ApiManagement#sign_up}
     *
     * @stability stable
     */
    readonly signUp?: ApiManagementSignUp;
    /**
     * tenant_access block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tenant_access ApiManagement#tenant_access}
     *
     * @stability stable
     */
    readonly tenantAccess?: ApiManagementTenantAccess;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#timeouts ApiManagement#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementTimeouts;
    /**
     * virtual_network_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#virtual_network_configuration ApiManagement#virtual_network_configuration}
     *
     * @stability stable
     */
    readonly virtualNetworkConfiguration?: ApiManagementVirtualNetworkConfiguration;
}
/**
 * @stability stable
 */
export interface ApiManagementPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#xml_content ApiManagement#xml_content}.
     *
     * @stability stable
     */
    readonly xmlContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#xml_link ApiManagement#xml_link}.
     *
     * @stability stable
     */
    readonly xmlLink?: string;
}
export declare function apiManagementPolicyToTerraform(struct?: ApiManagementPolicy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApiManagementAdditionalLocationVirtualNetworkConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#subnet_id ApiManagement#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function apiManagementAdditionalLocationVirtualNetworkConfigurationToTerraform(struct?: ApiManagementAdditionalLocationVirtualNetworkConfigurationOutputReference | ApiManagementAdditionalLocationVirtualNetworkConfiguration): any;
/**
 * @stability stable
 */
export declare class ApiManagementAdditionalLocationVirtualNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementAdditionalLocationVirtualNetworkConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementAdditionalLocationVirtualNetworkConfiguration | undefined);
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementAdditionalLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#location ApiManagement#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * virtual_network_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#virtual_network_configuration ApiManagement#virtual_network_configuration}
     *
     * @stability stable
     */
    readonly virtualNetworkConfiguration?: ApiManagementAdditionalLocationVirtualNetworkConfiguration;
}
export declare function apiManagementAdditionalLocationToTerraform(struct?: ApiManagementAdditionalLocation | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApiManagementCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate_password ApiManagement#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#encoded_certificate ApiManagement#encoded_certificate}.
     *
     * @stability stable
     */
    readonly encodedCertificate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#store_name ApiManagement#store_name}.
     *
     * @stability stable
     */
    readonly storeName: string;
}
export declare function apiManagementCertificateToTerraform(struct?: ApiManagementCertificate | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApiManagementHostnameConfigurationDeveloperPortal {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate ApiManagement#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate_password ApiManagement#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#host_name ApiManagement#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#key_vault_id ApiManagement#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationDeveloperPortalToTerraform(struct?: ApiManagementHostnameConfigurationDeveloperPortal | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApiManagementHostnameConfigurationManagement {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate ApiManagement#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate_password ApiManagement#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#host_name ApiManagement#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#key_vault_id ApiManagement#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationManagementToTerraform(struct?: ApiManagementHostnameConfigurationManagement | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApiManagementHostnameConfigurationPortal {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate ApiManagement#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate_password ApiManagement#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#host_name ApiManagement#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#key_vault_id ApiManagement#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationPortalToTerraform(struct?: ApiManagementHostnameConfigurationPortal | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApiManagementHostnameConfigurationProxy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate ApiManagement#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate_password ApiManagement#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#default_ssl_binding ApiManagement#default_ssl_binding}.
     *
     * @stability stable
     */
    readonly defaultSslBinding?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#host_name ApiManagement#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#key_vault_id ApiManagement#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationProxyToTerraform(struct?: ApiManagementHostnameConfigurationProxy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApiManagementHostnameConfigurationScm {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate ApiManagement#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#certificate_password ApiManagement#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#host_name ApiManagement#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#key_vault_id ApiManagement#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationScmToTerraform(struct?: ApiManagementHostnameConfigurationScm | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ApiManagementHostnameConfiguration {
    /**
     * developer_portal block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#developer_portal ApiManagement#developer_portal}
     *
     * @stability stable
     */
    readonly developerPortal?: ApiManagementHostnameConfigurationDeveloperPortal[] | cdktf.IResolvable;
    /**
     * management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#management ApiManagement#management}
     *
     * @stability stable
     */
    readonly management?: ApiManagementHostnameConfigurationManagement[] | cdktf.IResolvable;
    /**
     * portal block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#portal ApiManagement#portal}
     *
     * @stability stable
     */
    readonly portal?: ApiManagementHostnameConfigurationPortal[] | cdktf.IResolvable;
    /**
     * proxy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#proxy ApiManagement#proxy}
     *
     * @stability stable
     */
    readonly proxy?: ApiManagementHostnameConfigurationProxy[] | cdktf.IResolvable;
    /**
     * scm block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#scm ApiManagement#scm}
     *
     * @stability stable
     */
    readonly scm?: ApiManagementHostnameConfigurationScm[] | cdktf.IResolvable;
}
export declare function apiManagementHostnameConfigurationToTerraform(struct?: ApiManagementHostnameConfigurationOutputReference | ApiManagementHostnameConfiguration): any;
/**
 * @stability stable
 */
export declare class ApiManagementHostnameConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementHostnameConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementHostnameConfiguration | undefined);
    private _developerPortal?;
    /**
     * @stability stable
     */
    get developerPortal(): ApiManagementHostnameConfigurationDeveloperPortal[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set developerPortal(value: ApiManagementHostnameConfigurationDeveloperPortal[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeveloperPortal(): void;
    /**
     * @stability stable
     */
    get developerPortalInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationDeveloperPortal[] | undefined;
    private _management?;
    /**
     * @stability stable
     */
    get management(): ApiManagementHostnameConfigurationManagement[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set management(value: ApiManagementHostnameConfigurationManagement[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManagement(): void;
    /**
     * @stability stable
     */
    get managementInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationManagement[] | undefined;
    private _portal?;
    /**
     * @stability stable
     */
    get portal(): ApiManagementHostnameConfigurationPortal[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set portal(value: ApiManagementHostnameConfigurationPortal[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPortal(): void;
    /**
     * @stability stable
     */
    get portalInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationPortal[] | undefined;
    private _proxy?;
    /**
     * @stability stable
     */
    get proxy(): ApiManagementHostnameConfigurationProxy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set proxy(value: ApiManagementHostnameConfigurationProxy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProxy(): void;
    /**
     * @stability stable
     */
    get proxyInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationProxy[] | undefined;
    private _scm?;
    /**
     * @stability stable
     */
    get scm(): ApiManagementHostnameConfigurationScm[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set scm(value: ApiManagementHostnameConfigurationScm[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetScm(): void;
    /**
     * @stability stable
     */
    get scmInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationScm[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#identity_ids ApiManagement#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#type ApiManagement#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function apiManagementIdentityToTerraform(struct?: ApiManagementIdentityOutputReference | ApiManagementIdentity): any;
/**
 * @stability stable
 */
export declare class ApiManagementIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementProtocols {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enable_http2 ApiManagement#enable_http2}.
     *
     * @stability stable
     */
    readonly enableHttp2?: boolean | cdktf.IResolvable;
}
export declare function apiManagementProtocolsToTerraform(struct?: ApiManagementProtocolsOutputReference | ApiManagementProtocols): any;
/**
 * @stability stable
 */
export declare class ApiManagementProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementProtocols | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementProtocols | undefined);
    private _enableHttp2?;
    /**
     * @stability stable
     */
    get enableHttp2(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableHttp2(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableHttp2(): void;
    /**
     * @stability stable
     */
    get enableHttp2Input(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementSecurity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enable_backend_ssl30 ApiManagement#enable_backend_ssl30}.
     *
     * @stability stable
     */
    readonly enableBackendSsl30?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enable_backend_tls10 ApiManagement#enable_backend_tls10}.
     *
     * @stability stable
     */
    readonly enableBackendTls10?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enable_backend_tls11 ApiManagement#enable_backend_tls11}.
     *
     * @stability stable
     */
    readonly enableBackendTls11?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enable_frontend_ssl30 ApiManagement#enable_frontend_ssl30}.
     *
     * @stability stable
     */
    readonly enableFrontendSsl30?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enable_frontend_tls10 ApiManagement#enable_frontend_tls10}.
     *
     * @stability stable
     */
    readonly enableFrontendTls10?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enable_frontend_tls11 ApiManagement#enable_frontend_tls11}.
     *
     * @stability stable
     */
    readonly enableFrontendTls11?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enable_triple_des_ciphers ApiManagement#enable_triple_des_ciphers}.
     *
     * @stability stable
     */
    readonly enableTripleDesCiphers?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled ApiManagement#tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled ApiManagement#tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled ApiManagement#tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tlsEcdheRsaWithAes128CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled ApiManagement#tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tlsEcdheRsaWithAes256CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tls_rsa_with_aes128_cbc_sha256_ciphers_enabled ApiManagement#tls_rsa_with_aes128_cbc_sha256_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tlsRsaWithAes128CbcSha256CiphersEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tls_rsa_with_aes128_cbc_sha_ciphers_enabled ApiManagement#tls_rsa_with_aes128_cbc_sha_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tlsRsaWithAes128CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tls_rsa_with_aes128_gcm_sha256_ciphers_enabled ApiManagement#tls_rsa_with_aes128_gcm_sha256_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tlsRsaWithAes128GcmSha256CiphersEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tls_rsa_with_aes256_cbc_sha256_ciphers_enabled ApiManagement#tls_rsa_with_aes256_cbc_sha256_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tlsRsaWithAes256CbcSha256CiphersEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#tls_rsa_with_aes256_cbc_sha_ciphers_enabled ApiManagement#tls_rsa_with_aes256_cbc_sha_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tlsRsaWithAes256CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#triple_des_ciphers_enabled ApiManagement#triple_des_ciphers_enabled}.
     *
     * @stability stable
     */
    readonly tripleDesCiphersEnabled?: boolean | cdktf.IResolvable;
}
export declare function apiManagementSecurityToTerraform(struct?: ApiManagementSecurityOutputReference | ApiManagementSecurity): any;
/**
 * @stability stable
 */
export declare class ApiManagementSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementSecurity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementSecurity | undefined);
    private _enableBackendSsl30?;
    /**
     * @stability stable
     */
    get enableBackendSsl30(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBackendSsl30(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBackendSsl30(): void;
    /**
     * @stability stable
     */
    get enableBackendSsl30Input(): boolean | cdktf.IResolvable | undefined;
    private _enableBackendTls10?;
    /**
     * @stability stable
     */
    get enableBackendTls10(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBackendTls10(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBackendTls10(): void;
    /**
     * @stability stable
     */
    get enableBackendTls10Input(): boolean | cdktf.IResolvable | undefined;
    private _enableBackendTls11?;
    /**
     * @stability stable
     */
    get enableBackendTls11(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBackendTls11(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBackendTls11(): void;
    /**
     * @stability stable
     */
    get enableBackendTls11Input(): boolean | cdktf.IResolvable | undefined;
    private _enableFrontendSsl30?;
    /**
     * @stability stable
     */
    get enableFrontendSsl30(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableFrontendSsl30(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableFrontendSsl30(): void;
    /**
     * @stability stable
     */
    get enableFrontendSsl30Input(): boolean | cdktf.IResolvable | undefined;
    private _enableFrontendTls10?;
    /**
     * @stability stable
     */
    get enableFrontendTls10(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableFrontendTls10(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableFrontendTls10(): void;
    /**
     * @stability stable
     */
    get enableFrontendTls10Input(): boolean | cdktf.IResolvable | undefined;
    private _enableFrontendTls11?;
    /**
     * @stability stable
     */
    get enableFrontendTls11(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableFrontendTls11(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableFrontendTls11(): void;
    /**
     * @stability stable
     */
    get enableFrontendTls11Input(): boolean | cdktf.IResolvable | undefined;
    private _enableTripleDesCiphers?;
    /**
     * @stability stable
     */
    get enableTripleDesCiphers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableTripleDesCiphers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableTripleDesCiphers(): void;
    /**
     * @stability stable
     */
    get enableTripleDesCiphersInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled?;
    /**
     * @stability stable
     */
    get tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsEcdheEcdsaWithAes128CbcShaCiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tlsEcdheEcdsaWithAes128CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled?;
    /**
     * @stability stable
     */
    get tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsEcdheEcdsaWithAes256CbcShaCiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tlsEcdheEcdsaWithAes256CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsEcdheRsaWithAes128CbcShaCiphersEnabled?;
    /**
     * @stability stable
     */
    get tlsEcdheRsaWithAes128CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsEcdheRsaWithAes128CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsEcdheRsaWithAes128CbcShaCiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tlsEcdheRsaWithAes128CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsEcdheRsaWithAes256CbcShaCiphersEnabled?;
    /**
     * @stability stable
     */
    get tlsEcdheRsaWithAes256CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsEcdheRsaWithAes256CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsEcdheRsaWithAes256CbcShaCiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tlsEcdheRsaWithAes256CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes128CbcSha256CiphersEnabled?;
    /**
     * @stability stable
     */
    get tlsRsaWithAes128CbcSha256CiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsRsaWithAes128CbcSha256CiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsRsaWithAes128CbcSha256CiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tlsRsaWithAes128CbcSha256CiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes128CbcShaCiphersEnabled?;
    /**
     * @stability stable
     */
    get tlsRsaWithAes128CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsRsaWithAes128CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsRsaWithAes128CbcShaCiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tlsRsaWithAes128CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes128GcmSha256CiphersEnabled?;
    /**
     * @stability stable
     */
    get tlsRsaWithAes128GcmSha256CiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsRsaWithAes128GcmSha256CiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsRsaWithAes128GcmSha256CiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tlsRsaWithAes128GcmSha256CiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes256CbcSha256CiphersEnabled?;
    /**
     * @stability stable
     */
    get tlsRsaWithAes256CbcSha256CiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsRsaWithAes256CbcSha256CiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsRsaWithAes256CbcSha256CiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tlsRsaWithAes256CbcSha256CiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes256CbcShaCiphersEnabled?;
    /**
     * @stability stable
     */
    get tlsRsaWithAes256CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsRsaWithAes256CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsRsaWithAes256CbcShaCiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tlsRsaWithAes256CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tripleDesCiphersEnabled?;
    /**
     * @stability stable
     */
    get tripleDesCiphersEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tripleDesCiphersEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTripleDesCiphersEnabled(): void;
    /**
     * @stability stable
     */
    get tripleDesCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementSignIn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enabled ApiManagement#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function apiManagementSignInToTerraform(struct?: ApiManagementSignInOutputReference | ApiManagementSignIn): any;
/**
 * @stability stable
 */
export declare class ApiManagementSignInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementSignIn | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementSignIn | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementSignUpTermsOfService {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#consent_required ApiManagement#consent_required}.
     *
     * @stability stable
     */
    readonly consentRequired: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enabled ApiManagement#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#text ApiManagement#text}.
     *
     * @stability stable
     */
    readonly text?: string;
}
export declare function apiManagementSignUpTermsOfServiceToTerraform(struct?: ApiManagementSignUpTermsOfServiceOutputReference | ApiManagementSignUpTermsOfService): any;
/**
 * @stability stable
 */
export declare class ApiManagementSignUpTermsOfServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementSignUpTermsOfService | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementSignUpTermsOfService | undefined);
    private _consentRequired?;
    /**
     * @stability stable
     */
    get consentRequired(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set consentRequired(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get consentRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _text?;
    /**
     * @stability stable
     */
    get text(): string;
    /**
     * @stability stable
     */
    set text(value: string);
    /**
     * @stability stable
     */
    resetText(): void;
    /**
     * @stability stable
     */
    get textInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementSignUp {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enabled ApiManagement#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * terms_of_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#terms_of_service ApiManagement#terms_of_service}
     *
     * @stability stable
     */
    readonly termsOfService: ApiManagementSignUpTermsOfService;
}
export declare function apiManagementSignUpToTerraform(struct?: ApiManagementSignUpOutputReference | ApiManagementSignUp): any;
/**
 * @stability stable
 */
export declare class ApiManagementSignUpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementSignUp | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementSignUp | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _termsOfService;
    /**
     * @stability stable
     */
    get termsOfService(): ApiManagementSignUpTermsOfServiceOutputReference;
    /**
     * @stability stable
     */
    putTermsOfService(value: ApiManagementSignUpTermsOfService): void;
    /**
     * @stability stable
     */
    get termsOfServiceInput(): ApiManagementSignUpTermsOfService | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementTenantAccess {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#enabled ApiManagement#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function apiManagementTenantAccessToTerraform(struct?: ApiManagementTenantAccessOutputReference | ApiManagementTenantAccess): any;
/**
 * @stability stable
 */
export declare class ApiManagementTenantAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementTenantAccess | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementTenantAccess | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
}
/**
 * @stability stable
 */
export interface ApiManagementTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#create ApiManagement#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#delete ApiManagement#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#read ApiManagement#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#update ApiManagement#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementTimeoutsToTerraform(struct?: ApiManagementTimeoutsOutputReference | ApiManagementTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ApiManagementTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementVirtualNetworkConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management#subnet_id ApiManagement#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function apiManagementVirtualNetworkConfigurationToTerraform(struct?: ApiManagementVirtualNetworkConfigurationOutputReference | ApiManagementVirtualNetworkConfiguration): any;
/**
 * @stability stable
 */
export declare class ApiManagementVirtualNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementVirtualNetworkConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementVirtualNetworkConfiguration | undefined);
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management azurerm_api_management}.
 *
 * @stability stable
 */
export declare class ApiManagement extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management azurerm_api_management} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementConfig);
    private _clientCertificateEnabled?;
    /**
     * @stability stable
     */
    get clientCertificateEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientCertificateEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientCertificateEnabled(): void;
    /**
     * @stability stable
     */
    get clientCertificateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get developerPortalUrl(): string;
    private _gatewayDisabled?;
    /**
     * @stability stable
     */
    get gatewayDisabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set gatewayDisabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGatewayDisabled(): void;
    /**
     * @stability stable
     */
    get gatewayDisabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get gatewayRegionalUrl(): string;
    /**
     * @stability stable
     */
    get gatewayUrl(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get managementApiUrl(): string;
    private _minApiVersion?;
    /**
     * @stability stable
     */
    get minApiVersion(): string;
    /**
     * @stability stable
     */
    set minApiVersion(value: string);
    /**
     * @stability stable
     */
    resetMinApiVersion(): void;
    /**
     * @stability stable
     */
    get minApiVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _notificationSenderEmail?;
    /**
     * @stability stable
     */
    get notificationSenderEmail(): string;
    /**
     * @stability stable
     */
    set notificationSenderEmail(value: string);
    /**
     * @stability stable
     */
    resetNotificationSenderEmail(): void;
    /**
     * @stability stable
     */
    get notificationSenderEmailInput(): string | undefined;
    private _policy?;
    /**
     * @stability stable
     */
    get policy(): ApiManagementPolicy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set policy(value: ApiManagementPolicy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPolicy(): void;
    /**
     * @stability stable
     */
    get policyInput(): cdktf.IResolvable | ApiManagementPolicy[] | undefined;
    /**
     * @stability stable
     */
    get portalUrl(): string;
    /**
     * @stability stable
     */
    get privateIpAddresses(): string[];
    /**
     * @stability stable
     */
    get publicIpAddresses(): string[];
    private _publisherEmail?;
    /**
     * @stability stable
     */
    get publisherEmail(): string;
    /**
     * @stability stable
     */
    set publisherEmail(value: string);
    /**
     * @stability stable
     */
    get publisherEmailInput(): string | undefined;
    private _publisherName?;
    /**
     * @stability stable
     */
    get publisherName(): string;
    /**
     * @stability stable
     */
    set publisherName(value: string);
    /**
     * @stability stable
     */
    get publisherNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get scmUrl(): string;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkType?;
    /**
     * @stability stable
     */
    get virtualNetworkType(): string;
    /**
     * @stability stable
     */
    set virtualNetworkType(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkType(): void;
    /**
     * @stability stable
     */
    get virtualNetworkTypeInput(): string | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _additionalLocation?;
    /**
     * @stability stable
     */
    get additionalLocation(): ApiManagementAdditionalLocation[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalLocation(value: ApiManagementAdditionalLocation[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalLocation(): void;
    /**
     * @stability stable
     */
    get additionalLocationInput(): cdktf.IResolvable | ApiManagementAdditionalLocation[] | undefined;
    private _certificate?;
    /**
     * @stability stable
     */
    get certificate(): ApiManagementCertificate[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set certificate(value: ApiManagementCertificate[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCertificate(): void;
    /**
     * @stability stable
     */
    get certificateInput(): cdktf.IResolvable | ApiManagementCertificate[] | undefined;
    private _hostnameConfiguration;
    /**
     * @stability stable
     */
    get hostnameConfiguration(): ApiManagementHostnameConfigurationOutputReference;
    /**
     * @stability stable
     */
    putHostnameConfiguration(value: ApiManagementHostnameConfiguration): void;
    /**
     * @stability stable
     */
    resetHostnameConfiguration(): void;
    /**
     * @stability stable
     */
    get hostnameConfigurationInput(): ApiManagementHostnameConfiguration | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): ApiManagementIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: ApiManagementIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): ApiManagementIdentity | undefined;
    private _protocols;
    /**
     * @stability stable
     */
    get protocols(): ApiManagementProtocolsOutputReference;
    /**
     * @stability stable
     */
    putProtocols(value: ApiManagementProtocols): void;
    /**
     * @stability stable
     */
    resetProtocols(): void;
    /**
     * @stability stable
     */
    get protocolsInput(): ApiManagementProtocols | undefined;
    private _security;
    /**
     * @stability stable
     */
    get security(): ApiManagementSecurityOutputReference;
    /**
     * @stability stable
     */
    putSecurity(value: ApiManagementSecurity): void;
    /**
     * @stability stable
     */
    resetSecurity(): void;
    /**
     * @stability stable
     */
    get securityInput(): ApiManagementSecurity | undefined;
    private _signIn;
    /**
     * @stability stable
     */
    get signIn(): ApiManagementSignInOutputReference;
    /**
     * @stability stable
     */
    putSignIn(value: ApiManagementSignIn): void;
    /**
     * @stability stable
     */
    resetSignIn(): void;
    /**
     * @stability stable
     */
    get signInInput(): ApiManagementSignIn | undefined;
    private _signUp;
    /**
     * @stability stable
     */
    get signUp(): ApiManagementSignUpOutputReference;
    /**
     * @stability stable
     */
    putSignUp(value: ApiManagementSignUp): void;
    /**
     * @stability stable
     */
    resetSignUp(): void;
    /**
     * @stability stable
     */
    get signUpInput(): ApiManagementSignUp | undefined;
    private _tenantAccess;
    /**
     * @stability stable
     */
    get tenantAccess(): ApiManagementTenantAccessOutputReference;
    /**
     * @stability stable
     */
    putTenantAccess(value: ApiManagementTenantAccess): void;
    /**
     * @stability stable
     */
    resetTenantAccess(): void;
    /**
     * @stability stable
     */
    get tenantAccessInput(): ApiManagementTenantAccess | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementTimeouts | undefined;
    private _virtualNetworkConfiguration;
    /**
     * @stability stable
     */
    get virtualNetworkConfiguration(): ApiManagementVirtualNetworkConfigurationOutputReference;
    /**
     * @stability stable
     */
    putVirtualNetworkConfiguration(value: ApiManagementVirtualNetworkConfiguration): void;
    /**
     * @stability stable
     */
    resetVirtualNetworkConfiguration(): void;
    /**
     * @stability stable
     */
    get virtualNetworkConfigurationInput(): ApiManagementVirtualNetworkConfiguration | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
