import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceCustomHostnameBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#app_service_name AppServiceCustomHostnameBinding#app_service_name}.
     *
     * @stability stable
     */
    readonly appServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#hostname AppServiceCustomHostnameBinding#hostname}.
     *
     * @stability stable
     */
    readonly hostname: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#resource_group_name AppServiceCustomHostnameBinding#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#ssl_state AppServiceCustomHostnameBinding#ssl_state}.
     *
     * @stability stable
     */
    readonly sslState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#thumbprint AppServiceCustomHostnameBinding#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#timeouts AppServiceCustomHostnameBinding#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceCustomHostnameBindingTimeouts;
}
/**
 * @stability stable
 */
export interface AppServiceCustomHostnameBindingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#create AppServiceCustomHostnameBinding#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#delete AppServiceCustomHostnameBinding#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#read AppServiceCustomHostnameBinding#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding#update AppServiceCustomHostnameBinding#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServiceCustomHostnameBindingTimeoutsToTerraform(struct?: AppServiceCustomHostnameBindingTimeoutsOutputReference | AppServiceCustomHostnameBindingTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AppServiceCustomHostnameBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceCustomHostnameBindingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceCustomHostnameBindingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding azurerm_app_service_custom_hostname_binding}.
 *
 * @stability stable
 */
export declare class AppServiceCustomHostnameBinding extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_custom_hostname_binding azurerm_app_service_custom_hostname_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceCustomHostnameBindingConfig);
    private _appServiceName?;
    /**
     * @stability stable
     */
    get appServiceName(): string;
    /**
     * @stability stable
     */
    set appServiceName(value: string);
    /**
     * @stability stable
     */
    get appServiceNameInput(): string | undefined;
    private _hostname?;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    set hostname(value: string);
    /**
     * @stability stable
     */
    get hostnameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sslState?;
    /**
     * @stability stable
     */
    get sslState(): string;
    /**
     * @stability stable
     */
    set sslState(value: string);
    /**
     * @stability stable
     */
    resetSslState(): void;
    /**
     * @stability stable
     */
    get sslStateInput(): string | undefined;
    private _thumbprint?;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    /**
     * @stability stable
     */
    set thumbprint(value: string);
    /**
     * @stability stable
     */
    resetThumbprint(): void;
    /**
     * @stability stable
     */
    get thumbprintInput(): string | undefined;
    /**
     * @stability stable
     */
    get virtualIp(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceCustomHostnameBindingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceCustomHostnameBindingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceCustomHostnameBindingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
