import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceSlotCustomHostnameBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#app_service_slot_id AppServiceSlotCustomHostnameBinding#app_service_slot_id}.
     *
     * @stability stable
     */
    readonly appServiceSlotId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#hostname AppServiceSlotCustomHostnameBinding#hostname}.
     *
     * @stability stable
     */
    readonly hostname: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#ssl_state AppServiceSlotCustomHostnameBinding#ssl_state}.
     *
     * @stability stable
     */
    readonly sslState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#thumbprint AppServiceSlotCustomHostnameBinding#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#timeouts AppServiceSlotCustomHostnameBinding#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceSlotCustomHostnameBindingTimeouts;
}
/**
 * @stability stable
 */
export interface AppServiceSlotCustomHostnameBindingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#create AppServiceSlotCustomHostnameBinding#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#delete AppServiceSlotCustomHostnameBinding#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#read AppServiceSlotCustomHostnameBinding#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function appServiceSlotCustomHostnameBindingTimeoutsToTerraform(struct?: AppServiceSlotCustomHostnameBindingTimeoutsOutputReference | AppServiceSlotCustomHostnameBindingTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotCustomHostnameBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotCustomHostnameBindingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotCustomHostnameBindingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding azurerm_app_service_slot_custom_hostname_binding}.
 *
 * @stability stable
 */
export declare class AppServiceSlotCustomHostnameBinding extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding azurerm_app_service_slot_custom_hostname_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceSlotCustomHostnameBindingConfig);
    private _appServiceSlotId?;
    /**
     * @stability stable
     */
    get appServiceSlotId(): string;
    /**
     * @stability stable
     */
    set appServiceSlotId(value: string);
    /**
     * @stability stable
     */
    get appServiceSlotIdInput(): string | undefined;
    private _hostname?;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    set hostname(value: string);
    /**
     * @stability stable
     */
    get hostnameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _sslState?;
    /**
     * @stability stable
     */
    get sslState(): string;
    /**
     * @stability stable
     */
    set sslState(value: string);
    /**
     * @stability stable
     */
    resetSslState(): void;
    /**
     * @stability stable
     */
    get sslStateInput(): string | undefined;
    private _thumbprint?;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    /**
     * @stability stable
     */
    set thumbprint(value: string);
    /**
     * @stability stable
     */
    resetThumbprint(): void;
    /**
     * @stability stable
     */
    get thumbprintInput(): string | undefined;
    /**
     * @stability stable
     */
    get virtualIp(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceSlotCustomHostnameBindingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceSlotCustomHostnameBindingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceSlotCustomHostnameBindingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
