import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceVirtualNetworkSwiftConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_virtual_network_swift_connection#app_service_id AppServiceVirtualNetworkSwiftConnection#app_service_id}.
     *
     * @stability stable
     */
    readonly appServiceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_virtual_network_swift_connection#subnet_id AppServiceVirtualNetworkSwiftConnection#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_virtual_network_swift_connection#timeouts AppServiceVirtualNetworkSwiftConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceVirtualNetworkSwiftConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface AppServiceVirtualNetworkSwiftConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_virtual_network_swift_connection#create AppServiceVirtualNetworkSwiftConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_virtual_network_swift_connection#delete AppServiceVirtualNetworkSwiftConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_virtual_network_swift_connection#read AppServiceVirtualNetworkSwiftConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_virtual_network_swift_connection#update AppServiceVirtualNetworkSwiftConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServiceVirtualNetworkSwiftConnectionTimeoutsToTerraform(struct?: AppServiceVirtualNetworkSwiftConnectionTimeoutsOutputReference | AppServiceVirtualNetworkSwiftConnectionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AppServiceVirtualNetworkSwiftConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceVirtualNetworkSwiftConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceVirtualNetworkSwiftConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_virtual_network_swift_connection azurerm_app_service_virtual_network_swift_connection}.
 *
 * @stability stable
 */
export declare class AppServiceVirtualNetworkSwiftConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_virtual_network_swift_connection azurerm_app_service_virtual_network_swift_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceVirtualNetworkSwiftConnectionConfig);
    private _appServiceId?;
    /**
     * @stability stable
     */
    get appServiceId(): string;
    /**
     * @stability stable
     */
    set appServiceId(value: string);
    /**
     * @stability stable
     */
    get appServiceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceVirtualNetworkSwiftConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceVirtualNetworkSwiftConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceVirtualNetworkSwiftConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
