import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BackupProtectedFileShareConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#backup_policy_id BackupProtectedFileShare#backup_policy_id}.
     *
     * @stability stable
     */
    readonly backupPolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#recovery_vault_name BackupProtectedFileShare#recovery_vault_name}.
     *
     * @stability stable
     */
    readonly recoveryVaultName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#resource_group_name BackupProtectedFileShare#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#source_file_share_name BackupProtectedFileShare#source_file_share_name}.
     *
     * @stability stable
     */
    readonly sourceFileShareName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#source_storage_account_id BackupProtectedFileShare#source_storage_account_id}.
     *
     * @stability stable
     */
    readonly sourceStorageAccountId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#timeouts BackupProtectedFileShare#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BackupProtectedFileShareTimeouts;
}
/**
 * @stability stable
 */
export interface BackupProtectedFileShareTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#create BackupProtectedFileShare#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#delete BackupProtectedFileShare#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#read BackupProtectedFileShare#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share#update BackupProtectedFileShare#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function backupProtectedFileShareTimeoutsToTerraform(struct?: BackupProtectedFileShareTimeoutsOutputReference | BackupProtectedFileShareTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class BackupProtectedFileShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupProtectedFileShareTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupProtectedFileShareTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share azurerm_backup_protected_file_share}.
 *
 * @stability stable
 */
export declare class BackupProtectedFileShare extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_file_share azurerm_backup_protected_file_share} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BackupProtectedFileShareConfig);
    private _backupPolicyId?;
    /**
     * @stability stable
     */
    get backupPolicyId(): string;
    /**
     * @stability stable
     */
    set backupPolicyId(value: string);
    /**
     * @stability stable
     */
    get backupPolicyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _recoveryVaultName?;
    /**
     * @stability stable
     */
    get recoveryVaultName(): string;
    /**
     * @stability stable
     */
    set recoveryVaultName(value: string);
    /**
     * @stability stable
     */
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sourceFileShareName?;
    /**
     * @stability stable
     */
    get sourceFileShareName(): string;
    /**
     * @stability stable
     */
    set sourceFileShareName(value: string);
    /**
     * @stability stable
     */
    get sourceFileShareNameInput(): string | undefined;
    private _sourceStorageAccountId?;
    /**
     * @stability stable
     */
    get sourceStorageAccountId(): string;
    /**
     * @stability stable
     */
    set sourceStorageAccountId(value: string);
    /**
     * @stability stable
     */
    get sourceStorageAccountIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BackupProtectedFileShareTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BackupProtectedFileShareTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BackupProtectedFileShareTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
