import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BotChannelsRegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#cmk_key_vault_url BotChannelsRegistration#cmk_key_vault_url}.
     *
     * @stability stable
     */
    readonly cmkKeyVaultUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#description BotChannelsRegistration#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#developer_app_insights_api_key BotChannelsRegistration#developer_app_insights_api_key}.
     *
     * @stability stable
     */
    readonly developerAppInsightsApiKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#developer_app_insights_application_id BotChannelsRegistration#developer_app_insights_application_id}.
     *
     * @stability stable
     */
    readonly developerAppInsightsApplicationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#developer_app_insights_key BotChannelsRegistration#developer_app_insights_key}.
     *
     * @stability stable
     */
    readonly developerAppInsightsKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#display_name BotChannelsRegistration#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#endpoint BotChannelsRegistration#endpoint}.
     *
     * @stability stable
     */
    readonly endpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#icon_url BotChannelsRegistration#icon_url}.
     *
     * @stability stable
     */
    readonly iconUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#isolated_network_enabled BotChannelsRegistration#isolated_network_enabled}.
     *
     * @stability stable
     */
    readonly isolatedNetworkEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#location BotChannelsRegistration#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#microsoft_app_id BotChannelsRegistration#microsoft_app_id}.
     *
     * @stability stable
     */
    readonly microsoftAppId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#name BotChannelsRegistration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#resource_group_name BotChannelsRegistration#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#sku BotChannelsRegistration#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#tags BotChannelsRegistration#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#timeouts BotChannelsRegistration#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BotChannelsRegistrationTimeouts;
}
/**
 * @stability stable
 */
export interface BotChannelsRegistrationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#create BotChannelsRegistration#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#delete BotChannelsRegistration#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#read BotChannelsRegistration#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#update BotChannelsRegistration#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function botChannelsRegistrationTimeoutsToTerraform(struct?: BotChannelsRegistrationTimeoutsOutputReference | BotChannelsRegistrationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class BotChannelsRegistrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BotChannelsRegistrationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BotChannelsRegistrationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration azurerm_bot_channels_registration}.
 *
 * @stability stable
 */
export declare class BotChannelsRegistration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration azurerm_bot_channels_registration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BotChannelsRegistrationConfig);
    private _cmkKeyVaultUrl?;
    /**
     * @stability stable
     */
    get cmkKeyVaultUrl(): string;
    /**
     * @stability stable
     */
    set cmkKeyVaultUrl(value: string);
    /**
     * @stability stable
     */
    resetCmkKeyVaultUrl(): void;
    /**
     * @stability stable
     */
    get cmkKeyVaultUrlInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _developerAppInsightsApiKey?;
    /**
     * @stability stable
     */
    get developerAppInsightsApiKey(): string;
    /**
     * @stability stable
     */
    set developerAppInsightsApiKey(value: string);
    /**
     * @stability stable
     */
    resetDeveloperAppInsightsApiKey(): void;
    /**
     * @stability stable
     */
    get developerAppInsightsApiKeyInput(): string | undefined;
    private _developerAppInsightsApplicationId?;
    /**
     * @stability stable
     */
    get developerAppInsightsApplicationId(): string;
    /**
     * @stability stable
     */
    set developerAppInsightsApplicationId(value: string);
    /**
     * @stability stable
     */
    resetDeveloperAppInsightsApplicationId(): void;
    /**
     * @stability stable
     */
    get developerAppInsightsApplicationIdInput(): string | undefined;
    private _developerAppInsightsKey?;
    /**
     * @stability stable
     */
    get developerAppInsightsKey(): string;
    /**
     * @stability stable
     */
    set developerAppInsightsKey(value: string);
    /**
     * @stability stable
     */
    resetDeveloperAppInsightsKey(): void;
    /**
     * @stability stable
     */
    get developerAppInsightsKeyInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _endpoint?;
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    set endpoint(value: string);
    /**
     * @stability stable
     */
    resetEndpoint(): void;
    /**
     * @stability stable
     */
    get endpointInput(): string | undefined;
    private _iconUrl?;
    /**
     * @stability stable
     */
    get iconUrl(): string;
    /**
     * @stability stable
     */
    set iconUrl(value: string);
    /**
     * @stability stable
     */
    resetIconUrl(): void;
    /**
     * @stability stable
     */
    get iconUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isolatedNetworkEnabled?;
    /**
     * @stability stable
     */
    get isolatedNetworkEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isolatedNetworkEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsolatedNetworkEnabled(): void;
    /**
     * @stability stable
     */
    get isolatedNetworkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _microsoftAppId?;
    /**
     * @stability stable
     */
    get microsoftAppId(): string;
    /**
     * @stability stable
     */
    set microsoftAppId(value: string);
    /**
     * @stability stable
     */
    get microsoftAppIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BotChannelsRegistrationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BotChannelsRegistrationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BotChannelsRegistrationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
