import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbCassandraKeyspaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#account_name CosmosdbCassandraKeyspace#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#name CosmosdbCassandraKeyspace#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#resource_group_name CosmosdbCassandraKeyspace#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#throughput CosmosdbCassandraKeyspace#throughput}.
     *
     * @stability stable
     */
    readonly throughput?: number;
    /**
     * autoscale_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#autoscale_settings CosmosdbCassandraKeyspace#autoscale_settings}
     *
     * @stability stable
     */
    readonly autoscaleSettings?: CosmosdbCassandraKeyspaceAutoscaleSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#timeouts CosmosdbCassandraKeyspace#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbCassandraKeyspaceTimeouts;
}
/**
 * @stability stable
 */
export interface CosmosdbCassandraKeyspaceAutoscaleSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#max_throughput CosmosdbCassandraKeyspace#max_throughput}.
     *
     * @stability stable
     */
    readonly maxThroughput?: number;
}
export declare function cosmosdbCassandraKeyspaceAutoscaleSettingsToTerraform(struct?: CosmosdbCassandraKeyspaceAutoscaleSettingsOutputReference | CosmosdbCassandraKeyspaceAutoscaleSettings): any;
/**
 * @stability stable
 */
export declare class CosmosdbCassandraKeyspaceAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbCassandraKeyspaceAutoscaleSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbCassandraKeyspaceAutoscaleSettings | undefined);
    private _maxThroughput?;
    /**
     * @stability stable
     */
    get maxThroughput(): number;
    /**
     * @stability stable
     */
    set maxThroughput(value: number);
    /**
     * @stability stable
     */
    resetMaxThroughput(): void;
    /**
     * @stability stable
     */
    get maxThroughputInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbCassandraKeyspaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#create CosmosdbCassandraKeyspace#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#delete CosmosdbCassandraKeyspace#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#read CosmosdbCassandraKeyspace#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace#update CosmosdbCassandraKeyspace#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbCassandraKeyspaceTimeoutsToTerraform(struct?: CosmosdbCassandraKeyspaceTimeoutsOutputReference | CosmosdbCassandraKeyspaceTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class CosmosdbCassandraKeyspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbCassandraKeyspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbCassandraKeyspaceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace azurerm_cosmosdb_cassandra_keyspace}.
 *
 * @stability stable
 */
export declare class CosmosdbCassandraKeyspace extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_keyspace azurerm_cosmosdb_cassandra_keyspace} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbCassandraKeyspaceConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _throughput?;
    /**
     * @stability stable
     */
    get throughput(): number;
    /**
     * @stability stable
     */
    set throughput(value: number);
    /**
     * @stability stable
     */
    resetThroughput(): void;
    /**
     * @stability stable
     */
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    /**
     * @stability stable
     */
    get autoscaleSettings(): CosmosdbCassandraKeyspaceAutoscaleSettingsOutputReference;
    /**
     * @stability stable
     */
    putAutoscaleSettings(value: CosmosdbCassandraKeyspaceAutoscaleSettings): void;
    /**
     * @stability stable
     */
    resetAutoscaleSettings(): void;
    /**
     * @stability stable
     */
    get autoscaleSettingsInput(): CosmosdbCassandraKeyspaceAutoscaleSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbCassandraKeyspaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbCassandraKeyspaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbCassandraKeyspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
