import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbCassandraTableConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#analytical_storage_ttl CosmosdbCassandraTable#analytical_storage_ttl}.
     *
     * @stability stable
     */
    readonly analyticalStorageTtl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#cassandra_keyspace_id CosmosdbCassandraTable#cassandra_keyspace_id}.
     *
     * @stability stable
     */
    readonly cassandraKeyspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#default_ttl CosmosdbCassandraTable#default_ttl}.
     *
     * @stability stable
     */
    readonly defaultTtl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#throughput CosmosdbCassandraTable#throughput}.
     *
     * @stability stable
     */
    readonly throughput?: number;
    /**
     * autoscale_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#autoscale_settings CosmosdbCassandraTable#autoscale_settings}
     *
     * @stability stable
     */
    readonly autoscaleSettings?: CosmosdbCassandraTableAutoscaleSettings;
    /**
     * schema block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#schema CosmosdbCassandraTable#schema}
     *
     * @stability stable
     */
    readonly schema: CosmosdbCassandraTableSchema;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#timeouts CosmosdbCassandraTable#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbCassandraTableTimeouts;
}
/**
 * @stability stable
 */
export interface CosmosdbCassandraTableAutoscaleSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#max_throughput CosmosdbCassandraTable#max_throughput}.
     *
     * @stability stable
     */
    readonly maxThroughput?: number;
}
export declare function cosmosdbCassandraTableAutoscaleSettingsToTerraform(struct?: CosmosdbCassandraTableAutoscaleSettingsOutputReference | CosmosdbCassandraTableAutoscaleSettings): any;
/**
 * @stability stable
 */
export declare class CosmosdbCassandraTableAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbCassandraTableAutoscaleSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbCassandraTableAutoscaleSettings | undefined);
    private _maxThroughput?;
    /**
     * @stability stable
     */
    get maxThroughput(): number;
    /**
     * @stability stable
     */
    set maxThroughput(value: number);
    /**
     * @stability stable
     */
    resetMaxThroughput(): void;
    /**
     * @stability stable
     */
    get maxThroughputInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbCassandraTableSchemaClusterKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#order_by CosmosdbCassandraTable#order_by}.
     *
     * @stability stable
     */
    readonly orderBy: string;
}
export declare function cosmosdbCassandraTableSchemaClusterKeyToTerraform(struct?: CosmosdbCassandraTableSchemaClusterKey | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface CosmosdbCassandraTableSchemaColumn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#type CosmosdbCassandraTable#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function cosmosdbCassandraTableSchemaColumnToTerraform(struct?: CosmosdbCassandraTableSchemaColumn | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface CosmosdbCassandraTableSchemaPartitionKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function cosmosdbCassandraTableSchemaPartitionKeyToTerraform(struct?: CosmosdbCassandraTableSchemaPartitionKey | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface CosmosdbCassandraTableSchema {
    /**
     * cluster_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#cluster_key CosmosdbCassandraTable#cluster_key}
     *
     * @stability stable
     */
    readonly clusterKey?: CosmosdbCassandraTableSchemaClusterKey[] | cdktf.IResolvable;
    /**
     * column block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#column CosmosdbCassandraTable#column}
     *
     * @stability stable
     */
    readonly column: CosmosdbCassandraTableSchemaColumn[] | cdktf.IResolvable;
    /**
     * partition_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#partition_key CosmosdbCassandraTable#partition_key}
     *
     * @stability stable
     */
    readonly partitionKey: CosmosdbCassandraTableSchemaPartitionKey[] | cdktf.IResolvable;
}
export declare function cosmosdbCassandraTableSchemaToTerraform(struct?: CosmosdbCassandraTableSchemaOutputReference | CosmosdbCassandraTableSchema): any;
/**
 * @stability stable
 */
export declare class CosmosdbCassandraTableSchemaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbCassandraTableSchema | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbCassandraTableSchema | undefined);
    private _clusterKey?;
    /**
     * @stability stable
     */
    get clusterKey(): CosmosdbCassandraTableSchemaClusterKey[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clusterKey(value: CosmosdbCassandraTableSchemaClusterKey[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClusterKey(): void;
    /**
     * @stability stable
     */
    get clusterKeyInput(): cdktf.IResolvable | CosmosdbCassandraTableSchemaClusterKey[] | undefined;
    private _column?;
    /**
     * @stability stable
     */
    get column(): CosmosdbCassandraTableSchemaColumn[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set column(value: CosmosdbCassandraTableSchemaColumn[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get columnInput(): cdktf.IResolvable | CosmosdbCassandraTableSchemaColumn[] | undefined;
    private _partitionKey?;
    /**
     * @stability stable
     */
    get partitionKey(): CosmosdbCassandraTableSchemaPartitionKey[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set partitionKey(value: CosmosdbCassandraTableSchemaPartitionKey[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get partitionKeyInput(): cdktf.IResolvable | CosmosdbCassandraTableSchemaPartitionKey[] | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbCassandraTableTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#create CosmosdbCassandraTable#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#delete CosmosdbCassandraTable#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#read CosmosdbCassandraTable#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#update CosmosdbCassandraTable#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbCassandraTableTimeoutsToTerraform(struct?: CosmosdbCassandraTableTimeoutsOutputReference | CosmosdbCassandraTableTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class CosmosdbCassandraTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbCassandraTableTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbCassandraTableTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table azurerm_cosmosdb_cassandra_table}.
 *
 * @stability stable
 */
export declare class CosmosdbCassandraTable extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table azurerm_cosmosdb_cassandra_table} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbCassandraTableConfig);
    private _analyticalStorageTtl?;
    /**
     * @stability stable
     */
    get analyticalStorageTtl(): number;
    /**
     * @stability stable
     */
    set analyticalStorageTtl(value: number);
    /**
     * @stability stable
     */
    resetAnalyticalStorageTtl(): void;
    /**
     * @stability stable
     */
    get analyticalStorageTtlInput(): number | undefined;
    private _cassandraKeyspaceId?;
    /**
     * @stability stable
     */
    get cassandraKeyspaceId(): string;
    /**
     * @stability stable
     */
    set cassandraKeyspaceId(value: string);
    /**
     * @stability stable
     */
    get cassandraKeyspaceIdInput(): string | undefined;
    private _defaultTtl?;
    /**
     * @stability stable
     */
    get defaultTtl(): number;
    /**
     * @stability stable
     */
    set defaultTtl(value: number);
    /**
     * @stability stable
     */
    resetDefaultTtl(): void;
    /**
     * @stability stable
     */
    get defaultTtlInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _throughput?;
    /**
     * @stability stable
     */
    get throughput(): number;
    /**
     * @stability stable
     */
    set throughput(value: number);
    /**
     * @stability stable
     */
    resetThroughput(): void;
    /**
     * @stability stable
     */
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    /**
     * @stability stable
     */
    get autoscaleSettings(): CosmosdbCassandraTableAutoscaleSettingsOutputReference;
    /**
     * @stability stable
     */
    putAutoscaleSettings(value: CosmosdbCassandraTableAutoscaleSettings): void;
    /**
     * @stability stable
     */
    resetAutoscaleSettings(): void;
    /**
     * @stability stable
     */
    get autoscaleSettingsInput(): CosmosdbCassandraTableAutoscaleSettings | undefined;
    private _schema;
    /**
     * @stability stable
     */
    get schema(): CosmosdbCassandraTableSchemaOutputReference;
    /**
     * @stability stable
     */
    putSchema(value: CosmosdbCassandraTableSchema): void;
    /**
     * @stability stable
     */
    get schemaInput(): CosmosdbCassandraTableSchema | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbCassandraTableTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbCassandraTableTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbCassandraTableTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
