import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermAdvisorRecommendationsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations#filter_by_category DataAzurermAdvisorRecommendations#filter_by_category}.
     *
     * @stability stable
     */
    readonly filterByCategory?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations#filter_by_resource_groups DataAzurermAdvisorRecommendations#filter_by_resource_groups}.
     *
     * @stability stable
     */
    readonly filterByResourceGroups?: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations#timeouts DataAzurermAdvisorRecommendations#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermAdvisorRecommendationsTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermAdvisorRecommendationsRecommendations extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get category(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get impact(): string;
    /**
     * @stability stable
     */
    get recommendationName(): string;
    /**
     * @stability stable
     */
    get recommendationTypeId(): string;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    get resourceType(): string;
    /**
     * @stability stable
     */
    get suppressionNames(): string[];
    /**
     * @stability stable
     */
    get updatedTime(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermAdvisorRecommendationsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations#read DataAzurermAdvisorRecommendations#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermAdvisorRecommendationsTimeoutsToTerraform(struct?: DataAzurermAdvisorRecommendationsTimeoutsOutputReference | DataAzurermAdvisorRecommendationsTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermAdvisorRecommendationsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermAdvisorRecommendationsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermAdvisorRecommendationsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations azurerm_advisor_recommendations}.
 *
 * @stability stable
 */
export declare class DataAzurermAdvisorRecommendations extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations azurerm_advisor_recommendations} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzurermAdvisorRecommendationsConfig);
    private _filterByCategory?;
    /**
     * @stability stable
     */
    get filterByCategory(): string[];
    /**
     * @stability stable
     */
    set filterByCategory(value: string[]);
    /**
     * @stability stable
     */
    resetFilterByCategory(): void;
    /**
     * @stability stable
     */
    get filterByCategoryInput(): string[] | undefined;
    private _filterByResourceGroups?;
    /**
     * @stability stable
     */
    get filterByResourceGroups(): string[];
    /**
     * @stability stable
     */
    set filterByResourceGroups(value: string[]);
    /**
     * @stability stable
     */
    resetFilterByResourceGroups(): void;
    /**
     * @stability stable
     */
    get filterByResourceGroupsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    recommendations(index: string): DataAzurermAdvisorRecommendationsRecommendations;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermAdvisorRecommendationsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermAdvisorRecommendationsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermAdvisorRecommendationsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
