import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermBillingEnrollmentAccountScopeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope#billing_account_name DataAzurermBillingEnrollmentAccountScope#billing_account_name}.
     *
     * @stability stable
     */
    readonly billingAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope#enrollment_account_name DataAzurermBillingEnrollmentAccountScope#enrollment_account_name}.
     *
     * @stability stable
     */
    readonly enrollmentAccountName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope#timeouts DataAzurermBillingEnrollmentAccountScope#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermBillingEnrollmentAccountScopeTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermBillingEnrollmentAccountScopeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope#read DataAzurermBillingEnrollmentAccountScope#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermBillingEnrollmentAccountScopeTimeoutsToTerraform(struct?: DataAzurermBillingEnrollmentAccountScopeTimeoutsOutputReference | DataAzurermBillingEnrollmentAccountScopeTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermBillingEnrollmentAccountScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermBillingEnrollmentAccountScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermBillingEnrollmentAccountScopeTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope azurerm_billing_enrollment_account_scope}.
 *
 * @stability stable
 */
export declare class DataAzurermBillingEnrollmentAccountScope extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope azurerm_billing_enrollment_account_scope} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermBillingEnrollmentAccountScopeConfig);
    private _billingAccountName?;
    /**
     * @stability stable
     */
    get billingAccountName(): string;
    /**
     * @stability stable
     */
    set billingAccountName(value: string);
    /**
     * @stability stable
     */
    get billingAccountNameInput(): string | undefined;
    private _enrollmentAccountName?;
    /**
     * @stability stable
     */
    get enrollmentAccountName(): string;
    /**
     * @stability stable
     */
    set enrollmentAccountName(value: string);
    /**
     * @stability stable
     */
    get enrollmentAccountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermBillingEnrollmentAccountScopeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermBillingEnrollmentAccountScopeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermBillingEnrollmentAccountScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
