import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermConsumptionBudgetSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription#name DataAzurermConsumptionBudgetSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription#subscription_id DataAzurermConsumptionBudgetSubscription#subscription_id}.
     *
     * @stability stable
     */
    readonly subscriptionId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription#timeouts DataAzurermConsumptionBudgetSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermConsumptionBudgetSubscriptionTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscriptionFilterDimension extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotDimension extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotTag extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNot extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dimension(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get tag(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscriptionFilterTag extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscriptionFilter extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dimension(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get not(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get tag(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscriptionNotification extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get contactEmails(): string[];
    /**
     * @stability stable
     */
    get contactGroups(): string[];
    /**
     * @stability stable
     */
    get contactRoles(): string[];
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get threshold(): number;
    /**
     * @stability stable
     */
    get thresholdType(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscriptionTimePeriod extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get endDate(): string;
    /**
     * @stability stable
     */
    get startDate(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermConsumptionBudgetSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription#read DataAzurermConsumptionBudgetSubscription#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermConsumptionBudgetSubscriptionTimeoutsToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionTimeoutsOutputReference | DataAzurermConsumptionBudgetSubscriptionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription azurerm_consumption_budget_subscription}.
 *
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetSubscription extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription azurerm_consumption_budget_subscription} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermConsumptionBudgetSubscriptionConfig);
    /**
     * @stability stable
     */
    get amount(): number;
    /**
     * @stability stable
     */
    filter(index: string): DataAzurermConsumptionBudgetSubscriptionFilter;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    notification(index: string): DataAzurermConsumptionBudgetSubscriptionNotification;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get timeGrain(): string;
    /**
     * @stability stable
     */
    timePeriod(index: string): DataAzurermConsumptionBudgetSubscriptionTimePeriod;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermConsumptionBudgetSubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermConsumptionBudgetSubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermConsumptionBudgetSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
