import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetBlobStorageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage#data_share_id DataAzurermDataShareDatasetBlobStorage#data_share_id}.
     *
     * @stability stable
     */
    readonly dataShareId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage#name DataAzurermDataShareDatasetBlobStorage#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage#timeouts DataAzurermDataShareDatasetBlobStorage#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDataShareDatasetBlobStorageTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetBlobStorageStorageAccount extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetBlobStorageTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage#read DataAzurermDataShareDatasetBlobStorage#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetBlobStorageTimeoutsToTerraform(struct?: DataAzurermDataShareDatasetBlobStorageTimeoutsOutputReference | DataAzurermDataShareDatasetBlobStorageTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetBlobStorageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDataShareDatasetBlobStorageTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDataShareDatasetBlobStorageTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage azurerm_data_share_dataset_blob_storage}.
 *
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetBlobStorage extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage azurerm_data_share_dataset_blob_storage} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetBlobStorageConfig);
    /**
     * @stability stable
     */
    get containerName(): string;
    private _dataShareId?;
    /**
     * @stability stable
     */
    get dataShareId(): string;
    /**
     * @stability stable
     */
    set dataShareId(value: string);
    /**
     * @stability stable
     */
    get dataShareIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get filePath(): string;
    /**
     * @stability stable
     */
    get folderPath(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    storageAccount(index: string): DataAzurermDataShareDatasetBlobStorageStorageAccount;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDataShareDatasetBlobStorageTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDataShareDatasetBlobStorageTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDataShareDatasetBlobStorageTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
