import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermEventhubAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule#eventhub_name DataAzurermEventhubAuthorizationRule#eventhub_name}.
     *
     * @stability stable
     */
    readonly eventhubName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule#listen DataAzurermEventhubAuthorizationRule#listen}.
     *
     * @stability stable
     */
    readonly listen?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule#manage DataAzurermEventhubAuthorizationRule#manage}.
     *
     * @stability stable
     */
    readonly manage?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule#name DataAzurermEventhubAuthorizationRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule#namespace_name DataAzurermEventhubAuthorizationRule#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule#resource_group_name DataAzurermEventhubAuthorizationRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule#send DataAzurermEventhubAuthorizationRule#send}.
     *
     * @stability stable
     */
    readonly send?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule#timeouts DataAzurermEventhubAuthorizationRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermEventhubAuthorizationRuleTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermEventhubAuthorizationRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule#read DataAzurermEventhubAuthorizationRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermEventhubAuthorizationRuleTimeoutsToTerraform(struct?: DataAzurermEventhubAuthorizationRuleTimeoutsOutputReference | DataAzurermEventhubAuthorizationRuleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermEventhubAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermEventhubAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermEventhubAuthorizationRuleTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule azurerm_eventhub_authorization_rule}.
 *
 * @stability stable
 */
export declare class DataAzurermEventhubAuthorizationRule extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_authorization_rule azurerm_eventhub_authorization_rule} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermEventhubAuthorizationRuleConfig);
    private _eventhubName?;
    /**
     * @stability stable
     */
    get eventhubName(): string;
    /**
     * @stability stable
     */
    set eventhubName(value: string);
    /**
     * @stability stable
     */
    get eventhubNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _listen?;
    /**
     * @stability stable
     */
    get listen(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set listen(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetListen(): void;
    /**
     * @stability stable
     */
    get listenInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get location(): string;
    private _manage?;
    /**
     * @stability stable
     */
    get manage(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set manage(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManage(): void;
    /**
     * @stability stable
     */
    get manageInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryConnectionStringAlias(): string;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionStringAlias(): string;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    private _send?;
    /**
     * @stability stable
     */
    get send(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set send(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSend(): void;
    /**
     * @stability stable
     */
    get sendInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermEventhubAuthorizationRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermEventhubAuthorizationRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermEventhubAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
