import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermImagesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/images#resource_group_name DataAzurermImages#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/images#tags_filter DataAzurermImages#tags_filter}.
     *
     * @stability stable
     */
    readonly tagsFilter?: {
        [key: string]: string;
    };
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/images#timeouts DataAzurermImages#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermImagesTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermImagesImagesDataDisk extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get blobUri(): string;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    get lun(): number;
    /**
     * @stability stable
     */
    get managedDiskId(): string;
    /**
     * @stability stable
     */
    get sizeGb(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermImagesImagesOsDisk extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get blobUri(): string;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    get managedDiskId(): string;
    /**
     * @stability stable
     */
    get osState(): string;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    get sizeGb(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermImagesImages extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dataDisk(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get osDisk(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    get zoneResilient(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DataAzurermImagesTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/images#read DataAzurermImages#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermImagesTimeoutsToTerraform(struct?: DataAzurermImagesTimeoutsOutputReference | DataAzurermImagesTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermImagesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermImagesTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermImagesTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/images azurerm_images}.
 *
 * @stability stable
 */
export declare class DataAzurermImages extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/images azurerm_images} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermImagesConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    images(index: string): DataAzurermImagesImages;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tagsFilter?;
    /**
     * @stability stable
     */
    get tagsFilter(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tagsFilter(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTagsFilter(): void;
    /**
     * @stability stable
     */
    get tagsFilterInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermImagesTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermImagesTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermImagesTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
