import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key#key_vault_id DataAzurermKeyVaultKey#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key#name DataAzurermKeyVaultKey#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key#timeouts DataAzurermKeyVaultKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermKeyVaultKeyTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key#read DataAzurermKeyVaultKey#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultKeyTimeoutsToTerraform(struct?: DataAzurermKeyVaultKeyTimeoutsOutputReference | DataAzurermKeyVaultKeyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermKeyVaultKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermKeyVaultKeyTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key azurerm_key_vault_key}.
 *
 * @stability stable
 */
export declare class DataAzurermKeyVaultKey extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key azurerm_key_vault_key} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultKeyConfig);
    /**
     * @stability stable
     */
    get curve(): string;
    /**
     * @stability stable
     */
    get e(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get keyOpts(): string[];
    /**
     * @stability stable
     */
    get keySize(): number;
    /**
     * @stability stable
     */
    get keyType(): string;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get n(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicKeyOpenssh(): string;
    /**
     * @stability stable
     */
    get publicKeyPem(): string;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    get versionlessId(): string;
    /**
     * @stability stable
     */
    get x(): string;
    /**
     * @stability stable
     */
    get y(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermKeyVaultKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermKeyVaultKeyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermKeyVaultKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
