import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermLogicAppWorkflowConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow#name DataAzurermLogicAppWorkflow#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow#resource_group_name DataAzurermLogicAppWorkflow#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow#timeouts DataAzurermLogicAppWorkflow#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermLogicAppWorkflowTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermLogicAppWorkflowIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermLogicAppWorkflowTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow#read DataAzurermLogicAppWorkflow#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermLogicAppWorkflowTimeoutsToTerraform(struct?: DataAzurermLogicAppWorkflowTimeoutsOutputReference | DataAzurermLogicAppWorkflowTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermLogicAppWorkflowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermLogicAppWorkflowTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermLogicAppWorkflowTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow azurerm_logic_app_workflow}.
 *
 * @stability stable
 */
export declare class DataAzurermLogicAppWorkflow extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow azurerm_logic_app_workflow} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermLogicAppWorkflowConfig);
    /**
     * @stability stable
     */
    get accessEndpoint(): string;
    /**
     * @stability stable
     */
    get connectorEndpointIpAddresses(): string[];
    /**
     * @stability stable
     */
    get connectorOutboundIpAddresses(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermLogicAppWorkflowIdentity;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get logicAppIntegrationAccountId(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    parameters(key: string): string | cdktf.IResolvable;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get workflowEndpointIpAddresses(): string[];
    /**
     * @stability stable
     */
    get workflowOutboundIpAddresses(): string[];
    /**
     * @stability stable
     */
    get workflowSchema(): string;
    /**
     * @stability stable
     */
    get workflowVersion(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermLogicAppWorkflowTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermLogicAppWorkflowTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermLogicAppWorkflowTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
