import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermNetappSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot#account_name DataAzurermNetappSnapshot#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot#name DataAzurermNetappSnapshot#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot#pool_name DataAzurermNetappSnapshot#pool_name}.
     *
     * @stability stable
     */
    readonly poolName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot#resource_group_name DataAzurermNetappSnapshot#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot#volume_name DataAzurermNetappSnapshot#volume_name}.
     *
     * @stability stable
     */
    readonly volumeName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot#timeouts DataAzurermNetappSnapshot#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermNetappSnapshotTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermNetappSnapshotTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot#read DataAzurermNetappSnapshot#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermNetappSnapshotTimeoutsToTerraform(struct?: DataAzurermNetappSnapshotTimeoutsOutputReference | DataAzurermNetappSnapshotTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermNetappSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermNetappSnapshotTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermNetappSnapshotTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot azurerm_netapp_snapshot}.
 *
 * @stability stable
 */
export declare class DataAzurermNetappSnapshot extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot azurerm_netapp_snapshot} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermNetappSnapshotConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _poolName?;
    /**
     * @stability stable
     */
    get poolName(): string;
    /**
     * @stability stable
     */
    set poolName(value: string);
    /**
     * @stability stable
     */
    get poolNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _volumeName?;
    /**
     * @stability stable
     */
    get volumeName(): string;
    /**
     * @stability stable
     */
    set volumeName(value: string);
    /**
     * @stability stable
     */
    get volumeNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermNetappSnapshotTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermNetappSnapshotTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermNetappSnapshotTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
