import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermPostgresqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server#name DataAzurermPostgresqlFlexibleServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server#resource_group_name DataAzurermPostgresqlFlexibleServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server#timeouts DataAzurermPostgresqlFlexibleServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermPostgresqlFlexibleServerTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermPostgresqlFlexibleServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server#read DataAzurermPostgresqlFlexibleServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermPostgresqlFlexibleServerTimeoutsToTerraform(struct?: DataAzurermPostgresqlFlexibleServerTimeoutsOutputReference | DataAzurermPostgresqlFlexibleServerTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermPostgresqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermPostgresqlFlexibleServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermPostgresqlFlexibleServerTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server azurerm_postgresql_flexible_server}.
 *
 * @stability stable
 */
export declare class DataAzurermPostgresqlFlexibleServer extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server azurerm_postgresql_flexible_server} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermPostgresqlFlexibleServerConfig);
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    get cmkEnabled(): string;
    /**
     * @stability stable
     */
    get delegatedSubnetId(): string;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    get storageMb(): number;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get version(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermPostgresqlFlexibleServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermPostgresqlFlexibleServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermPostgresqlFlexibleServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
