import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermServicebusQueueConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue#name DataAzurermServicebusQueue#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue#namespace_name DataAzurermServicebusQueue#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue#resource_group_name DataAzurermServicebusQueue#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue#timeouts DataAzurermServicebusQueue#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermServicebusQueueTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermServicebusQueueTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue#read DataAzurermServicebusQueue#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermServicebusQueueTimeoutsToTerraform(struct?: DataAzurermServicebusQueueTimeoutsOutputReference | DataAzurermServicebusQueueTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermServicebusQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermServicebusQueueTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermServicebusQueueTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue azurerm_servicebus_queue}.
 *
 * @stability stable
 */
export declare class DataAzurermServicebusQueue extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue azurerm_servicebus_queue} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusQueueConfig);
    /**
     * @stability stable
     */
    get autoDeleteOnIdle(): string;
    /**
     * @stability stable
     */
    get deadLetteringOnMessageExpiration(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get defaultMessageTtl(): string;
    /**
     * @stability stable
     */
    get duplicateDetectionHistoryTimeWindow(): string;
    /**
     * @stability stable
     */
    get enableBatchedOperations(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get enableExpress(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get enablePartitioning(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get forwardDeadLetteredMessagesTo(): string;
    /**
     * @stability stable
     */
    get forwardTo(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lockDuration(): string;
    /**
     * @stability stable
     */
    get maxDeliveryCount(): number;
    /**
     * @stability stable
     */
    get maxSizeInMegabytes(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get requiresDuplicateDetection(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get requiresSession(): cdktf.IResolvable;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermServicebusQueueTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermServicebusQueueTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermServicebusQueueTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
