import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountBlobContainerSasConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#cache_control DataAzurermStorageAccountBlobContainerSas#cache_control}.
     *
     * @stability stable
     */
    readonly cacheControl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#connection_string DataAzurermStorageAccountBlobContainerSas#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#container_name DataAzurermStorageAccountBlobContainerSas#container_name}.
     *
     * @stability stable
     */
    readonly containerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#content_disposition DataAzurermStorageAccountBlobContainerSas#content_disposition}.
     *
     * @stability stable
     */
    readonly contentDisposition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#content_encoding DataAzurermStorageAccountBlobContainerSas#content_encoding}.
     *
     * @stability stable
     */
    readonly contentEncoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#content_language DataAzurermStorageAccountBlobContainerSas#content_language}.
     *
     * @stability stable
     */
    readonly contentLanguage?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#content_type DataAzurermStorageAccountBlobContainerSas#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#expiry DataAzurermStorageAccountBlobContainerSas#expiry}.
     *
     * @stability stable
     */
    readonly expiry: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#https_only DataAzurermStorageAccountBlobContainerSas#https_only}.
     *
     * @stability stable
     */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#ip_address DataAzurermStorageAccountBlobContainerSas#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#start DataAzurermStorageAccountBlobContainerSas#start}.
     *
     * @stability stable
     */
    readonly start: string;
    /**
     * permissions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#permissions DataAzurermStorageAccountBlobContainerSas#permissions}
     *
     * @stability stable
     */
    readonly permissions: DataAzurermStorageAccountBlobContainerSasPermissions;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#timeouts DataAzurermStorageAccountBlobContainerSas#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStorageAccountBlobContainerSasTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountBlobContainerSasPermissions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#add DataAzurermStorageAccountBlobContainerSas#add}.
     *
     * @stability stable
     */
    readonly add: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#create DataAzurermStorageAccountBlobContainerSas#create}.
     *
     * @stability stable
     */
    readonly create: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#delete DataAzurermStorageAccountBlobContainerSas#delete}.
     *
     * @stability stable
     */
    readonly delete: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#list DataAzurermStorageAccountBlobContainerSas#list}.
     *
     * @stability stable
     */
    readonly list: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#read DataAzurermStorageAccountBlobContainerSas#read}.
     *
     * @stability stable
     */
    readonly read: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#write DataAzurermStorageAccountBlobContainerSas#write}.
     *
     * @stability stable
     */
    readonly write: boolean | cdktf.IResolvable;
}
export declare function dataAzurermStorageAccountBlobContainerSasPermissionsToTerraform(struct?: DataAzurermStorageAccountBlobContainerSasPermissionsOutputReference | DataAzurermStorageAccountBlobContainerSasPermissions): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageAccountBlobContainerSasPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageAccountBlobContainerSasPermissions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageAccountBlobContainerSasPermissions | undefined);
    private _add?;
    /**
     * @stability stable
     */
    get add(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set add(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get addInput(): boolean | cdktf.IResolvable | undefined;
    private _create?;
    /**
     * @stability stable
     */
    get create(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set create(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get createInput(): boolean | cdktf.IResolvable | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set delete(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get deleteInput(): boolean | cdktf.IResolvable | undefined;
    private _list?;
    /**
     * @stability stable
     */
    get list(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set list(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get listInput(): boolean | cdktf.IResolvable | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set read(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get readInput(): boolean | cdktf.IResolvable | undefined;
    private _write?;
    /**
     * @stability stable
     */
    get write(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set write(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get writeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountBlobContainerSasTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas#read DataAzurermStorageAccountBlobContainerSas#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStorageAccountBlobContainerSasTimeoutsToTerraform(struct?: DataAzurermStorageAccountBlobContainerSasTimeoutsOutputReference | DataAzurermStorageAccountBlobContainerSasTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageAccountBlobContainerSasTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageAccountBlobContainerSasTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageAccountBlobContainerSasTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas azurerm_storage_account_blob_container_sas}.
 *
 * @stability stable
 */
export declare class DataAzurermStorageAccountBlobContainerSas extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_blob_container_sas azurerm_storage_account_blob_container_sas} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStorageAccountBlobContainerSasConfig);
    private _cacheControl?;
    /**
     * @stability stable
     */
    get cacheControl(): string;
    /**
     * @stability stable
     */
    set cacheControl(value: string);
    /**
     * @stability stable
     */
    resetCacheControl(): void;
    /**
     * @stability stable
     */
    get cacheControlInput(): string | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    set connectionString(value: string);
    /**
     * @stability stable
     */
    get connectionStringInput(): string | undefined;
    private _containerName?;
    /**
     * @stability stable
     */
    get containerName(): string;
    /**
     * @stability stable
     */
    set containerName(value: string);
    /**
     * @stability stable
     */
    get containerNameInput(): string | undefined;
    private _contentDisposition?;
    /**
     * @stability stable
     */
    get contentDisposition(): string;
    /**
     * @stability stable
     */
    set contentDisposition(value: string);
    /**
     * @stability stable
     */
    resetContentDisposition(): void;
    /**
     * @stability stable
     */
    get contentDispositionInput(): string | undefined;
    private _contentEncoding?;
    /**
     * @stability stable
     */
    get contentEncoding(): string;
    /**
     * @stability stable
     */
    set contentEncoding(value: string);
    /**
     * @stability stable
     */
    resetContentEncoding(): void;
    /**
     * @stability stable
     */
    get contentEncodingInput(): string | undefined;
    private _contentLanguage?;
    /**
     * @stability stable
     */
    get contentLanguage(): string;
    /**
     * @stability stable
     */
    set contentLanguage(value: string);
    /**
     * @stability stable
     */
    resetContentLanguage(): void;
    /**
     * @stability stable
     */
    get contentLanguageInput(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    private _expiry?;
    /**
     * @stability stable
     */
    get expiry(): string;
    /**
     * @stability stable
     */
    set expiry(value: string);
    /**
     * @stability stable
     */
    get expiryInput(): string | undefined;
    private _httpsOnly?;
    /**
     * @stability stable
     */
    get httpsOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpsOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpsOnly(): void;
    /**
     * @stability stable
     */
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    set ipAddress(value: string);
    /**
     * @stability stable
     */
    resetIpAddress(): void;
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    /**
     * @stability stable
     */
    get sas(): string;
    private _start?;
    /**
     * @stability stable
     */
    get start(): string;
    /**
     * @stability stable
     */
    set start(value: string);
    /**
     * @stability stable
     */
    get startInput(): string | undefined;
    private _permissions;
    /**
     * @stability stable
     */
    get permissions(): DataAzurermStorageAccountBlobContainerSasPermissionsOutputReference;
    /**
     * @stability stable
     */
    putPermissions(value: DataAzurermStorageAccountBlobContainerSasPermissions): void;
    /**
     * @stability stable
     */
    get permissionsInput(): DataAzurermStorageAccountBlobContainerSasPermissions | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStorageAccountBlobContainerSasTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStorageAccountBlobContainerSasTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStorageAccountBlobContainerSasTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
