import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermTrafficManagerProfileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#name DataAzurermTrafficManagerProfile#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#resource_group_name DataAzurermTrafficManagerProfile#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#tags DataAzurermTrafficManagerProfile#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#traffic_view_enabled DataAzurermTrafficManagerProfile#traffic_view_enabled}.
     *
     * @stability stable
     */
    readonly trafficViewEnabled?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#timeouts DataAzurermTrafficManagerProfile#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermTrafficManagerProfileTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermTrafficManagerProfileDnsConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get relativeName(): string;
    /**
     * @stability stable
     */
    get ttl(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermTrafficManagerProfileMonitorConfigCustomHeader extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermTrafficManagerProfileMonitorConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get customHeader(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get expectedStatusCodeRanges(): string[];
    /**
     * @stability stable
     */
    get intervalInSeconds(): number;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    get timeoutInSeconds(): number;
    /**
     * @stability stable
     */
    get toleratedNumberOfFailures(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermTrafficManagerProfileTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile#read DataAzurermTrafficManagerProfile#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermTrafficManagerProfileTimeoutsToTerraform(struct?: DataAzurermTrafficManagerProfileTimeoutsOutputReference | DataAzurermTrafficManagerProfileTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermTrafficManagerProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermTrafficManagerProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermTrafficManagerProfileTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile azurerm_traffic_manager_profile}.
 *
 * @stability stable
 */
export declare class DataAzurermTrafficManagerProfile extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/traffic_manager_profile azurerm_traffic_manager_profile} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermTrafficManagerProfileConfig);
    /**
     * @stability stable
     */
    dnsConfig(index: string): DataAzurermTrafficManagerProfileDnsConfig;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    monitorConfig(index: string): DataAzurermTrafficManagerProfileMonitorConfig;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get profileStatus(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get trafficRoutingMethod(): string;
    private _trafficViewEnabled?;
    /**
     * @stability stable
     */
    get trafficViewEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set trafficViewEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTrafficViewEnabled(): void;
    /**
     * @stability stable
     */
    get trafficViewEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermTrafficManagerProfileTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermTrafficManagerProfileTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermTrafficManagerProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
