import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryDatasetCosmosdbSqlapiConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#additional_properties DataFactoryDatasetCosmosdbSqlapi#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#annotations DataFactoryDatasetCosmosdbSqlapi#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#collection_name DataFactoryDatasetCosmosdbSqlapi#collection_name}.
     *
     * @stability stable
     */
    readonly collectionName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#data_factory_id DataFactoryDatasetCosmosdbSqlapi#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#data_factory_name DataFactoryDatasetCosmosdbSqlapi#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#description DataFactoryDatasetCosmosdbSqlapi#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#folder DataFactoryDatasetCosmosdbSqlapi#folder}.
     *
     * @stability stable
     */
    readonly folder?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#linked_service_name DataFactoryDatasetCosmosdbSqlapi#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#name DataFactoryDatasetCosmosdbSqlapi#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#parameters DataFactoryDatasetCosmosdbSqlapi#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#resource_group_name DataFactoryDatasetCosmosdbSqlapi#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * schema_column block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#schema_column DataFactoryDatasetCosmosdbSqlapi#schema_column}
     *
     * @stability stable
     */
    readonly schemaColumn?: DataFactoryDatasetCosmosdbSqlapiSchemaColumn[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#timeouts DataFactoryDatasetCosmosdbSqlapi#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryDatasetCosmosdbSqlapiTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetCosmosdbSqlapiSchemaColumn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#description DataFactoryDatasetCosmosdbSqlapi#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#name DataFactoryDatasetCosmosdbSqlapi#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#type DataFactoryDatasetCosmosdbSqlapi#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function dataFactoryDatasetCosmosdbSqlapiSchemaColumnToTerraform(struct?: DataFactoryDatasetCosmosdbSqlapiSchemaColumn | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataFactoryDatasetCosmosdbSqlapiTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#create DataFactoryDatasetCosmosdbSqlapi#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#delete DataFactoryDatasetCosmosdbSqlapi#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#read DataFactoryDatasetCosmosdbSqlapi#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi#update DataFactoryDatasetCosmosdbSqlapi#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryDatasetCosmosdbSqlapiTimeoutsToTerraform(struct?: DataFactoryDatasetCosmosdbSqlapiTimeoutsOutputReference | DataFactoryDatasetCosmosdbSqlapiTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetCosmosdbSqlapiTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetCosmosdbSqlapiTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetCosmosdbSqlapiTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi azurerm_data_factory_dataset_cosmosdb_sqlapi}.
 *
 * @stability stable
 */
export declare class DataFactoryDatasetCosmosdbSqlapi extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_cosmosdb_sqlapi azurerm_data_factory_dataset_cosmosdb_sqlapi} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetCosmosdbSqlapiConfig);
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _collectionName?;
    /**
     * @stability stable
     */
    get collectionName(): string;
    /**
     * @stability stable
     */
    set collectionName(value: string);
    /**
     * @stability stable
     */
    resetCollectionName(): void;
    /**
     * @stability stable
     */
    get collectionNameInput(): string | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryId(): void;
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryName(): void;
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    resetFolder(): void;
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _schemaColumn?;
    /**
     * @stability stable
     */
    get schemaColumn(): DataFactoryDatasetCosmosdbSqlapiSchemaColumn[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set schemaColumn(value: DataFactoryDatasetCosmosdbSqlapiSchemaColumn[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSchemaColumn(): void;
    /**
     * @stability stable
     */
    get schemaColumnInput(): cdktf.IResolvable | DataFactoryDatasetCosmosdbSqlapiSchemaColumn[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryDatasetCosmosdbSqlapiTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryDatasetCosmosdbSqlapiTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryDatasetCosmosdbSqlapiTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
