import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryDatasetJsonConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#additional_properties DataFactoryDatasetJson#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#annotations DataFactoryDatasetJson#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#data_factory_id DataFactoryDatasetJson#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#data_factory_name DataFactoryDatasetJson#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#description DataFactoryDatasetJson#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#encoding DataFactoryDatasetJson#encoding}.
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#folder DataFactoryDatasetJson#folder}.
     *
     * @stability stable
     */
    readonly folder?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#linked_service_name DataFactoryDatasetJson#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#name DataFactoryDatasetJson#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#parameters DataFactoryDatasetJson#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#resource_group_name DataFactoryDatasetJson#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * azure_blob_storage_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#azure_blob_storage_location DataFactoryDatasetJson#azure_blob_storage_location}
     *
     * @stability stable
     */
    readonly azureBlobStorageLocation?: DataFactoryDatasetJsonAzureBlobStorageLocation;
    /**
     * http_server_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#http_server_location DataFactoryDatasetJson#http_server_location}
     *
     * @stability stable
     */
    readonly httpServerLocation?: DataFactoryDatasetJsonHttpServerLocation;
    /**
     * schema_column block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#schema_column DataFactoryDatasetJson#schema_column}
     *
     * @stability stable
     */
    readonly schemaColumn?: DataFactoryDatasetJsonSchemaColumn[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#timeouts DataFactoryDatasetJson#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryDatasetJsonTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetJsonAzureBlobStorageLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#container DataFactoryDatasetJson#container}.
     *
     * @stability stable
     */
    readonly container: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#dynamic_filename_enabled DataFactoryDatasetJson#dynamic_filename_enabled}.
     *
     * @stability stable
     */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#dynamic_path_enabled DataFactoryDatasetJson#dynamic_path_enabled}.
     *
     * @stability stable
     */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#filename DataFactoryDatasetJson#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#path DataFactoryDatasetJson#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function dataFactoryDatasetJsonAzureBlobStorageLocationToTerraform(struct?: DataFactoryDatasetJsonAzureBlobStorageLocationOutputReference | DataFactoryDatasetJsonAzureBlobStorageLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetJsonAzureBlobStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetJsonAzureBlobStorageLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetJsonAzureBlobStorageLocation | undefined);
    private _container?;
    /**
     * @stability stable
     */
    get container(): string;
    /**
     * @stability stable
     */
    set container(value: string);
    /**
     * @stability stable
     */
    get containerInput(): string | undefined;
    private _dynamicFilenameEnabled?;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicFilenameEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    /**
     * @stability stable
     */
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicPathEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetJsonHttpServerLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#dynamic_filename_enabled DataFactoryDatasetJson#dynamic_filename_enabled}.
     *
     * @stability stable
     */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#dynamic_path_enabled DataFactoryDatasetJson#dynamic_path_enabled}.
     *
     * @stability stable
     */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#filename DataFactoryDatasetJson#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#path DataFactoryDatasetJson#path}.
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#relative_url DataFactoryDatasetJson#relative_url}.
     *
     * @stability stable
     */
    readonly relativeUrl: string;
}
export declare function dataFactoryDatasetJsonHttpServerLocationToTerraform(struct?: DataFactoryDatasetJsonHttpServerLocationOutputReference | DataFactoryDatasetJsonHttpServerLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetJsonHttpServerLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetJsonHttpServerLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetJsonHttpServerLocation | undefined);
    private _dynamicFilenameEnabled?;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicFilenameEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    /**
     * @stability stable
     */
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicPathEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _relativeUrl?;
    /**
     * @stability stable
     */
    get relativeUrl(): string;
    /**
     * @stability stable
     */
    set relativeUrl(value: string);
    /**
     * @stability stable
     */
    get relativeUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetJsonSchemaColumn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#description DataFactoryDatasetJson#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#name DataFactoryDatasetJson#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#type DataFactoryDatasetJson#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function dataFactoryDatasetJsonSchemaColumnToTerraform(struct?: DataFactoryDatasetJsonSchemaColumn | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataFactoryDatasetJsonTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#create DataFactoryDatasetJson#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#delete DataFactoryDatasetJson#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#read DataFactoryDatasetJson#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#update DataFactoryDatasetJson#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryDatasetJsonTimeoutsToTerraform(struct?: DataFactoryDatasetJsonTimeoutsOutputReference | DataFactoryDatasetJsonTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetJsonTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetJsonTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetJsonTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json azurerm_data_factory_dataset_json}.
 *
 * @stability stable
 */
export declare class DataFactoryDatasetJson extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json azurerm_data_factory_dataset_json} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetJsonConfig);
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryId(): void;
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryName(): void;
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    resetFolder(): void;
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _azureBlobStorageLocation;
    /**
     * @stability stable
     */
    get azureBlobStorageLocation(): DataFactoryDatasetJsonAzureBlobStorageLocationOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobStorageLocation(value: DataFactoryDatasetJsonAzureBlobStorageLocation): void;
    /**
     * @stability stable
     */
    resetAzureBlobStorageLocation(): void;
    /**
     * @stability stable
     */
    get azureBlobStorageLocationInput(): DataFactoryDatasetJsonAzureBlobStorageLocation | undefined;
    private _httpServerLocation;
    /**
     * @stability stable
     */
    get httpServerLocation(): DataFactoryDatasetJsonHttpServerLocationOutputReference;
    /**
     * @stability stable
     */
    putHttpServerLocation(value: DataFactoryDatasetJsonHttpServerLocation): void;
    /**
     * @stability stable
     */
    resetHttpServerLocation(): void;
    /**
     * @stability stable
     */
    get httpServerLocationInput(): DataFactoryDatasetJsonHttpServerLocation | undefined;
    private _schemaColumn?;
    /**
     * @stability stable
     */
    get schemaColumn(): DataFactoryDatasetJsonSchemaColumn[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set schemaColumn(value: DataFactoryDatasetJsonSchemaColumn[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSchemaColumn(): void;
    /**
     * @stability stable
     */
    get schemaColumnInput(): cdktf.IResolvable | DataFactoryDatasetJsonSchemaColumn[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryDatasetJsonTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryDatasetJsonTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryDatasetJsonTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
