import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceOdbcConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#additional_properties DataFactoryLinkedServiceOdbc#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#annotations DataFactoryLinkedServiceOdbc#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#connection_string DataFactoryLinkedServiceOdbc#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#data_factory_id DataFactoryLinkedServiceOdbc#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#description DataFactoryLinkedServiceOdbc#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#integration_runtime_name DataFactoryLinkedServiceOdbc#integration_runtime_name}.
     *
     * @stability stable
     */
    readonly integrationRuntimeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#name DataFactoryLinkedServiceOdbc#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#parameters DataFactoryLinkedServiceOdbc#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#resource_group_name DataFactoryLinkedServiceOdbc#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * basic_authentication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#basic_authentication DataFactoryLinkedServiceOdbc#basic_authentication}
     *
     * @stability stable
     */
    readonly basicAuthentication?: DataFactoryLinkedServiceOdbcBasicAuthentication;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#timeouts DataFactoryLinkedServiceOdbc#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryLinkedServiceOdbcTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceOdbcBasicAuthentication {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#password DataFactoryLinkedServiceOdbc#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#username DataFactoryLinkedServiceOdbc#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function dataFactoryLinkedServiceOdbcBasicAuthenticationToTerraform(struct?: DataFactoryLinkedServiceOdbcBasicAuthenticationOutputReference | DataFactoryLinkedServiceOdbcBasicAuthentication): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceOdbcBasicAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceOdbcBasicAuthentication | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceOdbcBasicAuthentication | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceOdbcTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#create DataFactoryLinkedServiceOdbc#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#delete DataFactoryLinkedServiceOdbc#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#read DataFactoryLinkedServiceOdbc#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc#update DataFactoryLinkedServiceOdbc#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryLinkedServiceOdbcTimeoutsToTerraform(struct?: DataFactoryLinkedServiceOdbcTimeoutsOutputReference | DataFactoryLinkedServiceOdbcTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceOdbcTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceOdbcTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceOdbcTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc azurerm_data_factory_linked_service_odbc}.
 *
 * @stability stable
 */
export declare class DataFactoryLinkedServiceOdbc extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_odbc azurerm_data_factory_linked_service_odbc} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryLinkedServiceOdbcConfig);
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    set connectionString(value: string);
    /**
     * @stability stable
     */
    get connectionStringInput(): string | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationRuntimeName?;
    /**
     * @stability stable
     */
    get integrationRuntimeName(): string;
    /**
     * @stability stable
     */
    set integrationRuntimeName(value: string);
    /**
     * @stability stable
     */
    resetIntegrationRuntimeName(): void;
    /**
     * @stability stable
     */
    get integrationRuntimeNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _basicAuthentication;
    /**
     * @stability stable
     */
    get basicAuthentication(): DataFactoryLinkedServiceOdbcBasicAuthenticationOutputReference;
    /**
     * @stability stable
     */
    putBasicAuthentication(value: DataFactoryLinkedServiceOdbcBasicAuthentication): void;
    /**
     * @stability stable
     */
    resetBasicAuthentication(): void;
    /**
     * @stability stable
     */
    get basicAuthenticationInput(): DataFactoryLinkedServiceOdbcBasicAuthentication | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryLinkedServiceOdbcTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryLinkedServiceOdbcTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryLinkedServiceOdbcTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
