import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyBlobStorageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage#name DataProtectionBackupPolicyBlobStorage#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage#retention_duration DataProtectionBackupPolicyBlobStorage#retention_duration}.
     *
     * @stability stable
     */
    readonly retentionDuration: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage#vault_id DataProtectionBackupPolicyBlobStorage#vault_id}.
     *
     * @stability stable
     */
    readonly vaultId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage#timeouts DataProtectionBackupPolicyBlobStorage#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataProtectionBackupPolicyBlobStorageTimeouts;
}
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyBlobStorageTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage#create DataProtectionBackupPolicyBlobStorage#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage#delete DataProtectionBackupPolicyBlobStorage#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage#read DataProtectionBackupPolicyBlobStorage#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage#update DataProtectionBackupPolicyBlobStorage#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataProtectionBackupPolicyBlobStorageTimeoutsToTerraform(struct?: DataProtectionBackupPolicyBlobStorageTimeoutsOutputReference | DataProtectionBackupPolicyBlobStorageTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataProtectionBackupPolicyBlobStorageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataProtectionBackupPolicyBlobStorageTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataProtectionBackupPolicyBlobStorageTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage azurerm_data_protection_backup_policy_blob_storage}.
 *
 * @stability stable
 */
export declare class DataProtectionBackupPolicyBlobStorage extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_blob_storage azurerm_data_protection_backup_policy_blob_storage} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataProtectionBackupPolicyBlobStorageConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _retentionDuration?;
    /**
     * @stability stable
     */
    get retentionDuration(): string;
    /**
     * @stability stable
     */
    set retentionDuration(value: string);
    /**
     * @stability stable
     */
    get retentionDurationInput(): string | undefined;
    private _vaultId?;
    /**
     * @stability stable
     */
    get vaultId(): string;
    /**
     * @stability stable
     */
    set vaultId(value: string);
    /**
     * @stability stable
     */
    get vaultIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataProtectionBackupPolicyBlobStorageTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataProtectionBackupPolicyBlobStorageTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataProtectionBackupPolicyBlobStorageTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
