import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DedicatedHardwareSecurityModuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#location DedicatedHardwareSecurityModule#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#name DedicatedHardwareSecurityModule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#resource_group_name DedicatedHardwareSecurityModule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#sku_name DedicatedHardwareSecurityModule#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#stamp_id DedicatedHardwareSecurityModule#stamp_id}.
     *
     * @stability stable
     */
    readonly stampId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#tags DedicatedHardwareSecurityModule#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#zones DedicatedHardwareSecurityModule#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * network_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#network_profile DedicatedHardwareSecurityModule#network_profile}
     *
     * @stability stable
     */
    readonly networkProfile: DedicatedHardwareSecurityModuleNetworkProfile;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#timeouts DedicatedHardwareSecurityModule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DedicatedHardwareSecurityModuleTimeouts;
}
/**
 * @stability stable
 */
export interface DedicatedHardwareSecurityModuleNetworkProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#network_interface_private_ip_addresses DedicatedHardwareSecurityModule#network_interface_private_ip_addresses}.
     *
     * @stability stable
     */
    readonly networkInterfacePrivateIpAddresses: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#subnet_id DedicatedHardwareSecurityModule#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function dedicatedHardwareSecurityModuleNetworkProfileToTerraform(struct?: DedicatedHardwareSecurityModuleNetworkProfileOutputReference | DedicatedHardwareSecurityModuleNetworkProfile): any;
/**
 * @stability stable
 */
export declare class DedicatedHardwareSecurityModuleNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DedicatedHardwareSecurityModuleNetworkProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DedicatedHardwareSecurityModuleNetworkProfile | undefined);
    private _networkInterfacePrivateIpAddresses?;
    /**
     * @stability stable
     */
    get networkInterfacePrivateIpAddresses(): string[];
    /**
     * @stability stable
     */
    set networkInterfacePrivateIpAddresses(value: string[]);
    /**
     * @stability stable
     */
    get networkInterfacePrivateIpAddressesInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DedicatedHardwareSecurityModuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#create DedicatedHardwareSecurityModule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#delete DedicatedHardwareSecurityModule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#read DedicatedHardwareSecurityModule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module#update DedicatedHardwareSecurityModule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dedicatedHardwareSecurityModuleTimeoutsToTerraform(struct?: DedicatedHardwareSecurityModuleTimeoutsOutputReference | DedicatedHardwareSecurityModuleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DedicatedHardwareSecurityModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DedicatedHardwareSecurityModuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DedicatedHardwareSecurityModuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module azurerm_dedicated_hardware_security_module}.
 *
 * @stability stable
 */
export declare class DedicatedHardwareSecurityModule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dedicated_hardware_security_module azurerm_dedicated_hardware_security_module} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DedicatedHardwareSecurityModuleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _stampId?;
    /**
     * @stability stable
     */
    get stampId(): string;
    /**
     * @stability stable
     */
    set stampId(value: string);
    /**
     * @stability stable
     */
    resetStampId(): void;
    /**
     * @stability stable
     */
    get stampIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _networkProfile;
    /**
     * @stability stable
     */
    get networkProfile(): DedicatedHardwareSecurityModuleNetworkProfileOutputReference;
    /**
     * @stability stable
     */
    putNetworkProfile(value: DedicatedHardwareSecurityModuleNetworkProfile): void;
    /**
     * @stability stable
     */
    get networkProfileInput(): DedicatedHardwareSecurityModuleNetworkProfile | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DedicatedHardwareSecurityModuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DedicatedHardwareSecurityModuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DedicatedHardwareSecurityModuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
