import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DevTestScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#lab_name DevTestSchedule#lab_name}.
     *
     * @stability stable
     */
    readonly labName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#location DevTestSchedule#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#name DevTestSchedule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#resource_group_name DevTestSchedule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#status DevTestSchedule#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#tags DevTestSchedule#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#task_type DevTestSchedule#task_type}.
     *
     * @stability stable
     */
    readonly taskType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#time_zone_id DevTestSchedule#time_zone_id}.
     *
     * @stability stable
     */
    readonly timeZoneId: string;
    /**
     * daily_recurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#daily_recurrence DevTestSchedule#daily_recurrence}
     *
     * @stability stable
     */
    readonly dailyRecurrence?: DevTestScheduleDailyRecurrence;
    /**
     * hourly_recurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#hourly_recurrence DevTestSchedule#hourly_recurrence}
     *
     * @stability stable
     */
    readonly hourlyRecurrence?: DevTestScheduleHourlyRecurrence;
    /**
     * notification_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#notification_settings DevTestSchedule#notification_settings}
     *
     * @stability stable
     */
    readonly notificationSettings: DevTestScheduleNotificationSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#timeouts DevTestSchedule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DevTestScheduleTimeouts;
    /**
     * weekly_recurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#weekly_recurrence DevTestSchedule#weekly_recurrence}
     *
     * @stability stable
     */
    readonly weeklyRecurrence?: DevTestScheduleWeeklyRecurrence;
}
/**
 * @stability stable
 */
export interface DevTestScheduleDailyRecurrence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#time DevTestSchedule#time}.
     *
     * @stability stable
     */
    readonly time: string;
}
export declare function devTestScheduleDailyRecurrenceToTerraform(struct?: DevTestScheduleDailyRecurrenceOutputReference | DevTestScheduleDailyRecurrence): any;
/**
 * @stability stable
 */
export declare class DevTestScheduleDailyRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestScheduleDailyRecurrence | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestScheduleDailyRecurrence | undefined);
    private _time?;
    /**
     * @stability stable
     */
    get time(): string;
    /**
     * @stability stable
     */
    set time(value: string);
    /**
     * @stability stable
     */
    get timeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DevTestScheduleHourlyRecurrence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#minute DevTestSchedule#minute}.
     *
     * @stability stable
     */
    readonly minute: number;
}
export declare function devTestScheduleHourlyRecurrenceToTerraform(struct?: DevTestScheduleHourlyRecurrenceOutputReference | DevTestScheduleHourlyRecurrence): any;
/**
 * @stability stable
 */
export declare class DevTestScheduleHourlyRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestScheduleHourlyRecurrence | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestScheduleHourlyRecurrence | undefined);
    private _minute?;
    /**
     * @stability stable
     */
    get minute(): number;
    /**
     * @stability stable
     */
    set minute(value: number);
    /**
     * @stability stable
     */
    get minuteInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DevTestScheduleNotificationSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#status DevTestSchedule#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#time_in_minutes DevTestSchedule#time_in_minutes}.
     *
     * @stability stable
     */
    readonly timeInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#webhook_url DevTestSchedule#webhook_url}.
     *
     * @stability stable
     */
    readonly webhookUrl?: string;
}
export declare function devTestScheduleNotificationSettingsToTerraform(struct?: DevTestScheduleNotificationSettingsOutputReference | DevTestScheduleNotificationSettings): any;
/**
 * @stability stable
 */
export declare class DevTestScheduleNotificationSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestScheduleNotificationSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestScheduleNotificationSettings | undefined);
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _timeInMinutes?;
    /**
     * @stability stable
     */
    get timeInMinutes(): number;
    /**
     * @stability stable
     */
    set timeInMinutes(value: number);
    /**
     * @stability stable
     */
    resetTimeInMinutes(): void;
    /**
     * @stability stable
     */
    get timeInMinutesInput(): number | undefined;
    private _webhookUrl?;
    /**
     * @stability stable
     */
    get webhookUrl(): string;
    /**
     * @stability stable
     */
    set webhookUrl(value: string);
    /**
     * @stability stable
     */
    resetWebhookUrl(): void;
    /**
     * @stability stable
     */
    get webhookUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DevTestScheduleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#create DevTestSchedule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#delete DevTestSchedule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#read DevTestSchedule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#update DevTestSchedule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function devTestScheduleTimeoutsToTerraform(struct?: DevTestScheduleTimeoutsOutputReference | DevTestScheduleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DevTestScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestScheduleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestScheduleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DevTestScheduleWeeklyRecurrence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#time DevTestSchedule#time}.
     *
     * @stability stable
     */
    readonly time: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#week_days DevTestSchedule#week_days}.
     *
     * @stability stable
     */
    readonly weekDays?: string[];
}
export declare function devTestScheduleWeeklyRecurrenceToTerraform(struct?: DevTestScheduleWeeklyRecurrenceOutputReference | DevTestScheduleWeeklyRecurrence): any;
/**
 * @stability stable
 */
export declare class DevTestScheduleWeeklyRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestScheduleWeeklyRecurrence | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestScheduleWeeklyRecurrence | undefined);
    private _time?;
    /**
     * @stability stable
     */
    get time(): string;
    /**
     * @stability stable
     */
    set time(value: string);
    /**
     * @stability stable
     */
    get timeInput(): string | undefined;
    private _weekDays?;
    /**
     * @stability stable
     */
    get weekDays(): string[];
    /**
     * @stability stable
     */
    set weekDays(value: string[]);
    /**
     * @stability stable
     */
    resetWeekDays(): void;
    /**
     * @stability stable
     */
    get weekDaysInput(): string[] | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule azurerm_dev_test_schedule}.
 *
 * @stability stable
 */
export declare class DevTestSchedule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule azurerm_dev_test_schedule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DevTestScheduleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _labName?;
    /**
     * @stability stable
     */
    get labName(): string;
    /**
     * @stability stable
     */
    set labName(value: string);
    /**
     * @stability stable
     */
    get labNameInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _taskType?;
    /**
     * @stability stable
     */
    get taskType(): string;
    /**
     * @stability stable
     */
    set taskType(value: string);
    /**
     * @stability stable
     */
    get taskTypeInput(): string | undefined;
    private _timeZoneId?;
    /**
     * @stability stable
     */
    get timeZoneId(): string;
    /**
     * @stability stable
     */
    set timeZoneId(value: string);
    /**
     * @stability stable
     */
    get timeZoneIdInput(): string | undefined;
    private _dailyRecurrence;
    /**
     * @stability stable
     */
    get dailyRecurrence(): DevTestScheduleDailyRecurrenceOutputReference;
    /**
     * @stability stable
     */
    putDailyRecurrence(value: DevTestScheduleDailyRecurrence): void;
    /**
     * @stability stable
     */
    resetDailyRecurrence(): void;
    /**
     * @stability stable
     */
    get dailyRecurrenceInput(): DevTestScheduleDailyRecurrence | undefined;
    private _hourlyRecurrence;
    /**
     * @stability stable
     */
    get hourlyRecurrence(): DevTestScheduleHourlyRecurrenceOutputReference;
    /**
     * @stability stable
     */
    putHourlyRecurrence(value: DevTestScheduleHourlyRecurrence): void;
    /**
     * @stability stable
     */
    resetHourlyRecurrence(): void;
    /**
     * @stability stable
     */
    get hourlyRecurrenceInput(): DevTestScheduleHourlyRecurrence | undefined;
    private _notificationSettings;
    /**
     * @stability stable
     */
    get notificationSettings(): DevTestScheduleNotificationSettingsOutputReference;
    /**
     * @stability stable
     */
    putNotificationSettings(value: DevTestScheduleNotificationSettings): void;
    /**
     * @stability stable
     */
    get notificationSettingsInput(): DevTestScheduleNotificationSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DevTestScheduleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DevTestScheduleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DevTestScheduleTimeouts | undefined;
    private _weeklyRecurrence;
    /**
     * @stability stable
     */
    get weeklyRecurrence(): DevTestScheduleWeeklyRecurrenceOutputReference;
    /**
     * @stability stable
     */
    putWeeklyRecurrence(value: DevTestScheduleWeeklyRecurrence): void;
    /**
     * @stability stable
     */
    resetWeeklyRecurrence(): void;
    /**
     * @stability stable
     */
    get weeklyRecurrenceInput(): DevTestScheduleWeeklyRecurrence | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
