import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsCaaRecordConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#name DnsCaaRecord#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#resource_group_name DnsCaaRecord#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#tags DnsCaaRecord#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#ttl DnsCaaRecord#ttl}.
     *
     * @stability stable
     */
    readonly ttl: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#zone_name DnsCaaRecord#zone_name}.
     *
     * @stability stable
     */
    readonly zoneName: string;
    /**
     * record block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#record DnsCaaRecord#record}
     *
     * @stability stable
     */
    readonly record: DnsCaaRecordRecord[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#timeouts DnsCaaRecord#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsCaaRecordTimeouts;
}
/**
 * @stability stable
 */
export interface DnsCaaRecordRecord {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#flags DnsCaaRecord#flags}.
     *
     * @stability stable
     */
    readonly flags: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#tag DnsCaaRecord#tag}.
     *
     * @stability stable
     */
    readonly tag: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#value DnsCaaRecord#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function dnsCaaRecordRecordToTerraform(struct?: DnsCaaRecordRecord | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DnsCaaRecordTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#create DnsCaaRecord#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#delete DnsCaaRecord#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#read DnsCaaRecord#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#update DnsCaaRecord#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dnsCaaRecordTimeoutsToTerraform(struct?: DnsCaaRecordTimeoutsOutputReference | DnsCaaRecordTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DnsCaaRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsCaaRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsCaaRecordTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record azurerm_dns_caa_record}.
 *
 * @stability stable
 */
export declare class DnsCaaRecord extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record azurerm_dns_caa_record} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsCaaRecordConfig);
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    set ttl(value: number);
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
    private _zoneName?;
    /**
     * @stability stable
     */
    get zoneName(): string;
    /**
     * @stability stable
     */
    set zoneName(value: string);
    /**
     * @stability stable
     */
    get zoneNameInput(): string | undefined;
    private _record?;
    /**
     * @stability stable
     */
    get record(): DnsCaaRecordRecord[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set record(value: DnsCaaRecordRecord[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get recordInput(): cdktf.IResolvable | DnsCaaRecordRecord[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DnsCaaRecordTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DnsCaaRecordTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsCaaRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
