import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsTxtRecordConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#name DnsTxtRecord#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#resource_group_name DnsTxtRecord#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#tags DnsTxtRecord#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#ttl DnsTxtRecord#ttl}.
     *
     * @stability stable
     */
    readonly ttl: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#zone_name DnsTxtRecord#zone_name}.
     *
     * @stability stable
     */
    readonly zoneName: string;
    /**
     * record block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#record DnsTxtRecord#record}
     *
     * @stability stable
     */
    readonly record: DnsTxtRecordRecord[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#timeouts DnsTxtRecord#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsTxtRecordTimeouts;
}
/**
 * @stability stable
 */
export interface DnsTxtRecordRecord {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#value DnsTxtRecord#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function dnsTxtRecordRecordToTerraform(struct?: DnsTxtRecordRecord | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DnsTxtRecordTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#create DnsTxtRecord#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#delete DnsTxtRecord#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#read DnsTxtRecord#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record#update DnsTxtRecord#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dnsTxtRecordTimeoutsToTerraform(struct?: DnsTxtRecordTimeoutsOutputReference | DnsTxtRecordTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DnsTxtRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsTxtRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsTxtRecordTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record azurerm_dns_txt_record}.
 *
 * @stability stable
 */
export declare class DnsTxtRecord extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dns_txt_record azurerm_dns_txt_record} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsTxtRecordConfig);
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    set ttl(value: number);
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
    private _zoneName?;
    /**
     * @stability stable
     */
    get zoneName(): string;
    /**
     * @stability stable
     */
    set zoneName(value: string);
    /**
     * @stability stable
     */
    get zoneNameInput(): string | undefined;
    private _record?;
    /**
     * @stability stable
     */
    get record(): DnsTxtRecordRecord[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set record(value: DnsTxtRecordRecord[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get recordInput(): cdktf.IResolvable | DnsTxtRecordRecord[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DnsTxtRecordTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DnsTxtRecordTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsTxtRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
