import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FrontdoorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pools_send_receive_timeout_seconds Frontdoor#backend_pools_send_receive_timeout_seconds}.
     *
     * @stability stable
     */
    readonly backendPoolsSendReceiveTimeoutSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#enforce_backend_pools_certificate_name_check Frontdoor#enforce_backend_pools_certificate_name_check}.
     *
     * @stability stable
     */
    readonly enforceBackendPoolsCertificateNameCheck: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#friendly_name Frontdoor#friendly_name}.
     *
     * @stability stable
     */
    readonly friendlyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#load_balancer_enabled Frontdoor#load_balancer_enabled}.
     *
     * @stability stable
     */
    readonly loadBalancerEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#location Frontdoor#location}.
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#resource_group_name Frontdoor#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#tags Frontdoor#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * backend_pool block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pool Frontdoor#backend_pool}
     *
     * @stability stable
     */
    readonly backendPool: FrontdoorBackendPool[] | cdktf.IResolvable;
    /**
     * backend_pool_health_probe block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pool_health_probe Frontdoor#backend_pool_health_probe}
     *
     * @stability stable
     */
    readonly backendPoolHealthProbe: FrontdoorBackendPoolHealthProbe[] | cdktf.IResolvable;
    /**
     * backend_pool_load_balancing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pool_load_balancing Frontdoor#backend_pool_load_balancing}
     *
     * @stability stable
     */
    readonly backendPoolLoadBalancing: FrontdoorBackendPoolLoadBalancing[] | cdktf.IResolvable;
    /**
     * frontend_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#frontend_endpoint Frontdoor#frontend_endpoint}
     *
     * @stability stable
     */
    readonly frontendEndpoint: FrontdoorFrontendEndpoint[] | cdktf.IResolvable;
    /**
     * routing_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#routing_rule Frontdoor#routing_rule}
     *
     * @stability stable
     */
    readonly routingRule: FrontdoorRoutingRule[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#timeouts Frontdoor#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FrontdoorTimeouts;
}
/**
 * @stability stable
 */
export declare class FrontdoorExplicitResourceOrder extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get backendPoolHealthProbeIds(): string[];
    /**
     * @stability stable
     */
    get backendPoolIds(): string[];
    /**
     * @stability stable
     */
    get backendPoolLoadBalancingIds(): string[];
    /**
     * @stability stable
     */
    get frontendEndpointIds(): string[];
    /**
     * @stability stable
     */
    get routingRuleIds(): string[];
}
/**
 * @stability stable
 */
export interface FrontdoorBackendPoolBackend {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#address Frontdoor#address}.
     *
     * @stability stable
     */
    readonly address: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#enabled Frontdoor#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#host_header Frontdoor#host_header}.
     *
     * @stability stable
     */
    readonly hostHeader: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#http_port Frontdoor#http_port}.
     *
     * @stability stable
     */
    readonly httpPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#https_port Frontdoor#https_port}.
     *
     * @stability stable
     */
    readonly httpsPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#priority Frontdoor#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#weight Frontdoor#weight}.
     *
     * @stability stable
     */
    readonly weight?: number;
}
export declare function frontdoorBackendPoolBackendToTerraform(struct?: FrontdoorBackendPoolBackend | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FrontdoorBackendPool {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#health_probe_name Frontdoor#health_probe_name}.
     *
     * @stability stable
     */
    readonly healthProbeName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#load_balancing_name Frontdoor#load_balancing_name}.
     *
     * @stability stable
     */
    readonly loadBalancingName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * backend block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend Frontdoor#backend}
     *
     * @stability stable
     */
    readonly backend: FrontdoorBackendPoolBackend[] | cdktf.IResolvable;
}
export declare function frontdoorBackendPoolToTerraform(struct?: FrontdoorBackendPool | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FrontdoorBackendPoolHealthProbe {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#enabled Frontdoor#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#interval_in_seconds Frontdoor#interval_in_seconds}.
     *
     * @stability stable
     */
    readonly intervalInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#path Frontdoor#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#probe_method Frontdoor#probe_method}.
     *
     * @stability stable
     */
    readonly probeMethod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#protocol Frontdoor#protocol}.
     *
     * @stability stable
     */
    readonly protocol?: string;
}
export declare function frontdoorBackendPoolHealthProbeToTerraform(struct?: FrontdoorBackendPoolHealthProbe | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FrontdoorBackendPoolLoadBalancing {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#additional_latency_milliseconds Frontdoor#additional_latency_milliseconds}.
     *
     * @stability stable
     */
    readonly additionalLatencyMilliseconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#sample_size Frontdoor#sample_size}.
     *
     * @stability stable
     */
    readonly sampleSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#successful_samples_required Frontdoor#successful_samples_required}.
     *
     * @stability stable
     */
    readonly successfulSamplesRequired?: number;
}
export declare function frontdoorBackendPoolLoadBalancingToTerraform(struct?: FrontdoorBackendPoolLoadBalancing | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FrontdoorFrontendEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#host_name Frontdoor#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#session_affinity_enabled Frontdoor#session_affinity_enabled}.
     *
     * @stability stable
     */
    readonly sessionAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#session_affinity_ttl_seconds Frontdoor#session_affinity_ttl_seconds}.
     *
     * @stability stable
     */
    readonly sessionAffinityTtlSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#web_application_firewall_policy_link_id Frontdoor#web_application_firewall_policy_link_id}.
     *
     * @stability stable
     */
    readonly webApplicationFirewallPolicyLinkId?: string;
}
export declare function frontdoorFrontendEndpointToTerraform(struct?: FrontdoorFrontendEndpoint | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FrontdoorRoutingRuleForwardingConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pool_name Frontdoor#backend_pool_name}.
     *
     * @stability stable
     */
    readonly backendPoolName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_duration Frontdoor#cache_duration}.
     *
     * @stability stable
     */
    readonly cacheDuration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_enabled Frontdoor#cache_enabled}.
     *
     * @stability stable
     */
    readonly cacheEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_query_parameter_strip_directive Frontdoor#cache_query_parameter_strip_directive}.
     *
     * @stability stable
     */
    readonly cacheQueryParameterStripDirective?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_query_parameters Frontdoor#cache_query_parameters}.
     *
     * @stability stable
     */
    readonly cacheQueryParameters?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_use_dynamic_compression Frontdoor#cache_use_dynamic_compression}.
     *
     * @stability stable
     */
    readonly cacheUseDynamicCompression?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_forwarding_path Frontdoor#custom_forwarding_path}.
     *
     * @stability stable
     */
    readonly customForwardingPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#forwarding_protocol Frontdoor#forwarding_protocol}.
     *
     * @stability stable
     */
    readonly forwardingProtocol?: string;
}
export declare function frontdoorRoutingRuleForwardingConfigurationToTerraform(struct?: FrontdoorRoutingRuleForwardingConfigurationOutputReference | FrontdoorRoutingRuleForwardingConfiguration): any;
/**
 * @stability stable
 */
export declare class FrontdoorRoutingRuleForwardingConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FrontdoorRoutingRuleForwardingConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FrontdoorRoutingRuleForwardingConfiguration | undefined);
    private _backendPoolName?;
    /**
     * @stability stable
     */
    get backendPoolName(): string;
    /**
     * @stability stable
     */
    set backendPoolName(value: string);
    /**
     * @stability stable
     */
    get backendPoolNameInput(): string | undefined;
    private _cacheDuration?;
    /**
     * @stability stable
     */
    get cacheDuration(): string;
    /**
     * @stability stable
     */
    set cacheDuration(value: string);
    /**
     * @stability stable
     */
    resetCacheDuration(): void;
    /**
     * @stability stable
     */
    get cacheDurationInput(): string | undefined;
    private _cacheEnabled?;
    /**
     * @stability stable
     */
    get cacheEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set cacheEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCacheEnabled(): void;
    /**
     * @stability stable
     */
    get cacheEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cacheQueryParameterStripDirective?;
    /**
     * @stability stable
     */
    get cacheQueryParameterStripDirective(): string;
    /**
     * @stability stable
     */
    set cacheQueryParameterStripDirective(value: string);
    /**
     * @stability stable
     */
    resetCacheQueryParameterStripDirective(): void;
    /**
     * @stability stable
     */
    get cacheQueryParameterStripDirectiveInput(): string | undefined;
    private _cacheQueryParameters?;
    /**
     * @stability stable
     */
    get cacheQueryParameters(): string[];
    /**
     * @stability stable
     */
    set cacheQueryParameters(value: string[]);
    /**
     * @stability stable
     */
    resetCacheQueryParameters(): void;
    /**
     * @stability stable
     */
    get cacheQueryParametersInput(): string[] | undefined;
    private _cacheUseDynamicCompression?;
    /**
     * @stability stable
     */
    get cacheUseDynamicCompression(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set cacheUseDynamicCompression(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCacheUseDynamicCompression(): void;
    /**
     * @stability stable
     */
    get cacheUseDynamicCompressionInput(): boolean | cdktf.IResolvable | undefined;
    private _customForwardingPath?;
    /**
     * @stability stable
     */
    get customForwardingPath(): string;
    /**
     * @stability stable
     */
    set customForwardingPath(value: string);
    /**
     * @stability stable
     */
    resetCustomForwardingPath(): void;
    /**
     * @stability stable
     */
    get customForwardingPathInput(): string | undefined;
    private _forwardingProtocol?;
    /**
     * @stability stable
     */
    get forwardingProtocol(): string;
    /**
     * @stability stable
     */
    set forwardingProtocol(value: string);
    /**
     * @stability stable
     */
    resetForwardingProtocol(): void;
    /**
     * @stability stable
     */
    get forwardingProtocolInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FrontdoorRoutingRuleRedirectConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_fragment Frontdoor#custom_fragment}.
     *
     * @stability stable
     */
    readonly customFragment?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_host Frontdoor#custom_host}.
     *
     * @stability stable
     */
    readonly customHost?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_path Frontdoor#custom_path}.
     *
     * @stability stable
     */
    readonly customPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_query_string Frontdoor#custom_query_string}.
     *
     * @stability stable
     */
    readonly customQueryString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#redirect_protocol Frontdoor#redirect_protocol}.
     *
     * @stability stable
     */
    readonly redirectProtocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#redirect_type Frontdoor#redirect_type}.
     *
     * @stability stable
     */
    readonly redirectType: string;
}
export declare function frontdoorRoutingRuleRedirectConfigurationToTerraform(struct?: FrontdoorRoutingRuleRedirectConfigurationOutputReference | FrontdoorRoutingRuleRedirectConfiguration): any;
/**
 * @stability stable
 */
export declare class FrontdoorRoutingRuleRedirectConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FrontdoorRoutingRuleRedirectConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FrontdoorRoutingRuleRedirectConfiguration | undefined);
    private _customFragment?;
    /**
     * @stability stable
     */
    get customFragment(): string;
    /**
     * @stability stable
     */
    set customFragment(value: string);
    /**
     * @stability stable
     */
    resetCustomFragment(): void;
    /**
     * @stability stable
     */
    get customFragmentInput(): string | undefined;
    private _customHost?;
    /**
     * @stability stable
     */
    get customHost(): string;
    /**
     * @stability stable
     */
    set customHost(value: string);
    /**
     * @stability stable
     */
    resetCustomHost(): void;
    /**
     * @stability stable
     */
    get customHostInput(): string | undefined;
    private _customPath?;
    /**
     * @stability stable
     */
    get customPath(): string;
    /**
     * @stability stable
     */
    set customPath(value: string);
    /**
     * @stability stable
     */
    resetCustomPath(): void;
    /**
     * @stability stable
     */
    get customPathInput(): string | undefined;
    private _customQueryString?;
    /**
     * @stability stable
     */
    get customQueryString(): string;
    /**
     * @stability stable
     */
    set customQueryString(value: string);
    /**
     * @stability stable
     */
    resetCustomQueryString(): void;
    /**
     * @stability stable
     */
    get customQueryStringInput(): string | undefined;
    private _redirectProtocol?;
    /**
     * @stability stable
     */
    get redirectProtocol(): string;
    /**
     * @stability stable
     */
    set redirectProtocol(value: string);
    /**
     * @stability stable
     */
    get redirectProtocolInput(): string | undefined;
    private _redirectType?;
    /**
     * @stability stable
     */
    get redirectType(): string;
    /**
     * @stability stable
     */
    set redirectType(value: string);
    /**
     * @stability stable
     */
    get redirectTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FrontdoorRoutingRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#accepted_protocols Frontdoor#accepted_protocols}.
     *
     * @stability stable
     */
    readonly acceptedProtocols: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#enabled Frontdoor#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#frontend_endpoints Frontdoor#frontend_endpoints}.
     *
     * @stability stable
     */
    readonly frontendEndpoints: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#patterns_to_match Frontdoor#patterns_to_match}.
     *
     * @stability stable
     */
    readonly patternsToMatch: string[];
    /**
     * forwarding_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#forwarding_configuration Frontdoor#forwarding_configuration}
     *
     * @stability stable
     */
    readonly forwardingConfiguration?: FrontdoorRoutingRuleForwardingConfiguration;
    /**
     * redirect_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#redirect_configuration Frontdoor#redirect_configuration}
     *
     * @stability stable
     */
    readonly redirectConfiguration?: FrontdoorRoutingRuleRedirectConfiguration;
}
export declare function frontdoorRoutingRuleToTerraform(struct?: FrontdoorRoutingRule | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FrontdoorTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#create Frontdoor#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#delete Frontdoor#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#read Frontdoor#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#update Frontdoor#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function frontdoorTimeoutsToTerraform(struct?: FrontdoorTimeoutsOutputReference | FrontdoorTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class FrontdoorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FrontdoorTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FrontdoorTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor azurerm_frontdoor}.
 *
 * @stability stable
 */
export declare class Frontdoor extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor azurerm_frontdoor} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FrontdoorConfig);
    /**
     * @stability stable
     */
    backendPoolHealthProbes(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    backendPoolLoadBalancingSettings(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    backendPools(key: string): string | cdktf.IResolvable;
    private _backendPoolsSendReceiveTimeoutSeconds?;
    /**
     * @stability stable
     */
    get backendPoolsSendReceiveTimeoutSeconds(): number;
    /**
     * @stability stable
     */
    set backendPoolsSendReceiveTimeoutSeconds(value: number);
    /**
     * @stability stable
     */
    resetBackendPoolsSendReceiveTimeoutSeconds(): void;
    /**
     * @stability stable
     */
    get backendPoolsSendReceiveTimeoutSecondsInput(): number | undefined;
    /**
     * @stability stable
     */
    get cname(): string;
    private _enforceBackendPoolsCertificateNameCheck?;
    /**
     * @stability stable
     */
    get enforceBackendPoolsCertificateNameCheck(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforceBackendPoolsCertificateNameCheck(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enforceBackendPoolsCertificateNameCheckInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    explicitResourceOrder(index: string): FrontdoorExplicitResourceOrder;
    private _friendlyName?;
    /**
     * @stability stable
     */
    get friendlyName(): string;
    /**
     * @stability stable
     */
    set friendlyName(value: string);
    /**
     * @stability stable
     */
    resetFriendlyName(): void;
    /**
     * @stability stable
     */
    get friendlyNameInput(): string | undefined;
    /**
     * @stability stable
     */
    frontendEndpoints(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get headerFrontdoorId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _loadBalancerEnabled?;
    /**
     * @stability stable
     */
    get loadBalancerEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set loadBalancerEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLoadBalancerEnabled(): void;
    /**
     * @stability stable
     */
    get loadBalancerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    routingRules(key: string): string | cdktf.IResolvable;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _backendPool?;
    /**
     * @stability stable
     */
    get backendPool(): FrontdoorBackendPool[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set backendPool(value: FrontdoorBackendPool[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get backendPoolInput(): cdktf.IResolvable | FrontdoorBackendPool[] | undefined;
    private _backendPoolHealthProbe?;
    /**
     * @stability stable
     */
    get backendPoolHealthProbe(): FrontdoorBackendPoolHealthProbe[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set backendPoolHealthProbe(value: FrontdoorBackendPoolHealthProbe[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get backendPoolHealthProbeInput(): cdktf.IResolvable | FrontdoorBackendPoolHealthProbe[] | undefined;
    private _backendPoolLoadBalancing?;
    /**
     * @stability stable
     */
    get backendPoolLoadBalancing(): FrontdoorBackendPoolLoadBalancing[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set backendPoolLoadBalancing(value: FrontdoorBackendPoolLoadBalancing[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get backendPoolLoadBalancingInput(): cdktf.IResolvable | FrontdoorBackendPoolLoadBalancing[] | undefined;
    private _frontendEndpoint?;
    /**
     * @stability stable
     */
    get frontendEndpoint(): FrontdoorFrontendEndpoint[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set frontendEndpoint(value: FrontdoorFrontendEndpoint[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get frontendEndpointInput(): cdktf.IResolvable | FrontdoorFrontendEndpoint[] | undefined;
    private _routingRule?;
    /**
     * @stability stable
     */
    get routingRule(): FrontdoorRoutingRule[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set routingRule(value: FrontdoorRoutingRule[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get routingRuleInput(): cdktf.IResolvable | FrontdoorRoutingRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FrontdoorTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FrontdoorTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FrontdoorTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
