import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FunctionAppSlotConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#app_service_plan_id FunctionAppSlot#app_service_plan_id}.
     *
     * @stability stable
     */
    readonly appServicePlanId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#app_settings FunctionAppSlot#app_settings}.
     *
     * @stability stable
     */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#client_affinity_enabled FunctionAppSlot#client_affinity_enabled}.
     *
     * @stability stable
     */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#daily_memory_time_quota FunctionAppSlot#daily_memory_time_quota}.
     *
     * @stability stable
     */
    readonly dailyMemoryTimeQuota?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#enable_builtin_logging FunctionAppSlot#enable_builtin_logging}.
     *
     * @stability stable
     */
    readonly enableBuiltinLogging?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#enabled FunctionAppSlot#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#function_app_name FunctionAppSlot#function_app_name}.
     *
     * @stability stable
     */
    readonly functionAppName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#https_only FunctionAppSlot#https_only}.
     *
     * @stability stable
     */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#location FunctionAppSlot#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#name FunctionAppSlot#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#os_type FunctionAppSlot#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#resource_group_name FunctionAppSlot#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#storage_account_access_key FunctionAppSlot#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#storage_account_name FunctionAppSlot#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#tags FunctionAppSlot#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#version FunctionAppSlot#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * auth_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#auth_settings FunctionAppSlot#auth_settings}
     *
     * @stability stable
     */
    readonly authSettings?: FunctionAppSlotAuthSettings;
    /**
     * connection_string block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#connection_string FunctionAppSlot#connection_string}
     *
     * @stability stable
     */
    readonly connectionString?: FunctionAppSlotConnectionString[] | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#identity FunctionAppSlot#identity}
     *
     * @stability stable
     */
    readonly identity?: FunctionAppSlotIdentity;
    /**
     * site_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#site_config FunctionAppSlot#site_config}
     *
     * @stability stable
     */
    readonly siteConfig?: FunctionAppSlotSiteConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#timeouts FunctionAppSlot#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FunctionAppSlotTimeouts;
}
/**
 * @stability stable
 */
export declare class FunctionAppSlotSiteCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotAuthSettingsActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#allowed_audiences FunctionAppSlot#allowed_audiences}.
     *
     * @stability stable
     */
    readonly allowedAudiences?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#client_id FunctionAppSlot#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#client_secret FunctionAppSlot#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret?: string;
}
export declare function functionAppSlotAuthSettingsActiveDirectoryToTerraform(struct?: FunctionAppSlotAuthSettingsActiveDirectoryOutputReference | FunctionAppSlotAuthSettingsActiveDirectory): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotAuthSettingsActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    /**
     * @stability stable
     */
    get allowedAudiences(): string[];
    /**
     * @stability stable
     */
    set allowedAudiences(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedAudiences(): void;
    /**
     * @stability stable
     */
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    resetClientSecret(): void;
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotAuthSettingsFacebook {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#app_id FunctionAppSlot#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#app_secret FunctionAppSlot#app_secret}.
     *
     * @stability stable
     */
    readonly appSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#oauth_scopes FunctionAppSlot#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function functionAppSlotAuthSettingsFacebookToTerraform(struct?: FunctionAppSlotAuthSettingsFacebookOutputReference | FunctionAppSlotAuthSettingsFacebook): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotAuthSettingsFacebook | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotAuthSettingsFacebook | undefined);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    private _appSecret?;
    /**
     * @stability stable
     */
    get appSecret(): string;
    /**
     * @stability stable
     */
    set appSecret(value: string);
    /**
     * @stability stable
     */
    get appSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotAuthSettingsGoogle {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#client_id FunctionAppSlot#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#client_secret FunctionAppSlot#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#oauth_scopes FunctionAppSlot#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function functionAppSlotAuthSettingsGoogleToTerraform(struct?: FunctionAppSlotAuthSettingsGoogleOutputReference | FunctionAppSlotAuthSettingsGoogle): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotAuthSettingsGoogle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotAuthSettingsGoogle | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotAuthSettingsMicrosoft {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#client_id FunctionAppSlot#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#client_secret FunctionAppSlot#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#oauth_scopes FunctionAppSlot#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function functionAppSlotAuthSettingsMicrosoftToTerraform(struct?: FunctionAppSlotAuthSettingsMicrosoftOutputReference | FunctionAppSlotAuthSettingsMicrosoft): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotAuthSettingsMicrosoft | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotAuthSettingsMicrosoft | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotAuthSettingsTwitter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#consumer_key FunctionAppSlot#consumer_key}.
     *
     * @stability stable
     */
    readonly consumerKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#consumer_secret FunctionAppSlot#consumer_secret}.
     *
     * @stability stable
     */
    readonly consumerSecret: string;
}
export declare function functionAppSlotAuthSettingsTwitterToTerraform(struct?: FunctionAppSlotAuthSettingsTwitterOutputReference | FunctionAppSlotAuthSettingsTwitter): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotAuthSettingsTwitter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotAuthSettingsTwitter | undefined);
    private _consumerKey?;
    /**
     * @stability stable
     */
    get consumerKey(): string;
    /**
     * @stability stable
     */
    set consumerKey(value: string);
    /**
     * @stability stable
     */
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    /**
     * @stability stable
     */
    get consumerSecret(): string;
    /**
     * @stability stable
     */
    set consumerSecret(value: string);
    /**
     * @stability stable
     */
    get consumerSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotAuthSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#additional_login_params FunctionAppSlot#additional_login_params}.
     *
     * @stability stable
     */
    readonly additionalLoginParams?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#allowed_external_redirect_urls FunctionAppSlot#allowed_external_redirect_urls}.
     *
     * @stability stable
     */
    readonly allowedExternalRedirectUrls?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#default_provider FunctionAppSlot#default_provider}.
     *
     * @stability stable
     */
    readonly defaultProvider?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#enabled FunctionAppSlot#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#issuer FunctionAppSlot#issuer}.
     *
     * @stability stable
     */
    readonly issuer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#runtime_version FunctionAppSlot#runtime_version}.
     *
     * @stability stable
     */
    readonly runtimeVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#token_refresh_extension_hours FunctionAppSlot#token_refresh_extension_hours}.
     *
     * @stability stable
     */
    readonly tokenRefreshExtensionHours?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#token_store_enabled FunctionAppSlot#token_store_enabled}.
     *
     * @stability stable
     */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#unauthenticated_client_action FunctionAppSlot#unauthenticated_client_action}.
     *
     * @stability stable
     */
    readonly unauthenticatedClientAction?: string;
    /**
     * active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#active_directory FunctionAppSlot#active_directory}
     *
     * @stability stable
     */
    readonly activeDirectory?: FunctionAppSlotAuthSettingsActiveDirectory;
    /**
     * facebook block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#facebook FunctionAppSlot#facebook}
     *
     * @stability stable
     */
    readonly facebook?: FunctionAppSlotAuthSettingsFacebook;
    /**
     * google block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#google FunctionAppSlot#google}
     *
     * @stability stable
     */
    readonly google?: FunctionAppSlotAuthSettingsGoogle;
    /**
     * microsoft block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#microsoft FunctionAppSlot#microsoft}
     *
     * @stability stable
     */
    readonly microsoft?: FunctionAppSlotAuthSettingsMicrosoft;
    /**
     * twitter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#twitter FunctionAppSlot#twitter}
     *
     * @stability stable
     */
    readonly twitter?: FunctionAppSlotAuthSettingsTwitter;
}
export declare function functionAppSlotAuthSettingsToTerraform(struct?: FunctionAppSlotAuthSettingsOutputReference | FunctionAppSlotAuthSettings): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotAuthSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotAuthSettings | undefined);
    private _additionalLoginParams?;
    /**
     * @stability stable
     */
    get additionalLoginParams(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set additionalLoginParams(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAdditionalLoginParams(): void;
    /**
     * @stability stable
     */
    get additionalLoginParamsInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    /**
     * @stability stable
     */
    get allowedExternalRedirectUrls(): string[];
    /**
     * @stability stable
     */
    set allowedExternalRedirectUrls(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedExternalRedirectUrls(): void;
    /**
     * @stability stable
     */
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    /**
     * @stability stable
     */
    get defaultProvider(): string;
    /**
     * @stability stable
     */
    set defaultProvider(value: string);
    /**
     * @stability stable
     */
    resetDefaultProvider(): void;
    /**
     * @stability stable
     */
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    set issuer(value: string);
    /**
     * @stability stable
     */
    resetIssuer(): void;
    /**
     * @stability stable
     */
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    /**
     * @stability stable
     */
    get runtimeVersion(): string;
    /**
     * @stability stable
     */
    set runtimeVersion(value: string);
    /**
     * @stability stable
     */
    resetRuntimeVersion(): void;
    /**
     * @stability stable
     */
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    /**
     * @stability stable
     */
    get tokenRefreshExtensionHours(): number;
    /**
     * @stability stable
     */
    set tokenRefreshExtensionHours(value: number);
    /**
     * @stability stable
     */
    resetTokenRefreshExtensionHours(): void;
    /**
     * @stability stable
     */
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    /**
     * @stability stable
     */
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTokenStoreEnabled(): void;
    /**
     * @stability stable
     */
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    /**
     * @stability stable
     */
    get unauthenticatedClientAction(): string;
    /**
     * @stability stable
     */
    set unauthenticatedClientAction(value: string);
    /**
     * @stability stable
     */
    resetUnauthenticatedClientAction(): void;
    /**
     * @stability stable
     */
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    /**
     * @stability stable
     */
    get activeDirectory(): FunctionAppSlotAuthSettingsActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putActiveDirectory(value: FunctionAppSlotAuthSettingsActiveDirectory): void;
    /**
     * @stability stable
     */
    resetActiveDirectory(): void;
    /**
     * @stability stable
     */
    get activeDirectoryInput(): FunctionAppSlotAuthSettingsActiveDirectory | undefined;
    private _facebook;
    /**
     * @stability stable
     */
    get facebook(): FunctionAppSlotAuthSettingsFacebookOutputReference;
    /**
     * @stability stable
     */
    putFacebook(value: FunctionAppSlotAuthSettingsFacebook): void;
    /**
     * @stability stable
     */
    resetFacebook(): void;
    /**
     * @stability stable
     */
    get facebookInput(): FunctionAppSlotAuthSettingsFacebook | undefined;
    private _google;
    /**
     * @stability stable
     */
    get google(): FunctionAppSlotAuthSettingsGoogleOutputReference;
    /**
     * @stability stable
     */
    putGoogle(value: FunctionAppSlotAuthSettingsGoogle): void;
    /**
     * @stability stable
     */
    resetGoogle(): void;
    /**
     * @stability stable
     */
    get googleInput(): FunctionAppSlotAuthSettingsGoogle | undefined;
    private _microsoft;
    /**
     * @stability stable
     */
    get microsoft(): FunctionAppSlotAuthSettingsMicrosoftOutputReference;
    /**
     * @stability stable
     */
    putMicrosoft(value: FunctionAppSlotAuthSettingsMicrosoft): void;
    /**
     * @stability stable
     */
    resetMicrosoft(): void;
    /**
     * @stability stable
     */
    get microsoftInput(): FunctionAppSlotAuthSettingsMicrosoft | undefined;
    private _twitter;
    /**
     * @stability stable
     */
    get twitter(): FunctionAppSlotAuthSettingsTwitterOutputReference;
    /**
     * @stability stable
     */
    putTwitter(value: FunctionAppSlotAuthSettingsTwitter): void;
    /**
     * @stability stable
     */
    resetTwitter(): void;
    /**
     * @stability stable
     */
    get twitterInput(): FunctionAppSlotAuthSettingsTwitter | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotConnectionString {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#name FunctionAppSlot#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#type FunctionAppSlot#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#value FunctionAppSlot#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function functionAppSlotConnectionStringToTerraform(struct?: FunctionAppSlotConnectionString | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FunctionAppSlotIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#identity_ids FunctionAppSlot#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#type FunctionAppSlot#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function functionAppSlotIdentityToTerraform(struct?: FunctionAppSlotIdentityOutputReference | FunctionAppSlotIdentity): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotSiteConfigIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#x_azure_fdid FunctionAppSlot#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#x_fd_health_probe FunctionAppSlot#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#x_forwarded_for FunctionAppSlot#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#x_forwarded_host FunctionAppSlot#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function functionAppSlotSiteConfigIpRestrictionHeadersToTerraform(struct?: FunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FunctionAppSlotSiteConfigIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#action FunctionAppSlot#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#headers FunctionAppSlot#headers}.
     *
     * @stability stable
     */
    readonly headers?: FunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#ip_address FunctionAppSlot#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#name FunctionAppSlot#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#priority FunctionAppSlot#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#service_tag FunctionAppSlot#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#virtual_network_subnet_id FunctionAppSlot#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function functionAppSlotSiteConfigIpRestrictionToTerraform(struct?: FunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FunctionAppSlotSiteConfigScmIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#x_azure_fdid FunctionAppSlot#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#x_fd_health_probe FunctionAppSlot#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#x_forwarded_for FunctionAppSlot#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#x_forwarded_host FunctionAppSlot#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function functionAppSlotSiteConfigScmIpRestrictionHeadersToTerraform(struct?: FunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FunctionAppSlotSiteConfigScmIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#action FunctionAppSlot#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#headers FunctionAppSlot#headers}.
     *
     * @stability stable
     */
    readonly headers?: FunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#ip_address FunctionAppSlot#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#name FunctionAppSlot#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#priority FunctionAppSlot#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#service_tag FunctionAppSlot#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#virtual_network_subnet_id FunctionAppSlot#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function functionAppSlotSiteConfigScmIpRestrictionToTerraform(struct?: FunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface FunctionAppSlotSiteConfigCors {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#allowed_origins FunctionAppSlot#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#support_credentials FunctionAppSlot#support_credentials}.
     *
     * @stability stable
     */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function functionAppSlotSiteConfigCorsToTerraform(struct?: FunctionAppSlotSiteConfigCorsOutputReference | FunctionAppSlotSiteConfigCors): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotSiteConfigCors | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotSiteConfigCors | undefined);
    private _allowedOrigins?;
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    set allowedOrigins(value: string[]);
    /**
     * @stability stable
     */
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    /**
     * @stability stable
     */
    get supportCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set supportCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSupportCredentials(): void;
    /**
     * @stability stable
     */
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotSiteConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#always_on FunctionAppSlot#always_on}.
     *
     * @stability stable
     */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#app_scale_limit FunctionAppSlot#app_scale_limit}.
     *
     * @stability stable
     */
    readonly appScaleLimit?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#auto_swap_slot_name FunctionAppSlot#auto_swap_slot_name}.
     *
     * @stability stable
     */
    readonly autoSwapSlotName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#dotnet_framework_version FunctionAppSlot#dotnet_framework_version}.
     *
     * @stability stable
     */
    readonly dotnetFrameworkVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#elastic_instance_minimum FunctionAppSlot#elastic_instance_minimum}.
     *
     * @stability stable
     */
    readonly elasticInstanceMinimum?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#ftps_state FunctionAppSlot#ftps_state}.
     *
     * @stability stable
     */
    readonly ftpsState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#health_check_path FunctionAppSlot#health_check_path}.
     *
     * @stability stable
     */
    readonly healthCheckPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#http2_enabled FunctionAppSlot#http2_enabled}.
     *
     * @stability stable
     */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#ip_restriction FunctionAppSlot#ip_restriction}.
     *
     * @stability stable
     */
    readonly ipRestriction?: FunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#java_version FunctionAppSlot#java_version}.
     *
     * @stability stable
     */
    readonly javaVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#linux_fx_version FunctionAppSlot#linux_fx_version}.
     *
     * @stability stable
     */
    readonly linuxFxVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#min_tls_version FunctionAppSlot#min_tls_version}.
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#pre_warmed_instance_count FunctionAppSlot#pre_warmed_instance_count}.
     *
     * @stability stable
     */
    readonly preWarmedInstanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#runtime_scale_monitoring_enabled FunctionAppSlot#runtime_scale_monitoring_enabled}.
     *
     * @stability stable
     */
    readonly runtimeScaleMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#scm_ip_restriction FunctionAppSlot#scm_ip_restriction}.
     *
     * @stability stable
     */
    readonly scmIpRestriction?: FunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#scm_type FunctionAppSlot#scm_type}.
     *
     * @stability stable
     */
    readonly scmType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#scm_use_main_ip_restriction FunctionAppSlot#scm_use_main_ip_restriction}.
     *
     * @stability stable
     */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#use_32_bit_worker_process FunctionAppSlot#use_32_bit_worker_process}.
     *
     * @stability stable
     */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#vnet_route_all_enabled FunctionAppSlot#vnet_route_all_enabled}.
     *
     * @stability stable
     */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#websockets_enabled FunctionAppSlot#websockets_enabled}.
     *
     * @stability stable
     */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#cors FunctionAppSlot#cors}
     *
     * @stability stable
     */
    readonly cors?: FunctionAppSlotSiteConfigCors;
}
export declare function functionAppSlotSiteConfigToTerraform(struct?: FunctionAppSlotSiteConfigOutputReference | FunctionAppSlotSiteConfig): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotSiteConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotSiteConfig | undefined);
    private _alwaysOn?;
    /**
     * @stability stable
     */
    get alwaysOn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysOn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysOn(): void;
    /**
     * @stability stable
     */
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appScaleLimit?;
    /**
     * @stability stable
     */
    get appScaleLimit(): number;
    /**
     * @stability stable
     */
    set appScaleLimit(value: number);
    /**
     * @stability stable
     */
    resetAppScaleLimit(): void;
    /**
     * @stability stable
     */
    get appScaleLimitInput(): number | undefined;
    private _autoSwapSlotName?;
    /**
     * @stability stable
     */
    get autoSwapSlotName(): string;
    /**
     * @stability stable
     */
    set autoSwapSlotName(value: string);
    /**
     * @stability stable
     */
    resetAutoSwapSlotName(): void;
    /**
     * @stability stable
     */
    get autoSwapSlotNameInput(): string | undefined;
    private _dotnetFrameworkVersion?;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersion(): string;
    /**
     * @stability stable
     */
    set dotnetFrameworkVersion(value: string);
    /**
     * @stability stable
     */
    resetDotnetFrameworkVersion(): void;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersionInput(): string | undefined;
    private _elasticInstanceMinimum?;
    /**
     * @stability stable
     */
    get elasticInstanceMinimum(): number;
    /**
     * @stability stable
     */
    set elasticInstanceMinimum(value: number);
    /**
     * @stability stable
     */
    resetElasticInstanceMinimum(): void;
    /**
     * @stability stable
     */
    get elasticInstanceMinimumInput(): number | undefined;
    private _ftpsState?;
    /**
     * @stability stable
     */
    get ftpsState(): string;
    /**
     * @stability stable
     */
    set ftpsState(value: string);
    /**
     * @stability stable
     */
    resetFtpsState(): void;
    /**
     * @stability stable
     */
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    /**
     * @stability stable
     */
    get healthCheckPath(): string;
    /**
     * @stability stable
     */
    set healthCheckPath(value: string);
    /**
     * @stability stable
     */
    resetHealthCheckPath(): void;
    /**
     * @stability stable
     */
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    /**
     * @stability stable
     */
    get http2Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set http2Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttp2Enabled(): void;
    /**
     * @stability stable
     */
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction?;
    /**
     * @stability stable
     */
    get ipRestriction(): FunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ipRestriction(value: FunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIpRestriction(): void;
    /**
     * @stability stable
     */
    get ipRestrictionInput(): cdktf.IResolvable | FunctionAppSlotSiteConfigIpRestriction[] | undefined;
    private _javaVersion?;
    /**
     * @stability stable
     */
    get javaVersion(): string;
    /**
     * @stability stable
     */
    set javaVersion(value: string);
    /**
     * @stability stable
     */
    resetJavaVersion(): void;
    /**
     * @stability stable
     */
    get javaVersionInput(): string | undefined;
    private _linuxFxVersion?;
    /**
     * @stability stable
     */
    get linuxFxVersion(): string;
    /**
     * @stability stable
     */
    set linuxFxVersion(value: string);
    /**
     * @stability stable
     */
    resetLinuxFxVersion(): void;
    /**
     * @stability stable
     */
    get linuxFxVersionInput(): string | undefined;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _preWarmedInstanceCount?;
    /**
     * @stability stable
     */
    get preWarmedInstanceCount(): number;
    /**
     * @stability stable
     */
    set preWarmedInstanceCount(value: number);
    /**
     * @stability stable
     */
    resetPreWarmedInstanceCount(): void;
    /**
     * @stability stable
     */
    get preWarmedInstanceCountInput(): number | undefined;
    private _runtimeScaleMonitoringEnabled?;
    /**
     * @stability stable
     */
    get runtimeScaleMonitoringEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set runtimeScaleMonitoringEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRuntimeScaleMonitoringEnabled(): void;
    /**
     * @stability stable
     */
    get runtimeScaleMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scmIpRestriction?;
    /**
     * @stability stable
     */
    get scmIpRestriction(): FunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set scmIpRestriction(value: FunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetScmIpRestriction(): void;
    /**
     * @stability stable
     */
    get scmIpRestrictionInput(): cdktf.IResolvable | FunctionAppSlotSiteConfigScmIpRestriction[] | undefined;
    private _scmType?;
    /**
     * @stability stable
     */
    get scmType(): string;
    /**
     * @stability stable
     */
    set scmType(value: string);
    /**
     * @stability stable
     */
    resetScmType(): void;
    /**
     * @stability stable
     */
    get scmTypeInput(): string | undefined;
    private _scmUseMainIpRestriction?;
    /**
     * @stability stable
     */
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetScmUseMainIpRestriction(): void;
    /**
     * @stability stable
     */
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    /**
     * @stability stable
     */
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUse32BitWorkerProcess(): void;
    /**
     * @stability stable
     */
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVnetRouteAllEnabled(): void;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    /**
     * @stability stable
     */
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWebsocketsEnabled(): void;
    /**
     * @stability stable
     */
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cors;
    /**
     * @stability stable
     */
    get cors(): FunctionAppSlotSiteConfigCorsOutputReference;
    /**
     * @stability stable
     */
    putCors(value: FunctionAppSlotSiteConfigCors): void;
    /**
     * @stability stable
     */
    resetCors(): void;
    /**
     * @stability stable
     */
    get corsInput(): FunctionAppSlotSiteConfigCors | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSlotTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#create FunctionAppSlot#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#delete FunctionAppSlot#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#read FunctionAppSlot#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot#update FunctionAppSlot#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function functionAppSlotTimeoutsToTerraform(struct?: FunctionAppSlotTimeoutsOutputReference | FunctionAppSlotTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class FunctionAppSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSlotTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSlotTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot azurerm_function_app_slot}.
 *
 * @stability stable
 */
export declare class FunctionAppSlot extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/function_app_slot azurerm_function_app_slot} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FunctionAppSlotConfig);
    private _appServicePlanId?;
    /**
     * @stability stable
     */
    get appServicePlanId(): string;
    /**
     * @stability stable
     */
    set appServicePlanId(value: string);
    /**
     * @stability stable
     */
    get appServicePlanIdInput(): string | undefined;
    private _appSettings?;
    /**
     * @stability stable
     */
    get appSettings(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set appSettings(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAppSettings(): void;
    /**
     * @stability stable
     */
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _clientAffinityEnabled?;
    /**
     * @stability stable
     */
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientAffinityEnabled(): void;
    /**
     * @stability stable
     */
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dailyMemoryTimeQuota?;
    /**
     * @stability stable
     */
    get dailyMemoryTimeQuota(): number;
    /**
     * @stability stable
     */
    set dailyMemoryTimeQuota(value: number);
    /**
     * @stability stable
     */
    resetDailyMemoryTimeQuota(): void;
    /**
     * @stability stable
     */
    get dailyMemoryTimeQuotaInput(): number | undefined;
    /**
     * @stability stable
     */
    get defaultHostname(): string;
    private _enableBuiltinLogging?;
    /**
     * @stability stable
     */
    get enableBuiltinLogging(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBuiltinLogging(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBuiltinLogging(): void;
    /**
     * @stability stable
     */
    get enableBuiltinLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _functionAppName?;
    /**
     * @stability stable
     */
    get functionAppName(): string;
    /**
     * @stability stable
     */
    set functionAppName(value: string);
    /**
     * @stability stable
     */
    get functionAppNameInput(): string | undefined;
    private _httpsOnly?;
    /**
     * @stability stable
     */
    get httpsOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpsOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpsOnly(): void;
    /**
     * @stability stable
     */
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    set osType(value: string);
    /**
     * @stability stable
     */
    resetOsType(): void;
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundIpAddresses(): string;
    /**
     * @stability stable
     */
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    siteCredential(index: string): FunctionAppSlotSiteCredential;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _authSettings;
    /**
     * @stability stable
     */
    get authSettings(): FunctionAppSlotAuthSettingsOutputReference;
    /**
     * @stability stable
     */
    putAuthSettings(value: FunctionAppSlotAuthSettings): void;
    /**
     * @stability stable
     */
    resetAuthSettings(): void;
    /**
     * @stability stable
     */
    get authSettingsInput(): FunctionAppSlotAuthSettings | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): FunctionAppSlotConnectionString[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set connectionString(value: FunctionAppSlotConnectionString[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetConnectionString(): void;
    /**
     * @stability stable
     */
    get connectionStringInput(): cdktf.IResolvable | FunctionAppSlotConnectionString[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): FunctionAppSlotIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: FunctionAppSlotIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): FunctionAppSlotIdentity | undefined;
    private _siteConfig;
    /**
     * @stability stable
     */
    get siteConfig(): FunctionAppSlotSiteConfigOutputReference;
    /**
     * @stability stable
     */
    putSiteConfig(value: FunctionAppSlotSiteConfig): void;
    /**
     * @stability stable
     */
    resetSiteConfig(): void;
    /**
     * @stability stable
     */
    get siteConfigInput(): FunctionAppSlotSiteConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FunctionAppSlotTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FunctionAppSlotTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FunctionAppSlotTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
