import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HpcCacheAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#hpc_cache_id HpcCacheAccessPolicy#hpc_cache_id}.
     *
     * @stability stable
     */
    readonly hpcCacheId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#name HpcCacheAccessPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * access_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#access_rule HpcCacheAccessPolicy#access_rule}
     *
     * @stability stable
     */
    readonly accessRule: HpcCacheAccessPolicyAccessRule[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#timeouts HpcCacheAccessPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HpcCacheAccessPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface HpcCacheAccessPolicyAccessRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#access HpcCacheAccessPolicy#access}.
     *
     * @stability stable
     */
    readonly access: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#anonymous_gid HpcCacheAccessPolicy#anonymous_gid}.
     *
     * @stability stable
     */
    readonly anonymousGid?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#anonymous_uid HpcCacheAccessPolicy#anonymous_uid}.
     *
     * @stability stable
     */
    readonly anonymousUid?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#filter HpcCacheAccessPolicy#filter}.
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#root_squash_enabled HpcCacheAccessPolicy#root_squash_enabled}.
     *
     * @stability stable
     */
    readonly rootSquashEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#scope HpcCacheAccessPolicy#scope}.
     *
     * @stability stable
     */
    readonly scope: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#submount_access_enabled HpcCacheAccessPolicy#submount_access_enabled}.
     *
     * @stability stable
     */
    readonly submountAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#suid_enabled HpcCacheAccessPolicy#suid_enabled}.
     *
     * @stability stable
     */
    readonly suidEnabled?: boolean | cdktf.IResolvable;
}
export declare function hpcCacheAccessPolicyAccessRuleToTerraform(struct?: HpcCacheAccessPolicyAccessRule | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface HpcCacheAccessPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#create HpcCacheAccessPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#delete HpcCacheAccessPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#read HpcCacheAccessPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy#update HpcCacheAccessPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hpcCacheAccessPolicyTimeoutsToTerraform(struct?: HpcCacheAccessPolicyTimeoutsOutputReference | HpcCacheAccessPolicyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class HpcCacheAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheAccessPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy azurerm_hpc_cache_access_policy}.
 *
 * @stability stable
 */
export declare class HpcCacheAccessPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_access_policy azurerm_hpc_cache_access_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HpcCacheAccessPolicyConfig);
    private _hpcCacheId?;
    /**
     * @stability stable
     */
    get hpcCacheId(): string;
    /**
     * @stability stable
     */
    set hpcCacheId(value: string);
    /**
     * @stability stable
     */
    get hpcCacheIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _accessRule?;
    /**
     * @stability stable
     */
    get accessRule(): HpcCacheAccessPolicyAccessRule[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessRule(value: HpcCacheAccessPolicyAccessRule[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get accessRuleInput(): cdktf.IResolvable | HpcCacheAccessPolicyAccessRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HpcCacheAccessPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HpcCacheAccessPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HpcCacheAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
