import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KustoIothubDataConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#cluster_name KustoIothubDataConnection#cluster_name}.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#consumer_group KustoIothubDataConnection#consumer_group}.
     *
     * @stability stable
     */
    readonly consumerGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#data_format KustoIothubDataConnection#data_format}.
     *
     * @stability stable
     */
    readonly dataFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#database_name KustoIothubDataConnection#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#event_system_properties KustoIothubDataConnection#event_system_properties}.
     *
     * @stability stable
     */
    readonly eventSystemProperties?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#iothub_id KustoIothubDataConnection#iothub_id}.
     *
     * @stability stable
     */
    readonly iothubId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#location KustoIothubDataConnection#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#mapping_rule_name KustoIothubDataConnection#mapping_rule_name}.
     *
     * @stability stable
     */
    readonly mappingRuleName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#name KustoIothubDataConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#resource_group_name KustoIothubDataConnection#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#shared_access_policy_name KustoIothubDataConnection#shared_access_policy_name}.
     *
     * @stability stable
     */
    readonly sharedAccessPolicyName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#table_name KustoIothubDataConnection#table_name}.
     *
     * @stability stable
     */
    readonly tableName?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#timeouts KustoIothubDataConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KustoIothubDataConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface KustoIothubDataConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#create KustoIothubDataConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#delete KustoIothubDataConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection#read KustoIothubDataConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function kustoIothubDataConnectionTimeoutsToTerraform(struct?: KustoIothubDataConnectionTimeoutsOutputReference | KustoIothubDataConnectionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class KustoIothubDataConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoIothubDataConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoIothubDataConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection azurerm_kusto_iothub_data_connection}.
 *
 * @stability stable
 */
export declare class KustoIothubDataConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_iothub_data_connection azurerm_kusto_iothub_data_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KustoIothubDataConnectionConfig);
    private _clusterName?;
    /**
     * @stability stable
     */
    get clusterName(): string;
    /**
     * @stability stable
     */
    set clusterName(value: string);
    /**
     * @stability stable
     */
    get clusterNameInput(): string | undefined;
    private _consumerGroup?;
    /**
     * @stability stable
     */
    get consumerGroup(): string;
    /**
     * @stability stable
     */
    set consumerGroup(value: string);
    /**
     * @stability stable
     */
    get consumerGroupInput(): string | undefined;
    private _dataFormat?;
    /**
     * @stability stable
     */
    get dataFormat(): string;
    /**
     * @stability stable
     */
    set dataFormat(value: string);
    /**
     * @stability stable
     */
    resetDataFormat(): void;
    /**
     * @stability stable
     */
    get dataFormatInput(): string | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _eventSystemProperties?;
    /**
     * @stability stable
     */
    get eventSystemProperties(): string[];
    /**
     * @stability stable
     */
    set eventSystemProperties(value: string[]);
    /**
     * @stability stable
     */
    resetEventSystemProperties(): void;
    /**
     * @stability stable
     */
    get eventSystemPropertiesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _iothubId?;
    /**
     * @stability stable
     */
    get iothubId(): string;
    /**
     * @stability stable
     */
    set iothubId(value: string);
    /**
     * @stability stable
     */
    get iothubIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _mappingRuleName?;
    /**
     * @stability stable
     */
    get mappingRuleName(): string;
    /**
     * @stability stable
     */
    set mappingRuleName(value: string);
    /**
     * @stability stable
     */
    resetMappingRuleName(): void;
    /**
     * @stability stable
     */
    get mappingRuleNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sharedAccessPolicyName?;
    /**
     * @stability stable
     */
    get sharedAccessPolicyName(): string;
    /**
     * @stability stable
     */
    set sharedAccessPolicyName(value: string);
    /**
     * @stability stable
     */
    get sharedAccessPolicyNameInput(): string | undefined;
    private _tableName?;
    /**
     * @stability stable
     */
    get tableName(): string;
    /**
     * @stability stable
     */
    set tableName(value: string);
    /**
     * @stability stable
     */
    resetTableName(): void;
    /**
     * @stability stable
     */
    get tableNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KustoIothubDataConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KustoIothubDataConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KustoIothubDataConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
