import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#backend_address_pool_id LbRule#backend_address_pool_id}.
     *
     * @stability stable
     */
    readonly backendAddressPoolId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#backend_address_pool_ids LbRule#backend_address_pool_ids}.
     *
     * @stability stable
     */
    readonly backendAddressPoolIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#backend_port LbRule#backend_port}.
     *
     * @stability stable
     */
    readonly backendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#disable_outbound_snat LbRule#disable_outbound_snat}.
     *
     * @stability stable
     */
    readonly disableOutboundSnat?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#enable_floating_ip LbRule#enable_floating_ip}.
     *
     * @stability stable
     */
    readonly enableFloatingIp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#enable_tcp_reset LbRule#enable_tcp_reset}.
     *
     * @stability stable
     */
    readonly enableTcpReset?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#frontend_ip_configuration_name LbRule#frontend_ip_configuration_name}.
     *
     * @stability stable
     */
    readonly frontendIpConfigurationName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#frontend_port LbRule#frontend_port}.
     *
     * @stability stable
     */
    readonly frontendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#idle_timeout_in_minutes LbRule#idle_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly idleTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#load_distribution LbRule#load_distribution}.
     *
     * @stability stable
     */
    readonly loadDistribution?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#loadbalancer_id LbRule#loadbalancer_id}.
     *
     * @stability stable
     */
    readonly loadbalancerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#name LbRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#probe_id LbRule#probe_id}.
     *
     * @stability stable
     */
    readonly probeId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#protocol LbRule#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#resource_group_name LbRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#timeouts LbRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LbRuleTimeouts;
}
/**
 * @stability stable
 */
export interface LbRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#create LbRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#delete LbRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#read LbRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#update LbRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function lbRuleTimeoutsToTerraform(struct?: LbRuleTimeoutsOutputReference | LbRuleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class LbRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LbRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LbRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule azurerm_lb_rule}.
 *
 * @stability stable
 */
export declare class LbRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule azurerm_lb_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbRuleConfig);
    private _backendAddressPoolId?;
    /**
     * @stability stable
     */
    get backendAddressPoolId(): string;
    /**
     * @stability stable
     */
    set backendAddressPoolId(value: string);
    /**
     * @stability stable
     */
    resetBackendAddressPoolId(): void;
    /**
     * @stability stable
     */
    get backendAddressPoolIdInput(): string | undefined;
    private _backendAddressPoolIds?;
    /**
     * @stability stable
     */
    get backendAddressPoolIds(): string[];
    /**
     * @stability stable
     */
    set backendAddressPoolIds(value: string[]);
    /**
     * @stability stable
     */
    resetBackendAddressPoolIds(): void;
    /**
     * @stability stable
     */
    get backendAddressPoolIdsInput(): string[] | undefined;
    private _backendPort?;
    /**
     * @stability stable
     */
    get backendPort(): number;
    /**
     * @stability stable
     */
    set backendPort(value: number);
    /**
     * @stability stable
     */
    get backendPortInput(): number | undefined;
    private _disableOutboundSnat?;
    /**
     * @stability stable
     */
    get disableOutboundSnat(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableOutboundSnat(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableOutboundSnat(): void;
    /**
     * @stability stable
     */
    get disableOutboundSnatInput(): boolean | cdktf.IResolvable | undefined;
    private _enableFloatingIp?;
    /**
     * @stability stable
     */
    get enableFloatingIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableFloatingIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableFloatingIp(): void;
    /**
     * @stability stable
     */
    get enableFloatingIpInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTcpReset?;
    /**
     * @stability stable
     */
    get enableTcpReset(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableTcpReset(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableTcpReset(): void;
    /**
     * @stability stable
     */
    get enableTcpResetInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get frontendIpConfigurationId(): string;
    private _frontendIpConfigurationName?;
    /**
     * @stability stable
     */
    get frontendIpConfigurationName(): string;
    /**
     * @stability stable
     */
    set frontendIpConfigurationName(value: string);
    /**
     * @stability stable
     */
    get frontendIpConfigurationNameInput(): string | undefined;
    private _frontendPort?;
    /**
     * @stability stable
     */
    get frontendPort(): number;
    /**
     * @stability stable
     */
    set frontendPort(value: number);
    /**
     * @stability stable
     */
    get frontendPortInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _idleTimeoutInMinutes?;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutes(): number;
    /**
     * @stability stable
     */
    set idleTimeoutInMinutes(value: number);
    /**
     * @stability stable
     */
    resetIdleTimeoutInMinutes(): void;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadDistribution?;
    /**
     * @stability stable
     */
    get loadDistribution(): string;
    /**
     * @stability stable
     */
    set loadDistribution(value: string);
    /**
     * @stability stable
     */
    resetLoadDistribution(): void;
    /**
     * @stability stable
     */
    get loadDistributionInput(): string | undefined;
    private _loadbalancerId?;
    /**
     * @stability stable
     */
    get loadbalancerId(): string;
    /**
     * @stability stable
     */
    set loadbalancerId(value: string);
    /**
     * @stability stable
     */
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _probeId?;
    /**
     * @stability stable
     */
    get probeId(): string;
    /**
     * @stability stable
     */
    set probeId(value: string);
    /**
     * @stability stable
     */
    resetProbeId(): void;
    /**
     * @stability stable
     */
    get probeIdInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LbRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LbRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LbRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
