import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#admin_password LinuxVirtualMachineScaleSet#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#admin_username LinuxVirtualMachineScaleSet#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#computer_name_prefix LinuxVirtualMachineScaleSet#computer_name_prefix}.
     *
     * @stability stable
     */
    readonly computerNamePrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#custom_data LinuxVirtualMachineScaleSet#custom_data}.
     *
     * @stability stable
     */
    readonly customData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disable_password_authentication LinuxVirtualMachineScaleSet#disable_password_authentication}.
     *
     * @stability stable
     */
    readonly disablePasswordAuthentication?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#do_not_run_extensions_on_overprovisioned_machines LinuxVirtualMachineScaleSet#do_not_run_extensions_on_overprovisioned_machines}.
     *
     * @stability stable
     */
    readonly doNotRunExtensionsOnOverprovisionedMachines?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#encryption_at_host_enabled LinuxVirtualMachineScaleSet#encryption_at_host_enabled}.
     *
     * @stability stable
     */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#eviction_policy LinuxVirtualMachineScaleSet#eviction_policy}.
     *
     * @stability stable
     */
    readonly evictionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#extensions_time_budget LinuxVirtualMachineScaleSet#extensions_time_budget}.
     *
     * @stability stable
     */
    readonly extensionsTimeBudget?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#health_probe_id LinuxVirtualMachineScaleSet#health_probe_id}.
     *
     * @stability stable
     */
    readonly healthProbeId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#instances LinuxVirtualMachineScaleSet#instances}.
     *
     * @stability stable
     */
    readonly instances: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#location LinuxVirtualMachineScaleSet#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#max_bid_price LinuxVirtualMachineScaleSet#max_bid_price}.
     *
     * @stability stable
     */
    readonly maxBidPrice?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#overprovision LinuxVirtualMachineScaleSet#overprovision}.
     *
     * @stability stable
     */
    readonly overprovision?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#platform_fault_domain_count LinuxVirtualMachineScaleSet#platform_fault_domain_count}.
     *
     * @stability stable
     */
    readonly platformFaultDomainCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#priority LinuxVirtualMachineScaleSet#priority}.
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#provision_vm_agent LinuxVirtualMachineScaleSet#provision_vm_agent}.
     *
     * @stability stable
     */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#proximity_placement_group_id LinuxVirtualMachineScaleSet#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#resource_group_name LinuxVirtualMachineScaleSet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#scale_in_policy LinuxVirtualMachineScaleSet#scale_in_policy}.
     *
     * @stability stable
     */
    readonly scaleInPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#secure_boot_enabled LinuxVirtualMachineScaleSet#secure_boot_enabled}.
     *
     * @stability stable
     */
    readonly secureBootEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#single_placement_group LinuxVirtualMachineScaleSet#single_placement_group}.
     *
     * @stability stable
     */
    readonly singlePlacementGroup?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#sku LinuxVirtualMachineScaleSet#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#source_image_id LinuxVirtualMachineScaleSet#source_image_id}.
     *
     * @stability stable
     */
    readonly sourceImageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#tags LinuxVirtualMachineScaleSet#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#upgrade_mode LinuxVirtualMachineScaleSet#upgrade_mode}.
     *
     * @stability stable
     */
    readonly upgradeMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#user_data LinuxVirtualMachineScaleSet#user_data}.
     *
     * @stability stable
     */
    readonly userData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#vtpm_enabled LinuxVirtualMachineScaleSet#vtpm_enabled}.
     *
     * @stability stable
     */
    readonly vtpmEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#zone_balance LinuxVirtualMachineScaleSet#zone_balance}.
     *
     * @stability stable
     */
    readonly zoneBalance?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#zones LinuxVirtualMachineScaleSet#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * additional_capabilities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#additional_capabilities LinuxVirtualMachineScaleSet#additional_capabilities}
     *
     * @stability stable
     */
    readonly additionalCapabilities?: LinuxVirtualMachineScaleSetAdditionalCapabilities;
    /**
     * admin_ssh_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#admin_ssh_key LinuxVirtualMachineScaleSet#admin_ssh_key}
     *
     * @stability stable
     */
    readonly adminSshKey?: LinuxVirtualMachineScaleSetAdminSshKey[] | cdktf.IResolvable;
    /**
     * automatic_instance_repair block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#automatic_instance_repair LinuxVirtualMachineScaleSet#automatic_instance_repair}
     *
     * @stability stable
     */
    readonly automaticInstanceRepair?: LinuxVirtualMachineScaleSetAutomaticInstanceRepair;
    /**
     * automatic_os_upgrade_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#automatic_os_upgrade_policy LinuxVirtualMachineScaleSet#automatic_os_upgrade_policy}
     *
     * @stability stable
     */
    readonly automaticOsUpgradePolicy?: LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy;
    /**
     * boot_diagnostics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#boot_diagnostics LinuxVirtualMachineScaleSet#boot_diagnostics}
     *
     * @stability stable
     */
    readonly bootDiagnostics?: LinuxVirtualMachineScaleSetBootDiagnostics;
    /**
     * data_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#data_disk LinuxVirtualMachineScaleSet#data_disk}
     *
     * @stability stable
     */
    readonly dataDisk?: LinuxVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable;
    /**
     * extension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#extension LinuxVirtualMachineScaleSet#extension}
     *
     * @stability stable
     */
    readonly extension?: LinuxVirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#identity LinuxVirtualMachineScaleSet#identity}
     *
     * @stability stable
     */
    readonly identity?: LinuxVirtualMachineScaleSetIdentity;
    /**
     * network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#network_interface LinuxVirtualMachineScaleSet#network_interface}
     *
     * @stability stable
     */
    readonly networkInterface: LinuxVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable;
    /**
     * os_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#os_disk LinuxVirtualMachineScaleSet#os_disk}
     *
     * @stability stable
     */
    readonly osDisk: LinuxVirtualMachineScaleSetOsDisk;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#plan LinuxVirtualMachineScaleSet#plan}
     *
     * @stability stable
     */
    readonly plan?: LinuxVirtualMachineScaleSetPlan;
    /**
     * rolling_upgrade_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#rolling_upgrade_policy LinuxVirtualMachineScaleSet#rolling_upgrade_policy}
     *
     * @stability stable
     */
    readonly rollingUpgradePolicy?: LinuxVirtualMachineScaleSetRollingUpgradePolicy;
    /**
     * secret block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#secret LinuxVirtualMachineScaleSet#secret}
     *
     * @stability stable
     */
    readonly secret?: LinuxVirtualMachineScaleSetSecret[] | cdktf.IResolvable;
    /**
     * source_image_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#source_image_reference LinuxVirtualMachineScaleSet#source_image_reference}
     *
     * @stability stable
     */
    readonly sourceImageReference?: LinuxVirtualMachineScaleSetSourceImageReference;
    /**
     * terminate_notification block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#terminate_notification LinuxVirtualMachineScaleSet#terminate_notification}
     *
     * @stability stable
     */
    readonly terminateNotification?: LinuxVirtualMachineScaleSetTerminateNotification;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#timeouts LinuxVirtualMachineScaleSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LinuxVirtualMachineScaleSetTimeouts;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetAdditionalCapabilities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#ultra_ssd_enabled LinuxVirtualMachineScaleSet#ultra_ssd_enabled}.
     *
     * @stability stable
     */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetAdditionalCapabilitiesToTerraform(struct?: LinuxVirtualMachineScaleSetAdditionalCapabilitiesOutputReference | LinuxVirtualMachineScaleSetAdditionalCapabilities): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetAdditionalCapabilities | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetAdditionalCapabilities | undefined);
    private _ultraSsdEnabled?;
    /**
     * @stability stable
     */
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUltraSsdEnabled(): void;
    /**
     * @stability stable
     */
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetAdminSshKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#public_key LinuxVirtualMachineScaleSet#public_key}.
     *
     * @stability stable
     */
    readonly publicKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#username LinuxVirtualMachineScaleSet#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function linuxVirtualMachineScaleSetAdminSshKeyToTerraform(struct?: LinuxVirtualMachineScaleSetAdminSshKey | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetAutomaticInstanceRepair {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enabled LinuxVirtualMachineScaleSet#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#grace_period LinuxVirtualMachineScaleSet#grace_period}.
     *
     * @stability stable
     */
    readonly gracePeriod?: string;
}
export declare function linuxVirtualMachineScaleSetAutomaticInstanceRepairToTerraform(struct?: LinuxVirtualMachineScaleSetAutomaticInstanceRepairOutputReference | LinuxVirtualMachineScaleSetAutomaticInstanceRepair): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetAutomaticInstanceRepairOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetAutomaticInstanceRepair | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    /**
     * @stability stable
     */
    get gracePeriod(): string;
    /**
     * @stability stable
     */
    set gracePeriod(value: string);
    /**
     * @stability stable
     */
    resetGracePeriod(): void;
    /**
     * @stability stable
     */
    get gracePeriodInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disable_automatic_rollback LinuxVirtualMachineScaleSet#disable_automatic_rollback}.
     *
     * @stability stable
     */
    readonly disableAutomaticRollback: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enable_automatic_os_upgrade LinuxVirtualMachineScaleSet#enable_automatic_os_upgrade}.
     *
     * @stability stable
     */
    readonly enableAutomaticOsUpgrade: boolean | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetAutomaticOsUpgradePolicyToTerraform(struct?: LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference | LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined);
    private _disableAutomaticRollback?;
    /**
     * @stability stable
     */
    get disableAutomaticRollback(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableAutomaticRollback(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get disableAutomaticRollbackInput(): boolean | cdktf.IResolvable | undefined;
    private _enableAutomaticOsUpgrade?;
    /**
     * @stability stable
     */
    get enableAutomaticOsUpgrade(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutomaticOsUpgrade(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableAutomaticOsUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetBootDiagnostics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#storage_account_uri LinuxVirtualMachineScaleSet#storage_account_uri}.
     *
     * @stability stable
     */
    readonly storageAccountUri?: string;
}
export declare function linuxVirtualMachineScaleSetBootDiagnosticsToTerraform(struct?: LinuxVirtualMachineScaleSetBootDiagnosticsOutputReference | LinuxVirtualMachineScaleSetBootDiagnostics): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetBootDiagnostics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetBootDiagnostics | undefined);
    private _storageAccountUri?;
    /**
     * @stability stable
     */
    get storageAccountUri(): string;
    /**
     * @stability stable
     */
    set storageAccountUri(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountUri(): void;
    /**
     * @stability stable
     */
    get storageAccountUriInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetDataDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#caching LinuxVirtualMachineScaleSet#caching}.
     *
     * @stability stable
     */
    readonly caching: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#create_option LinuxVirtualMachineScaleSet#create_option}.
     *
     * @stability stable
     */
    readonly createOption?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_encryption_set_id LinuxVirtualMachineScaleSet#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_iops_read_write LinuxVirtualMachineScaleSet#disk_iops_read_write}.
     *
     * @stability stable
     */
    readonly diskIopsReadWrite?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_mbps_read_write LinuxVirtualMachineScaleSet#disk_mbps_read_write}.
     *
     * @stability stable
     */
    readonly diskMbpsReadWrite?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_size_gb LinuxVirtualMachineScaleSet#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#lun LinuxVirtualMachineScaleSet#lun}.
     *
     * @stability stable
     */
    readonly lun: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#storage_account_type LinuxVirtualMachineScaleSet#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#write_accelerator_enabled LinuxVirtualMachineScaleSet#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetDataDiskToTerraform(struct?: LinuxVirtualMachineScaleSetDataDisk | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetExtension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#auto_upgrade_minor_version LinuxVirtualMachineScaleSet#auto_upgrade_minor_version}.
     *
     * @stability stable
     */
    readonly autoUpgradeMinorVersion?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#automatic_upgrade_enabled LinuxVirtualMachineScaleSet#automatic_upgrade_enabled}.
     *
     * @stability stable
     */
    readonly automaticUpgradeEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#force_update_tag LinuxVirtualMachineScaleSet#force_update_tag}.
     *
     * @stability stable
     */
    readonly forceUpdateTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#protected_settings LinuxVirtualMachineScaleSet#protected_settings}.
     *
     * @stability stable
     */
    readonly protectedSettings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#provision_after_extensions LinuxVirtualMachineScaleSet#provision_after_extensions}.
     *
     * @stability stable
     */
    readonly provisionAfterExtensions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#publisher LinuxVirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#settings LinuxVirtualMachineScaleSet#settings}.
     *
     * @stability stable
     */
    readonly settings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#type LinuxVirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#type_handler_version LinuxVirtualMachineScaleSet#type_handler_version}.
     *
     * @stability stable
     */
    readonly typeHandlerVersion: string;
}
export declare function linuxVirtualMachineScaleSetExtensionToTerraform(struct?: LinuxVirtualMachineScaleSetExtension | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#identity_ids LinuxVirtualMachineScaleSet#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#type LinuxVirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function linuxVirtualMachineScaleSetIdentityToTerraform(struct?: LinuxVirtualMachineScaleSetIdentityOutputReference | LinuxVirtualMachineScaleSetIdentity): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get principalId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#tag LinuxVirtualMachineScaleSet#tag}.
     *
     * @stability stable
     */
    readonly tag: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#type LinuxVirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function linuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagToTerraform(struct?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#domain_name_label LinuxVirtualMachineScaleSet#domain_name_label}.
     *
     * @stability stable
     */
    readonly domainNameLabel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#idle_timeout_in_minutes LinuxVirtualMachineScaleSet#idle_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly idleTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#public_ip_prefix_id LinuxVirtualMachineScaleSet#public_ip_prefix_id}.
     *
     * @stability stable
     */
    readonly publicIpPrefixId?: string;
    /**
     * ip_tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#ip_tag LinuxVirtualMachineScaleSet#ip_tag}
     *
     * @stability stable
     */
    readonly ipTag?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[] | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressToTerraform(struct?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#application_gateway_backend_address_pool_ids LinuxVirtualMachineScaleSet#application_gateway_backend_address_pool_ids}.
     *
     * @stability stable
     */
    readonly applicationGatewayBackendAddressPoolIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#application_security_group_ids LinuxVirtualMachineScaleSet#application_security_group_ids}.
     *
     * @stability stable
     */
    readonly applicationSecurityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#load_balancer_backend_address_pool_ids LinuxVirtualMachineScaleSet#load_balancer_backend_address_pool_ids}.
     *
     * @stability stable
     */
    readonly loadBalancerBackendAddressPoolIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#load_balancer_inbound_nat_rules_ids LinuxVirtualMachineScaleSet#load_balancer_inbound_nat_rules_ids}.
     *
     * @stability stable
     */
    readonly loadBalancerInboundNatRulesIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#primary LinuxVirtualMachineScaleSet#primary}.
     *
     * @stability stable
     */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#subnet_id LinuxVirtualMachineScaleSet#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#version LinuxVirtualMachineScaleSet#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * public_ip_address block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#public_ip_address LinuxVirtualMachineScaleSet#public_ip_address}
     *
     * @stability stable
     */
    readonly publicIpAddress?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[] | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationToTerraform(struct?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetNetworkInterface {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#dns_servers LinuxVirtualMachineScaleSet#dns_servers}.
     *
     * @stability stable
     */
    readonly dnsServers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enable_accelerated_networking LinuxVirtualMachineScaleSet#enable_accelerated_networking}.
     *
     * @stability stable
     */
    readonly enableAcceleratedNetworking?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enable_ip_forwarding LinuxVirtualMachineScaleSet#enable_ip_forwarding}.
     *
     * @stability stable
     */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#network_security_group_id LinuxVirtualMachineScaleSet#network_security_group_id}.
     *
     * @stability stable
     */
    readonly networkSecurityGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#primary LinuxVirtualMachineScaleSet#primary}.
     *
     * @stability stable
     */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#ip_configuration LinuxVirtualMachineScaleSet#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetNetworkInterfaceToTerraform(struct?: LinuxVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#option LinuxVirtualMachineScaleSet#option}.
     *
     * @stability stable
     */
    readonly option: string;
}
export declare function linuxVirtualMachineScaleSetOsDiskDiffDiskSettingsToTerraform(struct?: LinuxVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference | LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined);
    private _option?;
    /**
     * @stability stable
     */
    get option(): string;
    /**
     * @stability stable
     */
    set option(value: string);
    /**
     * @stability stable
     */
    get optionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetOsDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#caching LinuxVirtualMachineScaleSet#caching}.
     *
     * @stability stable
     */
    readonly caching: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_encryption_set_id LinuxVirtualMachineScaleSet#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_size_gb LinuxVirtualMachineScaleSet#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#storage_account_type LinuxVirtualMachineScaleSet#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#write_accelerator_enabled LinuxVirtualMachineScaleSet#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
     * diff_disk_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#diff_disk_settings LinuxVirtualMachineScaleSet#diff_disk_settings}
     *
     * @stability stable
     */
    readonly diffDiskSettings?: LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings;
}
export declare function linuxVirtualMachineScaleSetOsDiskToTerraform(struct?: LinuxVirtualMachineScaleSetOsDiskOutputReference | LinuxVirtualMachineScaleSetOsDisk): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetOsDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetOsDisk | undefined);
    private _caching?;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    set caching(value: string);
    /**
     * @stability stable
     */
    get cachingInput(): string | undefined;
    private _diskEncryptionSetId?;
    /**
     * @stability stable
     */
    get diskEncryptionSetId(): string;
    /**
     * @stability stable
     */
    set diskEncryptionSetId(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryptionSetId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _storageAccountType?;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
    /**
     * @stability stable
     */
    set storageAccountType(value: string);
    /**
     * @stability stable
     */
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWriteAcceleratorEnabled(): void;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diffDiskSettings;
    /**
     * @stability stable
     */
    get diffDiskSettings(): LinuxVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference;
    /**
     * @stability stable
     */
    putDiffDiskSettings(value: LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings): void;
    /**
     * @stability stable
     */
    resetDiffDiskSettings(): void;
    /**
     * @stability stable
     */
    get diffDiskSettingsInput(): LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetPlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#product LinuxVirtualMachineScaleSet#product}.
     *
     * @stability stable
     */
    readonly product: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#publisher LinuxVirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
}
export declare function linuxVirtualMachineScaleSetPlanToTerraform(struct?: LinuxVirtualMachineScaleSetPlanOutputReference | LinuxVirtualMachineScaleSetPlan): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetPlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetPlan | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetRollingUpgradePolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#max_batch_instance_percent LinuxVirtualMachineScaleSet#max_batch_instance_percent}.
     *
     * @stability stable
     */
    readonly maxBatchInstancePercent: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#max_unhealthy_instance_percent LinuxVirtualMachineScaleSet#max_unhealthy_instance_percent}.
     *
     * @stability stable
     */
    readonly maxUnhealthyInstancePercent: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#max_unhealthy_upgraded_instance_percent LinuxVirtualMachineScaleSet#max_unhealthy_upgraded_instance_percent}.
     *
     * @stability stable
     */
    readonly maxUnhealthyUpgradedInstancePercent: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#pause_time_between_batches LinuxVirtualMachineScaleSet#pause_time_between_batches}.
     *
     * @stability stable
     */
    readonly pauseTimeBetweenBatches: string;
}
export declare function linuxVirtualMachineScaleSetRollingUpgradePolicyToTerraform(struct?: LinuxVirtualMachineScaleSetRollingUpgradePolicyOutputReference | LinuxVirtualMachineScaleSetRollingUpgradePolicy): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetRollingUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetRollingUpgradePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetRollingUpgradePolicy | undefined);
    private _maxBatchInstancePercent?;
    /**
     * @stability stable
     */
    get maxBatchInstancePercent(): number;
    /**
     * @stability stable
     */
    set maxBatchInstancePercent(value: number);
    /**
     * @stability stable
     */
    get maxBatchInstancePercentInput(): number | undefined;
    private _maxUnhealthyInstancePercent?;
    /**
     * @stability stable
     */
    get maxUnhealthyInstancePercent(): number;
    /**
     * @stability stable
     */
    set maxUnhealthyInstancePercent(value: number);
    /**
     * @stability stable
     */
    get maxUnhealthyInstancePercentInput(): number | undefined;
    private _maxUnhealthyUpgradedInstancePercent?;
    /**
     * @stability stable
     */
    get maxUnhealthyUpgradedInstancePercent(): number;
    /**
     * @stability stable
     */
    set maxUnhealthyUpgradedInstancePercent(value: number);
    /**
     * @stability stable
     */
    get maxUnhealthyUpgradedInstancePercentInput(): number | undefined;
    private _pauseTimeBetweenBatches?;
    /**
     * @stability stable
     */
    get pauseTimeBetweenBatches(): string;
    /**
     * @stability stable
     */
    set pauseTimeBetweenBatches(value: string);
    /**
     * @stability stable
     */
    get pauseTimeBetweenBatchesInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetSecretCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#url LinuxVirtualMachineScaleSet#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function linuxVirtualMachineScaleSetSecretCertificateToTerraform(struct?: LinuxVirtualMachineScaleSetSecretCertificate | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetSecret {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#key_vault_id LinuxVirtualMachineScaleSet#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#certificate LinuxVirtualMachineScaleSet#certificate}
     *
     * @stability stable
     */
    readonly certificate: LinuxVirtualMachineScaleSetSecretCertificate[] | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetSecretToTerraform(struct?: LinuxVirtualMachineScaleSetSecret | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetSourceImageReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#offer LinuxVirtualMachineScaleSet#offer}.
     *
     * @stability stable
     */
    readonly offer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#publisher LinuxVirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#sku LinuxVirtualMachineScaleSet#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#version LinuxVirtualMachineScaleSet#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
export declare function linuxVirtualMachineScaleSetSourceImageReferenceToTerraform(struct?: LinuxVirtualMachineScaleSetSourceImageReferenceOutputReference | LinuxVirtualMachineScaleSetSourceImageReference): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetSourceImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetSourceImageReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetSourceImageReference | undefined);
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetTerminateNotification {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enabled LinuxVirtualMachineScaleSet#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#timeout LinuxVirtualMachineScaleSet#timeout}.
     *
     * @stability stable
     */
    readonly timeout?: string;
}
export declare function linuxVirtualMachineScaleSetTerminateNotificationToTerraform(struct?: LinuxVirtualMachineScaleSetTerminateNotificationOutputReference | LinuxVirtualMachineScaleSetTerminateNotification): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetTerminateNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetTerminateNotification | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetTerminateNotification | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): string;
    /**
     * @stability stable
     */
    set timeout(value: string);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LinuxVirtualMachineScaleSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#create LinuxVirtualMachineScaleSet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#delete LinuxVirtualMachineScaleSet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#read LinuxVirtualMachineScaleSet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#update LinuxVirtualMachineScaleSet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function linuxVirtualMachineScaleSetTimeoutsToTerraform(struct?: LinuxVirtualMachineScaleSetTimeoutsOutputReference | LinuxVirtualMachineScaleSetTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LinuxVirtualMachineScaleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LinuxVirtualMachineScaleSetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set azurerm_linux_virtual_machine_scale_set}.
 *
 * @stability stable
 */
export declare class LinuxVirtualMachineScaleSet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set azurerm_linux_virtual_machine_scale_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LinuxVirtualMachineScaleSetConfig);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    resetAdminPassword(): void;
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _computerNamePrefix?;
    /**
     * @stability stable
     */
    get computerNamePrefix(): string;
    /**
     * @stability stable
     */
    set computerNamePrefix(value: string);
    /**
     * @stability stable
     */
    resetComputerNamePrefix(): void;
    /**
     * @stability stable
     */
    get computerNamePrefixInput(): string | undefined;
    private _customData?;
    /**
     * @stability stable
     */
    get customData(): string;
    /**
     * @stability stable
     */
    set customData(value: string);
    /**
     * @stability stable
     */
    resetCustomData(): void;
    /**
     * @stability stable
     */
    get customDataInput(): string | undefined;
    private _disablePasswordAuthentication?;
    /**
     * @stability stable
     */
    get disablePasswordAuthentication(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disablePasswordAuthentication(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisablePasswordAuthentication(): void;
    /**
     * @stability stable
     */
    get disablePasswordAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _doNotRunExtensionsOnOverprovisionedMachines?;
    /**
     * @stability stable
     */
    get doNotRunExtensionsOnOverprovisionedMachines(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set doNotRunExtensionsOnOverprovisionedMachines(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDoNotRunExtensionsOnOverprovisionedMachines(): void;
    /**
     * @stability stable
     */
    get doNotRunExtensionsOnOverprovisionedMachinesInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionAtHostEnabled?;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncryptionAtHostEnabled(): void;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    /**
     * @stability stable
     */
    get evictionPolicy(): string;
    /**
     * @stability stable
     */
    set evictionPolicy(value: string);
    /**
     * @stability stable
     */
    resetEvictionPolicy(): void;
    /**
     * @stability stable
     */
    get evictionPolicyInput(): string | undefined;
    private _extensionsTimeBudget?;
    /**
     * @stability stable
     */
    get extensionsTimeBudget(): string;
    /**
     * @stability stable
     */
    set extensionsTimeBudget(value: string);
    /**
     * @stability stable
     */
    resetExtensionsTimeBudget(): void;
    /**
     * @stability stable
     */
    get extensionsTimeBudgetInput(): string | undefined;
    private _healthProbeId?;
    /**
     * @stability stable
     */
    get healthProbeId(): string;
    /**
     * @stability stable
     */
    set healthProbeId(value: string);
    /**
     * @stability stable
     */
    resetHealthProbeId(): void;
    /**
     * @stability stable
     */
    get healthProbeIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instances?;
    /**
     * @stability stable
     */
    get instances(): number;
    /**
     * @stability stable
     */
    set instances(value: number);
    /**
     * @stability stable
     */
    get instancesInput(): number | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxBidPrice?;
    /**
     * @stability stable
     */
    get maxBidPrice(): number;
    /**
     * @stability stable
     */
    set maxBidPrice(value: number);
    /**
     * @stability stable
     */
    resetMaxBidPrice(): void;
    /**
     * @stability stable
     */
    get maxBidPriceInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _overprovision?;
    /**
     * @stability stable
     */
    get overprovision(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set overprovision(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOverprovision(): void;
    /**
     * @stability stable
     */
    get overprovisionInput(): boolean | cdktf.IResolvable | undefined;
    private _platformFaultDomainCount?;
    /**
     * @stability stable
     */
    get platformFaultDomainCount(): number;
    /**
     * @stability stable
     */
    set platformFaultDomainCount(value: number);
    /**
     * @stability stable
     */
    resetPlatformFaultDomainCount(): void;
    /**
     * @stability stable
     */
    get platformFaultDomainCountInput(): number | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    set priority(value: string);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): string | undefined;
    private _provisionVmAgent?;
    /**
     * @stability stable
     */
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProvisionVmAgent(): void;
    /**
     * @stability stable
     */
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _scaleInPolicy?;
    /**
     * @stability stable
     */
    get scaleInPolicy(): string;
    /**
     * @stability stable
     */
    set scaleInPolicy(value: string);
    /**
     * @stability stable
     */
    resetScaleInPolicy(): void;
    /**
     * @stability stable
     */
    get scaleInPolicyInput(): string | undefined;
    private _secureBootEnabled?;
    /**
     * @stability stable
     */
    get secureBootEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secureBootEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecureBootEnabled(): void;
    /**
     * @stability stable
     */
    get secureBootEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _singlePlacementGroup?;
    /**
     * @stability stable
     */
    get singlePlacementGroup(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set singlePlacementGroup(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSinglePlacementGroup(): void;
    /**
     * @stability stable
     */
    get singlePlacementGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _sourceImageId?;
    /**
     * @stability stable
     */
    get sourceImageId(): string;
    /**
     * @stability stable
     */
    set sourceImageId(value: string);
    /**
     * @stability stable
     */
    resetSourceImageId(): void;
    /**
     * @stability stable
     */
    get sourceImageIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get uniqueId(): string;
    private _upgradeMode?;
    /**
     * @stability stable
     */
    get upgradeMode(): string;
    /**
     * @stability stable
     */
    set upgradeMode(value: string);
    /**
     * @stability stable
     */
    resetUpgradeMode(): void;
    /**
     * @stability stable
     */
    get upgradeModeInput(): string | undefined;
    private _userData?;
    /**
     * @stability stable
     */
    get userData(): string;
    /**
     * @stability stable
     */
    set userData(value: string);
    /**
     * @stability stable
     */
    resetUserData(): void;
    /**
     * @stability stable
     */
    get userDataInput(): string | undefined;
    private _vtpmEnabled?;
    /**
     * @stability stable
     */
    get vtpmEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vtpmEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVtpmEnabled(): void;
    /**
     * @stability stable
     */
    get vtpmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneBalance?;
    /**
     * @stability stable
     */
    get zoneBalance(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneBalance(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneBalance(): void;
    /**
     * @stability stable
     */
    get zoneBalanceInput(): boolean | cdktf.IResolvable | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _additionalCapabilities;
    /**
     * @stability stable
     */
    get additionalCapabilities(): LinuxVirtualMachineScaleSetAdditionalCapabilitiesOutputReference;
    /**
     * @stability stable
     */
    putAdditionalCapabilities(value: LinuxVirtualMachineScaleSetAdditionalCapabilities): void;
    /**
     * @stability stable
     */
    resetAdditionalCapabilities(): void;
    /**
     * @stability stable
     */
    get additionalCapabilitiesInput(): LinuxVirtualMachineScaleSetAdditionalCapabilities | undefined;
    private _adminSshKey?;
    /**
     * @stability stable
     */
    get adminSshKey(): LinuxVirtualMachineScaleSetAdminSshKey[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set adminSshKey(value: LinuxVirtualMachineScaleSetAdminSshKey[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdminSshKey(): void;
    /**
     * @stability stable
     */
    get adminSshKeyInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetAdminSshKey[] | undefined;
    private _automaticInstanceRepair;
    /**
     * @stability stable
     */
    get automaticInstanceRepair(): LinuxVirtualMachineScaleSetAutomaticInstanceRepairOutputReference;
    /**
     * @stability stable
     */
    putAutomaticInstanceRepair(value: LinuxVirtualMachineScaleSetAutomaticInstanceRepair): void;
    /**
     * @stability stable
     */
    resetAutomaticInstanceRepair(): void;
    /**
     * @stability stable
     */
    get automaticInstanceRepairInput(): LinuxVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    private _automaticOsUpgradePolicy;
    /**
     * @stability stable
     */
    get automaticOsUpgradePolicy(): LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference;
    /**
     * @stability stable
     */
    putAutomaticOsUpgradePolicy(value: LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy): void;
    /**
     * @stability stable
     */
    resetAutomaticOsUpgradePolicy(): void;
    /**
     * @stability stable
     */
    get automaticOsUpgradePolicyInput(): LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined;
    private _bootDiagnostics;
    /**
     * @stability stable
     */
    get bootDiagnostics(): LinuxVirtualMachineScaleSetBootDiagnosticsOutputReference;
    /**
     * @stability stable
     */
    putBootDiagnostics(value: LinuxVirtualMachineScaleSetBootDiagnostics): void;
    /**
     * @stability stable
     */
    resetBootDiagnostics(): void;
    /**
     * @stability stable
     */
    get bootDiagnosticsInput(): LinuxVirtualMachineScaleSetBootDiagnostics | undefined;
    private _dataDisk?;
    /**
     * @stability stable
     */
    get dataDisk(): LinuxVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dataDisk(value: LinuxVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDataDisk(): void;
    /**
     * @stability stable
     */
    get dataDiskInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetDataDisk[] | undefined;
    private _extension?;
    /**
     * @stability stable
     */
    get extension(): LinuxVirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set extension(value: LinuxVirtualMachineScaleSetExtension[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExtension(): void;
    /**
     * @stability stable
     */
    get extensionInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetExtension[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): LinuxVirtualMachineScaleSetIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: LinuxVirtualMachineScaleSetIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): LinuxVirtualMachineScaleSetIdentity | undefined;
    private _networkInterface?;
    /**
     * @stability stable
     */
    get networkInterface(): LinuxVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set networkInterface(value: LinuxVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get networkInterfaceInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetNetworkInterface[] | undefined;
    private _osDisk;
    /**
     * @stability stable
     */
    get osDisk(): LinuxVirtualMachineScaleSetOsDiskOutputReference;
    /**
     * @stability stable
     */
    putOsDisk(value: LinuxVirtualMachineScaleSetOsDisk): void;
    /**
     * @stability stable
     */
    get osDiskInput(): LinuxVirtualMachineScaleSetOsDisk | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): LinuxVirtualMachineScaleSetPlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: LinuxVirtualMachineScaleSetPlan): void;
    /**
     * @stability stable
     */
    resetPlan(): void;
    /**
     * @stability stable
     */
    get planInput(): LinuxVirtualMachineScaleSetPlan | undefined;
    private _rollingUpgradePolicy;
    /**
     * @stability stable
     */
    get rollingUpgradePolicy(): LinuxVirtualMachineScaleSetRollingUpgradePolicyOutputReference;
    /**
     * @stability stable
     */
    putRollingUpgradePolicy(value: LinuxVirtualMachineScaleSetRollingUpgradePolicy): void;
    /**
     * @stability stable
     */
    resetRollingUpgradePolicy(): void;
    /**
     * @stability stable
     */
    get rollingUpgradePolicyInput(): LinuxVirtualMachineScaleSetRollingUpgradePolicy | undefined;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): LinuxVirtualMachineScaleSetSecret[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secret(value: LinuxVirtualMachineScaleSetSecret[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecret(): void;
    /**
     * @stability stable
     */
    get secretInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetSecret[] | undefined;
    private _sourceImageReference;
    /**
     * @stability stable
     */
    get sourceImageReference(): LinuxVirtualMachineScaleSetSourceImageReferenceOutputReference;
    /**
     * @stability stable
     */
    putSourceImageReference(value: LinuxVirtualMachineScaleSetSourceImageReference): void;
    /**
     * @stability stable
     */
    resetSourceImageReference(): void;
    /**
     * @stability stable
     */
    get sourceImageReferenceInput(): LinuxVirtualMachineScaleSetSourceImageReference | undefined;
    private _terminateNotification;
    /**
     * @stability stable
     */
    get terminateNotification(): LinuxVirtualMachineScaleSetTerminateNotificationOutputReference;
    /**
     * @stability stable
     */
    putTerminateNotification(value: LinuxVirtualMachineScaleSetTerminateNotification): void;
    /**
     * @stability stable
     */
    resetTerminateNotification(): void;
    /**
     * @stability stable
     */
    get terminateNotificationInput(): LinuxVirtualMachineScaleSetTerminateNotification | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LinuxVirtualMachineScaleSetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LinuxVirtualMachineScaleSetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LinuxVirtualMachineScaleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
