import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogicAppActionHttpConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#body LogicAppActionHttp#body}.
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#headers LogicAppActionHttp#headers}.
     *
     * @stability stable
     */
    readonly headers?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#logic_app_id LogicAppActionHttp#logic_app_id}.
     *
     * @stability stable
     */
    readonly logicAppId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#method LogicAppActionHttp#method}.
     *
     * @stability stable
     */
    readonly method: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#name LogicAppActionHttp#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#uri LogicAppActionHttp#uri}.
     *
     * @stability stable
     */
    readonly uri: string;
    /**
     * run_after block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#run_after LogicAppActionHttp#run_after}
     *
     * @stability stable
     */
    readonly runAfter?: LogicAppActionHttpRunAfter[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#timeouts LogicAppActionHttp#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogicAppActionHttpTimeouts;
}
/**
 * @stability stable
 */
export interface LogicAppActionHttpRunAfter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#action_name LogicAppActionHttp#action_name}.
     *
     * @stability stable
     */
    readonly actionName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#action_result LogicAppActionHttp#action_result}.
     *
     * @stability stable
     */
    readonly actionResult: string;
}
export declare function logicAppActionHttpRunAfterToTerraform(struct?: LogicAppActionHttpRunAfter | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LogicAppActionHttpTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#create LogicAppActionHttp#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#delete LogicAppActionHttp#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#read LogicAppActionHttp#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http#update LogicAppActionHttp#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logicAppActionHttpTimeoutsToTerraform(struct?: LogicAppActionHttpTimeoutsOutputReference | LogicAppActionHttpTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class LogicAppActionHttpTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppActionHttpTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppActionHttpTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http azurerm_logic_app_action_http}.
 *
 * @stability stable
 */
export declare class LogicAppActionHttp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_http azurerm_logic_app_action_http} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogicAppActionHttpConfig);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set headers(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _logicAppId?;
    /**
     * @stability stable
     */
    get logicAppId(): string;
    /**
     * @stability stable
     */
    set logicAppId(value: string);
    /**
     * @stability stable
     */
    get logicAppIdInput(): string | undefined;
    private _method?;
    /**
     * @stability stable
     */
    get method(): string;
    /**
     * @stability stable
     */
    set method(value: string);
    /**
     * @stability stable
     */
    get methodInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _uri?;
    /**
     * @stability stable
     */
    get uri(): string;
    /**
     * @stability stable
     */
    set uri(value: string);
    /**
     * @stability stable
     */
    get uriInput(): string | undefined;
    private _runAfter?;
    /**
     * @stability stable
     */
    get runAfter(): LogicAppActionHttpRunAfter[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set runAfter(value: LogicAppActionHttpRunAfter[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRunAfter(): void;
    /**
     * @stability stable
     */
    get runAfterInput(): cdktf.IResolvable | LogicAppActionHttpRunAfter[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogicAppActionHttpTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogicAppActionHttpTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogicAppActionHttpTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
