import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogicAppTriggerHttpRequestConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#logic_app_id LogicAppTriggerHttpRequest#logic_app_id}.
     *
     * @stability stable
     */
    readonly logicAppId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#method LogicAppTriggerHttpRequest#method}.
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#name LogicAppTriggerHttpRequest#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#relative_path LogicAppTriggerHttpRequest#relative_path}.
     *
     * @stability stable
     */
    readonly relativePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#schema LogicAppTriggerHttpRequest#schema}.
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#timeouts LogicAppTriggerHttpRequest#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogicAppTriggerHttpRequestTimeouts;
}
/**
 * @stability stable
 */
export interface LogicAppTriggerHttpRequestTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#create LogicAppTriggerHttpRequest#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#delete LogicAppTriggerHttpRequest#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#read LogicAppTriggerHttpRequest#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#update LogicAppTriggerHttpRequest#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logicAppTriggerHttpRequestTimeoutsToTerraform(struct?: LogicAppTriggerHttpRequestTimeoutsOutputReference | LogicAppTriggerHttpRequestTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class LogicAppTriggerHttpRequestTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppTriggerHttpRequestTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppTriggerHttpRequestTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request azurerm_logic_app_trigger_http_request}.
 *
 * @stability stable
 */
export declare class LogicAppTriggerHttpRequest extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request azurerm_logic_app_trigger_http_request} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogicAppTriggerHttpRequestConfig);
    /**
     * @stability stable
     */
    get callbackUrl(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _logicAppId?;
    /**
     * @stability stable
     */
    get logicAppId(): string;
    /**
     * @stability stable
     */
    set logicAppId(value: string);
    /**
     * @stability stable
     */
    get logicAppIdInput(): string | undefined;
    private _method?;
    /**
     * @stability stable
     */
    get method(): string;
    /**
     * @stability stable
     */
    set method(value: string);
    /**
     * @stability stable
     */
    resetMethod(): void;
    /**
     * @stability stable
     */
    get methodInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _relativePath?;
    /**
     * @stability stable
     */
    get relativePath(): string;
    /**
     * @stability stable
     */
    set relativePath(value: string);
    /**
     * @stability stable
     */
    resetRelativePath(): void;
    /**
     * @stability stable
     */
    get relativePathInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogicAppTriggerHttpRequestTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogicAppTriggerHttpRequestTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogicAppTriggerHttpRequestTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
