import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogzTagRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#logz_monitor_id LogzTagRule#logz_monitor_id}.
     *
     * @stability stable
     */
    readonly logzMonitorId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#send_aad_logs LogzTagRule#send_aad_logs}.
     *
     * @stability stable
     */
    readonly sendAadLogs?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#send_activity_logs LogzTagRule#send_activity_logs}.
     *
     * @stability stable
     */
    readonly sendActivityLogs?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#send_subscription_logs LogzTagRule#send_subscription_logs}.
     *
     * @stability stable
     */
    readonly sendSubscriptionLogs?: boolean | cdktf.IResolvable;
    /**
     * tag_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#tag_filter LogzTagRule#tag_filter}
     *
     * @stability stable
     */
    readonly tagFilter?: LogzTagRuleTagFilter[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#timeouts LogzTagRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogzTagRuleTimeouts;
}
/**
 * @stability stable
 */
export interface LogzTagRuleTagFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#action LogzTagRule#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#name LogzTagRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#value LogzTagRule#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function logzTagRuleTagFilterToTerraform(struct?: LogzTagRuleTagFilter | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LogzTagRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#create LogzTagRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#delete LogzTagRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#read LogzTagRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule#update LogzTagRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logzTagRuleTimeoutsToTerraform(struct?: LogzTagRuleTimeoutsOutputReference | LogzTagRuleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class LogzTagRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogzTagRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogzTagRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule azurerm_logz_tag_rule}.
 *
 * @stability stable
 */
export declare class LogzTagRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logz_tag_rule azurerm_logz_tag_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogzTagRuleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _logzMonitorId?;
    /**
     * @stability stable
     */
    get logzMonitorId(): string;
    /**
     * @stability stable
     */
    set logzMonitorId(value: string);
    /**
     * @stability stable
     */
    get logzMonitorIdInput(): string | undefined;
    private _sendAadLogs?;
    /**
     * @stability stable
     */
    get sendAadLogs(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendAadLogs(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendAadLogs(): void;
    /**
     * @stability stable
     */
    get sendAadLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _sendActivityLogs?;
    /**
     * @stability stable
     */
    get sendActivityLogs(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendActivityLogs(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendActivityLogs(): void;
    /**
     * @stability stable
     */
    get sendActivityLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _sendSubscriptionLogs?;
    /**
     * @stability stable
     */
    get sendSubscriptionLogs(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendSubscriptionLogs(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendSubscriptionLogs(): void;
    /**
     * @stability stable
     */
    get sendSubscriptionLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _tagFilter?;
    /**
     * @stability stable
     */
    get tagFilter(): LogzTagRuleTagFilter[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tagFilter(value: LogzTagRuleTagFilter[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTagFilter(): void;
    /**
     * @stability stable
     */
    get tagFilterInput(): cdktf.IResolvable | LogzTagRuleTagFilter[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogzTagRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogzTagRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogzTagRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
