import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorActionGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#enabled MonitorActionGroup#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#resource_group_name MonitorActionGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#short_name MonitorActionGroup#short_name}.
     *
     * @stability stable
     */
    readonly shortName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#tags MonitorActionGroup#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * arm_role_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#arm_role_receiver MonitorActionGroup#arm_role_receiver}
     *
     * @stability stable
     */
    readonly armRoleReceiver?: MonitorActionGroupArmRoleReceiver[] | cdktf.IResolvable;
    /**
     * automation_runbook_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#automation_runbook_receiver MonitorActionGroup#automation_runbook_receiver}
     *
     * @stability stable
     */
    readonly automationRunbookReceiver?: MonitorActionGroupAutomationRunbookReceiver[] | cdktf.IResolvable;
    /**
     * azure_app_push_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#azure_app_push_receiver MonitorActionGroup#azure_app_push_receiver}
     *
     * @stability stable
     */
    readonly azureAppPushReceiver?: MonitorActionGroupAzureAppPushReceiver[] | cdktf.IResolvable;
    /**
     * azure_function_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#azure_function_receiver MonitorActionGroup#azure_function_receiver}
     *
     * @stability stable
     */
    readonly azureFunctionReceiver?: MonitorActionGroupAzureFunctionReceiver[] | cdktf.IResolvable;
    /**
     * email_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#email_receiver MonitorActionGroup#email_receiver}
     *
     * @stability stable
     */
    readonly emailReceiver?: MonitorActionGroupEmailReceiver[] | cdktf.IResolvable;
    /**
     * event_hub_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#event_hub_receiver MonitorActionGroup#event_hub_receiver}
     *
     * @stability stable
     */
    readonly eventHubReceiver?: MonitorActionGroupEventHubReceiver[] | cdktf.IResolvable;
    /**
     * itsm_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#itsm_receiver MonitorActionGroup#itsm_receiver}
     *
     * @stability stable
     */
    readonly itsmReceiver?: MonitorActionGroupItsmReceiver[] | cdktf.IResolvable;
    /**
     * logic_app_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#logic_app_receiver MonitorActionGroup#logic_app_receiver}
     *
     * @stability stable
     */
    readonly logicAppReceiver?: MonitorActionGroupLogicAppReceiver[] | cdktf.IResolvable;
    /**
     * sms_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#sms_receiver MonitorActionGroup#sms_receiver}
     *
     * @stability stable
     */
    readonly smsReceiver?: MonitorActionGroupSmsReceiver[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#timeouts MonitorActionGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorActionGroupTimeouts;
    /**
     * voice_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#voice_receiver MonitorActionGroup#voice_receiver}
     *
     * @stability stable
     */
    readonly voiceReceiver?: MonitorActionGroupVoiceReceiver[] | cdktf.IResolvable;
    /**
     * webhook_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#webhook_receiver MonitorActionGroup#webhook_receiver}
     *
     * @stability stable
     */
    readonly webhookReceiver?: MonitorActionGroupWebhookReceiver[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface MonitorActionGroupArmRoleReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#role_id MonitorActionGroup#role_id}.
     *
     * @stability stable
     */
    readonly roleId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}.
     *
     * @stability stable
     */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupArmRoleReceiverToTerraform(struct?: MonitorActionGroupArmRoleReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupAutomationRunbookReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#automation_account_id MonitorActionGroup#automation_account_id}.
     *
     * @stability stable
     */
    readonly automationAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#is_global_runbook MonitorActionGroup#is_global_runbook}.
     *
     * @stability stable
     */
    readonly isGlobalRunbook: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#runbook_name MonitorActionGroup#runbook_name}.
     *
     * @stability stable
     */
    readonly runbookName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#service_uri MonitorActionGroup#service_uri}.
     *
     * @stability stable
     */
    readonly serviceUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}.
     *
     * @stability stable
     */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#webhook_resource_id MonitorActionGroup#webhook_resource_id}.
     *
     * @stability stable
     */
    readonly webhookResourceId: string;
}
export declare function monitorActionGroupAutomationRunbookReceiverToTerraform(struct?: MonitorActionGroupAutomationRunbookReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupAzureAppPushReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#email_address MonitorActionGroup#email_address}.
     *
     * @stability stable
     */
    readonly emailAddress: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function monitorActionGroupAzureAppPushReceiverToTerraform(struct?: MonitorActionGroupAzureAppPushReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupAzureFunctionReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#function_app_resource_id MonitorActionGroup#function_app_resource_id}.
     *
     * @stability stable
     */
    readonly functionAppResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#function_name MonitorActionGroup#function_name}.
     *
     * @stability stable
     */
    readonly functionName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#http_trigger_url MonitorActionGroup#http_trigger_url}.
     *
     * @stability stable
     */
    readonly httpTriggerUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}.
     *
     * @stability stable
     */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupAzureFunctionReceiverToTerraform(struct?: MonitorActionGroupAzureFunctionReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupEmailReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#email_address MonitorActionGroup#email_address}.
     *
     * @stability stable
     */
    readonly emailAddress: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}.
     *
     * @stability stable
     */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupEmailReceiverToTerraform(struct?: MonitorActionGroupEmailReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupEventHubReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#event_hub_id MonitorActionGroup#event_hub_id}.
     *
     * @stability stable
     */
    readonly eventHubId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#tenant_id MonitorActionGroup#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}.
     *
     * @stability stable
     */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupEventHubReceiverToTerraform(struct?: MonitorActionGroupEventHubReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupItsmReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#connection_id MonitorActionGroup#connection_id}.
     *
     * @stability stable
     */
    readonly connectionId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#region MonitorActionGroup#region}.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#ticket_configuration MonitorActionGroup#ticket_configuration}.
     *
     * @stability stable
     */
    readonly ticketConfiguration: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#workspace_id MonitorActionGroup#workspace_id}.
     *
     * @stability stable
     */
    readonly workspaceId: string;
}
export declare function monitorActionGroupItsmReceiverToTerraform(struct?: MonitorActionGroupItsmReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupLogicAppReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#callback_url MonitorActionGroup#callback_url}.
     *
     * @stability stable
     */
    readonly callbackUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#resource_id MonitorActionGroup#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}.
     *
     * @stability stable
     */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupLogicAppReceiverToTerraform(struct?: MonitorActionGroupLogicAppReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupSmsReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#country_code MonitorActionGroup#country_code}.
     *
     * @stability stable
     */
    readonly countryCode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#phone_number MonitorActionGroup#phone_number}.
     *
     * @stability stable
     */
    readonly phoneNumber: string;
}
export declare function monitorActionGroupSmsReceiverToTerraform(struct?: MonitorActionGroupSmsReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#create MonitorActionGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#delete MonitorActionGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#read MonitorActionGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#update MonitorActionGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorActionGroupTimeoutsToTerraform(struct?: MonitorActionGroupTimeoutsOutputReference | MonitorActionGroupTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MonitorActionGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionGroupVoiceReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#country_code MonitorActionGroup#country_code}.
     *
     * @stability stable
     */
    readonly countryCode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#phone_number MonitorActionGroup#phone_number}.
     *
     * @stability stable
     */
    readonly phoneNumber: string;
}
export declare function monitorActionGroupVoiceReceiverToTerraform(struct?: MonitorActionGroupVoiceReceiver | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorActionGroupWebhookReceiverAadAuth {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#identifier_uri MonitorActionGroup#identifier_uri}.
     *
     * @stability stable
     */
    readonly identifierUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#object_id MonitorActionGroup#object_id}.
     *
     * @stability stable
     */
    readonly objectId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#tenant_id MonitorActionGroup#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
export declare function monitorActionGroupWebhookReceiverAadAuthToTerraform(struct?: MonitorActionGroupWebhookReceiverAadAuthOutputReference | MonitorActionGroupWebhookReceiverAadAuth): any;
/**
 * @stability stable
 */
export declare class MonitorActionGroupWebhookReceiverAadAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionGroupWebhookReceiverAadAuth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionGroupWebhookReceiverAadAuth | undefined);
    private _identifierUri?;
    /**
     * @stability stable
     */
    get identifierUri(): string;
    /**
     * @stability stable
     */
    set identifierUri(value: string);
    /**
     * @stability stable
     */
    resetIdentifierUri(): void;
    /**
     * @stability stable
     */
    get identifierUriInput(): string | undefined;
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionGroupWebhookReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#service_uri MonitorActionGroup#service_uri}.
     *
     * @stability stable
     */
    readonly serviceUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}.
     *
     * @stability stable
     */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
    /**
     * aad_auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#aad_auth MonitorActionGroup#aad_auth}
     *
     * @stability stable
     */
    readonly aadAuth?: MonitorActionGroupWebhookReceiverAadAuth;
}
export declare function monitorActionGroupWebhookReceiverToTerraform(struct?: MonitorActionGroupWebhookReceiver | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group azurerm_monitor_action_group}.
 *
 * @stability stable
 */
export declare class MonitorActionGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group azurerm_monitor_action_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorActionGroupConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _shortName?;
    /**
     * @stability stable
     */
    get shortName(): string;
    /**
     * @stability stable
     */
    set shortName(value: string);
    /**
     * @stability stable
     */
    get shortNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _armRoleReceiver?;
    /**
     * @stability stable
     */
    get armRoleReceiver(): MonitorActionGroupArmRoleReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set armRoleReceiver(value: MonitorActionGroupArmRoleReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetArmRoleReceiver(): void;
    /**
     * @stability stable
     */
    get armRoleReceiverInput(): cdktf.IResolvable | MonitorActionGroupArmRoleReceiver[] | undefined;
    private _automationRunbookReceiver?;
    /**
     * @stability stable
     */
    get automationRunbookReceiver(): MonitorActionGroupAutomationRunbookReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set automationRunbookReceiver(value: MonitorActionGroupAutomationRunbookReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutomationRunbookReceiver(): void;
    /**
     * @stability stable
     */
    get automationRunbookReceiverInput(): cdktf.IResolvable | MonitorActionGroupAutomationRunbookReceiver[] | undefined;
    private _azureAppPushReceiver?;
    /**
     * @stability stable
     */
    get azureAppPushReceiver(): MonitorActionGroupAzureAppPushReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set azureAppPushReceiver(value: MonitorActionGroupAzureAppPushReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAzureAppPushReceiver(): void;
    /**
     * @stability stable
     */
    get azureAppPushReceiverInput(): cdktf.IResolvable | MonitorActionGroupAzureAppPushReceiver[] | undefined;
    private _azureFunctionReceiver?;
    /**
     * @stability stable
     */
    get azureFunctionReceiver(): MonitorActionGroupAzureFunctionReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set azureFunctionReceiver(value: MonitorActionGroupAzureFunctionReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAzureFunctionReceiver(): void;
    /**
     * @stability stable
     */
    get azureFunctionReceiverInput(): cdktf.IResolvable | MonitorActionGroupAzureFunctionReceiver[] | undefined;
    private _emailReceiver?;
    /**
     * @stability stable
     */
    get emailReceiver(): MonitorActionGroupEmailReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailReceiver(value: MonitorActionGroupEmailReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailReceiver(): void;
    /**
     * @stability stable
     */
    get emailReceiverInput(): cdktf.IResolvable | MonitorActionGroupEmailReceiver[] | undefined;
    private _eventHubReceiver?;
    /**
     * @stability stable
     */
    get eventHubReceiver(): MonitorActionGroupEventHubReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set eventHubReceiver(value: MonitorActionGroupEventHubReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEventHubReceiver(): void;
    /**
     * @stability stable
     */
    get eventHubReceiverInput(): cdktf.IResolvable | MonitorActionGroupEventHubReceiver[] | undefined;
    private _itsmReceiver?;
    /**
     * @stability stable
     */
    get itsmReceiver(): MonitorActionGroupItsmReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set itsmReceiver(value: MonitorActionGroupItsmReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetItsmReceiver(): void;
    /**
     * @stability stable
     */
    get itsmReceiverInput(): cdktf.IResolvable | MonitorActionGroupItsmReceiver[] | undefined;
    private _logicAppReceiver?;
    /**
     * @stability stable
     */
    get logicAppReceiver(): MonitorActionGroupLogicAppReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set logicAppReceiver(value: MonitorActionGroupLogicAppReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLogicAppReceiver(): void;
    /**
     * @stability stable
     */
    get logicAppReceiverInput(): cdktf.IResolvable | MonitorActionGroupLogicAppReceiver[] | undefined;
    private _smsReceiver?;
    /**
     * @stability stable
     */
    get smsReceiver(): MonitorActionGroupSmsReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set smsReceiver(value: MonitorActionGroupSmsReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSmsReceiver(): void;
    /**
     * @stability stable
     */
    get smsReceiverInput(): cdktf.IResolvable | MonitorActionGroupSmsReceiver[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorActionGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorActionGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorActionGroupTimeouts | undefined;
    private _voiceReceiver?;
    /**
     * @stability stable
     */
    get voiceReceiver(): MonitorActionGroupVoiceReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set voiceReceiver(value: MonitorActionGroupVoiceReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVoiceReceiver(): void;
    /**
     * @stability stable
     */
    get voiceReceiverInput(): cdktf.IResolvable | MonitorActionGroupVoiceReceiver[] | undefined;
    private _webhookReceiver?;
    /**
     * @stability stable
     */
    get webhookReceiver(): MonitorActionGroupWebhookReceiver[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set webhookReceiver(value: MonitorActionGroupWebhookReceiver[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWebhookReceiver(): void;
    /**
     * @stability stable
     */
    get webhookReceiverInput(): cdktf.IResolvable | MonitorActionGroupWebhookReceiver[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
