import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorDiagnosticSettingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#eventhub_authorization_rule_id MonitorDiagnosticSetting#eventhub_authorization_rule_id}.
     *
     * @stability stable
     */
    readonly eventhubAuthorizationRuleId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#eventhub_name MonitorDiagnosticSetting#eventhub_name}.
     *
     * @stability stable
     */
    readonly eventhubName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#log_analytics_destination_type MonitorDiagnosticSetting#log_analytics_destination_type}.
     *
     * @stability stable
     */
    readonly logAnalyticsDestinationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#log_analytics_workspace_id MonitorDiagnosticSetting#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#name MonitorDiagnosticSetting#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#storage_account_id MonitorDiagnosticSetting#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#target_resource_id MonitorDiagnosticSetting#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId: string;
    /**
     * log block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#log MonitorDiagnosticSetting#log}
     *
     * @stability stable
     */
    readonly log?: MonitorDiagnosticSettingLog[] | cdktf.IResolvable;
    /**
     * metric block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#metric MonitorDiagnosticSetting#metric}
     *
     * @stability stable
     */
    readonly metric?: MonitorDiagnosticSettingMetric[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#timeouts MonitorDiagnosticSetting#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorDiagnosticSettingTimeouts;
}
/**
 * @stability stable
 */
export interface MonitorDiagnosticSettingLogRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#days MonitorDiagnosticSetting#days}.
     *
     * @stability stable
     */
    readonly days?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#enabled MonitorDiagnosticSetting#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function monitorDiagnosticSettingLogRetentionPolicyToTerraform(struct?: MonitorDiagnosticSettingLogRetentionPolicyOutputReference | MonitorDiagnosticSettingLogRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class MonitorDiagnosticSettingLogRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorDiagnosticSettingLogRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorDiagnosticSettingLogRetentionPolicy | undefined);
    private _days?;
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    set days(value: number);
    /**
     * @stability stable
     */
    resetDays(): void;
    /**
     * @stability stable
     */
    get daysInput(): number | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MonitorDiagnosticSettingLog {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#category MonitorDiagnosticSetting#category}.
     *
     * @stability stable
     */
    readonly category: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#enabled MonitorDiagnosticSetting#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#retention_policy MonitorDiagnosticSetting#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy?: MonitorDiagnosticSettingLogRetentionPolicy;
}
export declare function monitorDiagnosticSettingLogToTerraform(struct?: MonitorDiagnosticSettingLog | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorDiagnosticSettingMetricRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#days MonitorDiagnosticSetting#days}.
     *
     * @stability stable
     */
    readonly days?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#enabled MonitorDiagnosticSetting#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function monitorDiagnosticSettingMetricRetentionPolicyToTerraform(struct?: MonitorDiagnosticSettingMetricRetentionPolicyOutputReference | MonitorDiagnosticSettingMetricRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class MonitorDiagnosticSettingMetricRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorDiagnosticSettingMetricRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorDiagnosticSettingMetricRetentionPolicy | undefined);
    private _days?;
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    set days(value: number);
    /**
     * @stability stable
     */
    resetDays(): void;
    /**
     * @stability stable
     */
    get daysInput(): number | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MonitorDiagnosticSettingMetric {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#category MonitorDiagnosticSetting#category}.
     *
     * @stability stable
     */
    readonly category: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#enabled MonitorDiagnosticSetting#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#retention_policy MonitorDiagnosticSetting#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy?: MonitorDiagnosticSettingMetricRetentionPolicy;
}
export declare function monitorDiagnosticSettingMetricToTerraform(struct?: MonitorDiagnosticSettingMetric | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitorDiagnosticSettingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#create MonitorDiagnosticSetting#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#delete MonitorDiagnosticSetting#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#read MonitorDiagnosticSetting#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting#update MonitorDiagnosticSetting#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorDiagnosticSettingTimeoutsToTerraform(struct?: MonitorDiagnosticSettingTimeoutsOutputReference | MonitorDiagnosticSettingTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MonitorDiagnosticSettingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorDiagnosticSettingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorDiagnosticSettingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting azurerm_monitor_diagnostic_setting}.
 *
 * @stability stable
 */
export declare class MonitorDiagnosticSetting extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_diagnostic_setting azurerm_monitor_diagnostic_setting} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorDiagnosticSettingConfig);
    private _eventhubAuthorizationRuleId?;
    /**
     * @stability stable
     */
    get eventhubAuthorizationRuleId(): string;
    /**
     * @stability stable
     */
    set eventhubAuthorizationRuleId(value: string);
    /**
     * @stability stable
     */
    resetEventhubAuthorizationRuleId(): void;
    /**
     * @stability stable
     */
    get eventhubAuthorizationRuleIdInput(): string | undefined;
    private _eventhubName?;
    /**
     * @stability stable
     */
    get eventhubName(): string;
    /**
     * @stability stable
     */
    set eventhubName(value: string);
    /**
     * @stability stable
     */
    resetEventhubName(): void;
    /**
     * @stability stable
     */
    get eventhubNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _logAnalyticsDestinationType?;
    /**
     * @stability stable
     */
    get logAnalyticsDestinationType(): string;
    /**
     * @stability stable
     */
    set logAnalyticsDestinationType(value: string);
    /**
     * @stability stable
     */
    resetLogAnalyticsDestinationType(): void;
    /**
     * @stability stable
     */
    get logAnalyticsDestinationTypeInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    resetLogAnalyticsWorkspaceId(): void;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountId(): void;
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _log?;
    /**
     * @stability stable
     */
    get log(): MonitorDiagnosticSettingLog[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set log(value: MonitorDiagnosticSettingLog[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLog(): void;
    /**
     * @stability stable
     */
    get logInput(): cdktf.IResolvable | MonitorDiagnosticSettingLog[] | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): MonitorDiagnosticSettingMetric[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metric(value: MonitorDiagnosticSettingMetric[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): cdktf.IResolvable | MonitorDiagnosticSettingMetric[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorDiagnosticSettingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorDiagnosticSettingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorDiagnosticSettingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
