import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorScheduledQueryRulesAlertConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#authorized_resource_ids MonitorScheduledQueryRulesAlert#authorized_resource_ids}.
     *
     * @stability stable
     */
    readonly authorizedResourceIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#auto_mitigation_enabled MonitorScheduledQueryRulesAlert#auto_mitigation_enabled}.
     *
     * @stability stable
     */
    readonly autoMitigationEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#data_source_id MonitorScheduledQueryRulesAlert#data_source_id}.
     *
     * @stability stable
     */
    readonly dataSourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#description MonitorScheduledQueryRulesAlert#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#enabled MonitorScheduledQueryRulesAlert#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#frequency MonitorScheduledQueryRulesAlert#frequency}.
     *
     * @stability stable
     */
    readonly frequency: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#location MonitorScheduledQueryRulesAlert#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#name MonitorScheduledQueryRulesAlert#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#query MonitorScheduledQueryRulesAlert#query}.
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#query_type MonitorScheduledQueryRulesAlert#query_type}.
     *
     * @stability stable
     */
    readonly queryType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#resource_group_name MonitorScheduledQueryRulesAlert#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#severity MonitorScheduledQueryRulesAlert#severity}.
     *
     * @stability stable
     */
    readonly severity?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#tags MonitorScheduledQueryRulesAlert#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#throttling MonitorScheduledQueryRulesAlert#throttling}.
     *
     * @stability stable
     */
    readonly throttling?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#time_window MonitorScheduledQueryRulesAlert#time_window}.
     *
     * @stability stable
     */
    readonly timeWindow: number;
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#action MonitorScheduledQueryRulesAlert#action}
     *
     * @stability stable
     */
    readonly action: MonitorScheduledQueryRulesAlertAction;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#timeouts MonitorScheduledQueryRulesAlert#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorScheduledQueryRulesAlertTimeouts;
    /**
     * trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#trigger MonitorScheduledQueryRulesAlert#trigger}
     *
     * @stability stable
     */
    readonly trigger: MonitorScheduledQueryRulesAlertTrigger;
}
/**
 * @stability stable
 */
export interface MonitorScheduledQueryRulesAlertAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#action_group MonitorScheduledQueryRulesAlert#action_group}.
     *
     * @stability stable
     */
    readonly actionGroup: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#custom_webhook_payload MonitorScheduledQueryRulesAlert#custom_webhook_payload}.
     *
     * @stability stable
     */
    readonly customWebhookPayload?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#email_subject MonitorScheduledQueryRulesAlert#email_subject}.
     *
     * @stability stable
     */
    readonly emailSubject?: string;
}
export declare function monitorScheduledQueryRulesAlertActionToTerraform(struct?: MonitorScheduledQueryRulesAlertActionOutputReference | MonitorScheduledQueryRulesAlertAction): any;
/**
 * @stability stable
 */
export declare class MonitorScheduledQueryRulesAlertActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorScheduledQueryRulesAlertAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorScheduledQueryRulesAlertAction | undefined);
    private _actionGroup?;
    /**
     * @stability stable
     */
    get actionGroup(): string[];
    /**
     * @stability stable
     */
    set actionGroup(value: string[]);
    /**
     * @stability stable
     */
    get actionGroupInput(): string[] | undefined;
    private _customWebhookPayload?;
    /**
     * @stability stable
     */
    get customWebhookPayload(): string;
    /**
     * @stability stable
     */
    set customWebhookPayload(value: string);
    /**
     * @stability stable
     */
    resetCustomWebhookPayload(): void;
    /**
     * @stability stable
     */
    get customWebhookPayloadInput(): string | undefined;
    private _emailSubject?;
    /**
     * @stability stable
     */
    get emailSubject(): string;
    /**
     * @stability stable
     */
    set emailSubject(value: string);
    /**
     * @stability stable
     */
    resetEmailSubject(): void;
    /**
     * @stability stable
     */
    get emailSubjectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorScheduledQueryRulesAlertTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#create MonitorScheduledQueryRulesAlert#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#delete MonitorScheduledQueryRulesAlert#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#read MonitorScheduledQueryRulesAlert#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#update MonitorScheduledQueryRulesAlert#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorScheduledQueryRulesAlertTimeoutsToTerraform(struct?: MonitorScheduledQueryRulesAlertTimeoutsOutputReference | MonitorScheduledQueryRulesAlertTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MonitorScheduledQueryRulesAlertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorScheduledQueryRulesAlertTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorScheduledQueryRulesAlertTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorScheduledQueryRulesAlertTriggerMetricTrigger {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#metric_column MonitorScheduledQueryRulesAlert#metric_column}.
     *
     * @stability stable
     */
    readonly metricColumn: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#metric_trigger_type MonitorScheduledQueryRulesAlert#metric_trigger_type}.
     *
     * @stability stable
     */
    readonly metricTriggerType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#operator MonitorScheduledQueryRulesAlert#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#threshold MonitorScheduledQueryRulesAlert#threshold}.
     *
     * @stability stable
     */
    readonly threshold: number;
}
export declare function monitorScheduledQueryRulesAlertTriggerMetricTriggerToTerraform(struct?: MonitorScheduledQueryRulesAlertTriggerMetricTriggerOutputReference | MonitorScheduledQueryRulesAlertTriggerMetricTrigger): any;
/**
 * @stability stable
 */
export declare class MonitorScheduledQueryRulesAlertTriggerMetricTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorScheduledQueryRulesAlertTriggerMetricTrigger | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorScheduledQueryRulesAlertTriggerMetricTrigger | undefined);
    private _metricColumn?;
    /**
     * @stability stable
     */
    get metricColumn(): string;
    /**
     * @stability stable
     */
    set metricColumn(value: string);
    /**
     * @stability stable
     */
    get metricColumnInput(): string | undefined;
    private _metricTriggerType?;
    /**
     * @stability stable
     */
    get metricTriggerType(): string;
    /**
     * @stability stable
     */
    set metricTriggerType(value: string);
    /**
     * @stability stable
     */
    get metricTriggerTypeInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _threshold?;
    /**
     * @stability stable
     */
    get threshold(): number;
    /**
     * @stability stable
     */
    set threshold(value: number);
    /**
     * @stability stable
     */
    get thresholdInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitorScheduledQueryRulesAlertTrigger {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#operator MonitorScheduledQueryRulesAlert#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#threshold MonitorScheduledQueryRulesAlert#threshold}.
     *
     * @stability stable
     */
    readonly threshold: number;
    /**
     * metric_trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert#metric_trigger MonitorScheduledQueryRulesAlert#metric_trigger}
     *
     * @stability stable
     */
    readonly metricTrigger?: MonitorScheduledQueryRulesAlertTriggerMetricTrigger;
}
export declare function monitorScheduledQueryRulesAlertTriggerToTerraform(struct?: MonitorScheduledQueryRulesAlertTriggerOutputReference | MonitorScheduledQueryRulesAlertTrigger): any;
/**
 * @stability stable
 */
export declare class MonitorScheduledQueryRulesAlertTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorScheduledQueryRulesAlertTrigger | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorScheduledQueryRulesAlertTrigger | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _threshold?;
    /**
     * @stability stable
     */
    get threshold(): number;
    /**
     * @stability stable
     */
    set threshold(value: number);
    /**
     * @stability stable
     */
    get thresholdInput(): number | undefined;
    private _metricTrigger;
    /**
     * @stability stable
     */
    get metricTrigger(): MonitorScheduledQueryRulesAlertTriggerMetricTriggerOutputReference;
    /**
     * @stability stable
     */
    putMetricTrigger(value: MonitorScheduledQueryRulesAlertTriggerMetricTrigger): void;
    /**
     * @stability stable
     */
    resetMetricTrigger(): void;
    /**
     * @stability stable
     */
    get metricTriggerInput(): MonitorScheduledQueryRulesAlertTriggerMetricTrigger | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert azurerm_monitor_scheduled_query_rules_alert}.
 *
 * @stability stable
 */
export declare class MonitorScheduledQueryRulesAlert extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_scheduled_query_rules_alert azurerm_monitor_scheduled_query_rules_alert} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorScheduledQueryRulesAlertConfig);
    private _authorizedResourceIds?;
    /**
     * @stability stable
     */
    get authorizedResourceIds(): string[];
    /**
     * @stability stable
     */
    set authorizedResourceIds(value: string[]);
    /**
     * @stability stable
     */
    resetAuthorizedResourceIds(): void;
    /**
     * @stability stable
     */
    get authorizedResourceIdsInput(): string[] | undefined;
    private _autoMitigationEnabled?;
    /**
     * @stability stable
     */
    get autoMitigationEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoMitigationEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoMitigationEnabled(): void;
    /**
     * @stability stable
     */
    get autoMitigationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dataSourceId?;
    /**
     * @stability stable
     */
    get dataSourceId(): string;
    /**
     * @stability stable
     */
    set dataSourceId(value: string);
    /**
     * @stability stable
     */
    get dataSourceIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): number;
    /**
     * @stability stable
     */
    set frequency(value: number);
    /**
     * @stability stable
     */
    get frequencyInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _queryType?;
    /**
     * @stability stable
     */
    get queryType(): string;
    /**
     * @stability stable
     */
    set queryType(value: string);
    /**
     * @stability stable
     */
    resetQueryType(): void;
    /**
     * @stability stable
     */
    get queryTypeInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _severity?;
    /**
     * @stability stable
     */
    get severity(): number;
    /**
     * @stability stable
     */
    set severity(value: number);
    /**
     * @stability stable
     */
    resetSeverity(): void;
    /**
     * @stability stable
     */
    get severityInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _throttling?;
    /**
     * @stability stable
     */
    get throttling(): number;
    /**
     * @stability stable
     */
    set throttling(value: number);
    /**
     * @stability stable
     */
    resetThrottling(): void;
    /**
     * @stability stable
     */
    get throttlingInput(): number | undefined;
    private _timeWindow?;
    /**
     * @stability stable
     */
    get timeWindow(): number;
    /**
     * @stability stable
     */
    set timeWindow(value: number);
    /**
     * @stability stable
     */
    get timeWindowInput(): number | undefined;
    private _action;
    /**
     * @stability stable
     */
    get action(): MonitorScheduledQueryRulesAlertActionOutputReference;
    /**
     * @stability stable
     */
    putAction(value: MonitorScheduledQueryRulesAlertAction): void;
    /**
     * @stability stable
     */
    get actionInput(): MonitorScheduledQueryRulesAlertAction | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorScheduledQueryRulesAlertTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorScheduledQueryRulesAlertTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorScheduledQueryRulesAlertTimeouts | undefined;
    private _trigger;
    /**
     * @stability stable
     */
    get trigger(): MonitorScheduledQueryRulesAlertTriggerOutputReference;
    /**
     * @stability stable
     */
    putTrigger(value: MonitorScheduledQueryRulesAlertTrigger): void;
    /**
     * @stability stable
     */
    get triggerInput(): MonitorScheduledQueryRulesAlertTrigger | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
