import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MssqlVirtualNetworkRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#ignore_missing_vnet_service_endpoint MssqlVirtualNetworkRule#ignore_missing_vnet_service_endpoint}.
     *
     * @stability stable
     */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#name MssqlVirtualNetworkRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#server_id MssqlVirtualNetworkRule#server_id}.
     *
     * @stability stable
     */
    readonly serverId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#subnet_id MssqlVirtualNetworkRule#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#timeouts MssqlVirtualNetworkRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MssqlVirtualNetworkRuleTimeouts;
}
/**
 * @stability stable
 */
export interface MssqlVirtualNetworkRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#create MssqlVirtualNetworkRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#delete MssqlVirtualNetworkRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#read MssqlVirtualNetworkRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#update MssqlVirtualNetworkRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mssqlVirtualNetworkRuleTimeoutsToTerraform(struct?: MssqlVirtualNetworkRuleTimeoutsOutputReference | MssqlVirtualNetworkRuleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualNetworkRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualNetworkRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualNetworkRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule azurerm_mssql_virtual_network_rule}.
 *
 * @stability stable
 */
export declare class MssqlVirtualNetworkRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule azurerm_mssql_virtual_network_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MssqlVirtualNetworkRuleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreMissingVnetServiceEndpoint?;
    /**
     * @stability stable
     */
    get ignoreMissingVnetServiceEndpoint(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreMissingVnetServiceEndpoint(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreMissingVnetServiceEndpoint(): void;
    /**
     * @stability stable
     */
    get ignoreMissingVnetServiceEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _serverId?;
    /**
     * @stability stable
     */
    get serverId(): string;
    /**
     * @stability stable
     */
    set serverId(value: string);
    /**
     * @stability stable
     */
    get serverIdInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MssqlVirtualNetworkRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MssqlVirtualNetworkRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MssqlVirtualNetworkRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
