import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkProfileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#location NetworkProfile#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#name NetworkProfile#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#resource_group_name NetworkProfile#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#tags NetworkProfile#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * container_network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#container_network_interface NetworkProfile#container_network_interface}
     *
     * @stability stable
     */
    readonly containerNetworkInterface: NetworkProfileContainerNetworkInterface;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#timeouts NetworkProfile#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkProfileTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkProfileContainerNetworkInterfaceIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#name NetworkProfile#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#subnet_id NetworkProfile#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function networkProfileContainerNetworkInterfaceIpConfigurationToTerraform(struct?: NetworkProfileContainerNetworkInterfaceIpConfiguration | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface NetworkProfileContainerNetworkInterface {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#name NetworkProfile#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#ip_configuration NetworkProfile#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration: NetworkProfileContainerNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
}
export declare function networkProfileContainerNetworkInterfaceToTerraform(struct?: NetworkProfileContainerNetworkInterfaceOutputReference | NetworkProfileContainerNetworkInterface): any;
/**
 * @stability stable
 */
export declare class NetworkProfileContainerNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkProfileContainerNetworkInterface | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkProfileContainerNetworkInterface | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _ipConfiguration?;
    /**
     * @stability stable
     */
    get ipConfiguration(): NetworkProfileContainerNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ipConfiguration(value: NetworkProfileContainerNetworkInterfaceIpConfiguration[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get ipConfigurationInput(): cdktf.IResolvable | NetworkProfileContainerNetworkInterfaceIpConfiguration[] | undefined;
}
/**
 * @stability stable
 */
export interface NetworkProfileTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#create NetworkProfile#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#delete NetworkProfile#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#read NetworkProfile#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile#update NetworkProfile#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkProfileTimeoutsToTerraform(struct?: NetworkProfileTimeoutsOutputReference | NetworkProfileTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class NetworkProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkProfileTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile azurerm_network_profile}.
 *
 * @stability stable
 */
export declare class NetworkProfile extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_profile azurerm_network_profile} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkProfileConfig);
    /**
     * @stability stable
     */
    get containerNetworkInterfaceIds(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _containerNetworkInterface;
    /**
     * @stability stable
     */
    get containerNetworkInterface(): NetworkProfileContainerNetworkInterfaceOutputReference;
    /**
     * @stability stable
     */
    putContainerNetworkInterface(value: NetworkProfileContainerNetworkInterface): void;
    /**
     * @stability stable
     */
    get containerNetworkInterfaceInput(): NetworkProfileContainerNetworkInterface | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkProfileTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkProfileTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
