import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivateDnsSrvRecordConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#name PrivateDnsSrvRecord#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#resource_group_name PrivateDnsSrvRecord#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#tags PrivateDnsSrvRecord#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#ttl PrivateDnsSrvRecord#ttl}.
     *
     * @stability stable
     */
    readonly ttl: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#zone_name PrivateDnsSrvRecord#zone_name}.
     *
     * @stability stable
     */
    readonly zoneName: string;
    /**
     * record block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#record PrivateDnsSrvRecord#record}
     *
     * @stability stable
     */
    readonly record: PrivateDnsSrvRecordRecord[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#timeouts PrivateDnsSrvRecord#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivateDnsSrvRecordTimeouts;
}
/**
 * @stability stable
 */
export interface PrivateDnsSrvRecordRecord {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#port PrivateDnsSrvRecord#port}.
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#priority PrivateDnsSrvRecord#priority}.
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#target PrivateDnsSrvRecord#target}.
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#weight PrivateDnsSrvRecord#weight}.
     *
     * @stability stable
     */
    readonly weight: number;
}
export declare function privateDnsSrvRecordRecordToTerraform(struct?: PrivateDnsSrvRecordRecord | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface PrivateDnsSrvRecordTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#create PrivateDnsSrvRecord#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#delete PrivateDnsSrvRecord#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#read PrivateDnsSrvRecord#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#update PrivateDnsSrvRecord#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function privateDnsSrvRecordTimeoutsToTerraform(struct?: PrivateDnsSrvRecordTimeoutsOutputReference | PrivateDnsSrvRecordTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class PrivateDnsSrvRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivateDnsSrvRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivateDnsSrvRecordTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record azurerm_private_dns_srv_record}.
 *
 * @stability stable
 */
export declare class PrivateDnsSrvRecord extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record azurerm_private_dns_srv_record} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivateDnsSrvRecordConfig);
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    set ttl(value: number);
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
    private _zoneName?;
    /**
     * @stability stable
     */
    get zoneName(): string;
    /**
     * @stability stable
     */
    set zoneName(value: string);
    /**
     * @stability stable
     */
    get zoneNameInput(): string | undefined;
    private _record?;
    /**
     * @stability stable
     */
    get record(): PrivateDnsSrvRecordRecord[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set record(value: PrivateDnsSrvRecordRecord[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get recordInput(): cdktf.IResolvable | PrivateDnsSrvRecordRecord[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PrivateDnsSrvRecordTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivateDnsSrvRecordTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivateDnsSrvRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
