import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RecoveryServicesVaultConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#location RecoveryServicesVault#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#name RecoveryServicesVault#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#resource_group_name RecoveryServicesVault#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#sku RecoveryServicesVault#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#soft_delete_enabled RecoveryServicesVault#soft_delete_enabled}.
     *
     * @stability stable
     */
    readonly softDeleteEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#storage_mode_type RecoveryServicesVault#storage_mode_type}.
     *
     * @stability stable
     */
    readonly storageModeType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#tags RecoveryServicesVault#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#encryption RecoveryServicesVault#encryption}
     *
     * @stability stable
     */
    readonly encryption?: RecoveryServicesVaultEncryption;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#identity RecoveryServicesVault#identity}
     *
     * @stability stable
     */
    readonly identity?: RecoveryServicesVaultIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#timeouts RecoveryServicesVault#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RecoveryServicesVaultTimeouts;
}
/**
 * @stability stable
 */
export interface RecoveryServicesVaultEncryption {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#infrastructure_encryption_enabled RecoveryServicesVault#infrastructure_encryption_enabled}.
     *
     * @stability stable
     */
    readonly infrastructureEncryptionEnabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#key_id RecoveryServicesVault#key_id}.
     *
     * @stability stable
     */
    readonly keyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#use_system_assigned_identity RecoveryServicesVault#use_system_assigned_identity}.
     *
     * @stability stable
     */
    readonly useSystemAssignedIdentity?: boolean | cdktf.IResolvable;
}
export declare function recoveryServicesVaultEncryptionToTerraform(struct?: RecoveryServicesVaultEncryptionOutputReference | RecoveryServicesVaultEncryption): any;
/**
 * @stability stable
 */
export declare class RecoveryServicesVaultEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RecoveryServicesVaultEncryption | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RecoveryServicesVaultEncryption | undefined);
    private _infrastructureEncryptionEnabled?;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set infrastructureEncryptionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyId?;
    /**
     * @stability stable
     */
    get keyId(): string;
    /**
     * @stability stable
     */
    set keyId(value: string);
    /**
     * @stability stable
     */
    get keyIdInput(): string | undefined;
    private _useSystemAssignedIdentity?;
    /**
     * @stability stable
     */
    get useSystemAssignedIdentity(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useSystemAssignedIdentity(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseSystemAssignedIdentity(): void;
    /**
     * @stability stable
     */
    get useSystemAssignedIdentityInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface RecoveryServicesVaultIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#type RecoveryServicesVault#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function recoveryServicesVaultIdentityToTerraform(struct?: RecoveryServicesVaultIdentityOutputReference | RecoveryServicesVaultIdentity): any;
/**
 * @stability stable
 */
export declare class RecoveryServicesVaultIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RecoveryServicesVaultIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RecoveryServicesVaultIdentity | undefined);
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RecoveryServicesVaultTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#create RecoveryServicesVault#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#delete RecoveryServicesVault#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#read RecoveryServicesVault#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault#update RecoveryServicesVault#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function recoveryServicesVaultTimeoutsToTerraform(struct?: RecoveryServicesVaultTimeoutsOutputReference | RecoveryServicesVaultTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class RecoveryServicesVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RecoveryServicesVaultTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RecoveryServicesVaultTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault azurerm_recovery_services_vault}.
 *
 * @stability stable
 */
export declare class RecoveryServicesVault extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/recovery_services_vault azurerm_recovery_services_vault} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RecoveryServicesVaultConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _softDeleteEnabled?;
    /**
     * @stability stable
     */
    get softDeleteEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set softDeleteEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSoftDeleteEnabled(): void;
    /**
     * @stability stable
     */
    get softDeleteEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageModeType?;
    /**
     * @stability stable
     */
    get storageModeType(): string;
    /**
     * @stability stable
     */
    set storageModeType(value: string);
    /**
     * @stability stable
     */
    resetStorageModeType(): void;
    /**
     * @stability stable
     */
    get storageModeTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _encryption;
    /**
     * @stability stable
     */
    get encryption(): RecoveryServicesVaultEncryptionOutputReference;
    /**
     * @stability stable
     */
    putEncryption(value: RecoveryServicesVaultEncryption): void;
    /**
     * @stability stable
     */
    resetEncryption(): void;
    /**
     * @stability stable
     */
    get encryptionInput(): RecoveryServicesVaultEncryption | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): RecoveryServicesVaultIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: RecoveryServicesVaultIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): RecoveryServicesVaultIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): RecoveryServicesVaultTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RecoveryServicesVaultTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RecoveryServicesVaultTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
